/***************************************************************************
 *   Copyright (C) 2005-2006 Gao Xianchao                                  *
 *                 2007 Gao Xianchao gnap_an linux_lyb ahlongxp            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/*
 * Author:	gxc
 * Create data:	2004-03-09 20:09
 */

#ifndef _BDICT_H_
#define _BDICT_H_

#include <iostream>
#include <string>
#include <map>
#include "bobject.h"

class CBDict:public CBObject
{
public:
	CBDict(void)
		:CBObject(4)
		{};
	~CBDict(void)
	{
		clear();
	};

	typedef std::map<std::string,CBObject*> CONTAINER;
private:
	CONTAINER m_value;
	void clear()
	{
		while(!m_value.empty())
		{
			delete (*(m_value.begin())).second;
			m_value.erase(m_value.begin());
		}
	};
public:
	unsigned int getCount(void)
	{
		return m_value.size();
	};
	
	CBObject* getValue(const char* key)
	{
		CONTAINER::iterator iter=m_value.find(key);
		if(iter!=m_value.end())
		{
			return (*iter).second;
		}
		else
		{
			return NULL;
		}
	};
	
	CBObject* getValue(unsigned int index)
	{
		if(index<m_value.size())
		{
			CONTAINER::iterator iter=m_value.begin();
			for(unsigned int i=0;i<index;++i)
			{
				iter++;
			}	
			
			return iter->second;
		}
		else
		{
			return NULL;
		}
	};
	
	const char* getKey(unsigned int index)
	{
		if(index<m_value.size())
		{
			CONTAINER::iterator iter=m_value.begin();
			for(unsigned int i=0;i<index;++i)
			{
				iter++;
			}
			
			return iter->first.c_str();
		}
		else
		{
			return NULL;
		}	
	}
	
	int parse(const char* buf,unsigned long bufLen);
	
	void get_bestr(std::string& str)
	{
		char buf[128];
		
		str+="d";
		CONTAINER::iterator iter=m_value.begin();
		for(;iter!=m_value.end();++iter)
		{
			memset(buf,0,sizeof(buf));
			sprintf(buf,"%u",iter->first.length());
			str+=buf;
			str+=":";
			str+=iter->first;
			
			iter->second->get_bestr(str);			
		}
		str+="e";
	}
};

#endif

