/***************************************************************************
 *   Copyright (C) 2005-2006 Gao Xianchao                                  *
 *                 2007 Gao Xianchao gnap_an linux_lyb ahlongxp            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/*
 * Author:	gxc
 * Create data:	2005-10-22 20:09
 */
 
#ifndef LITEWINDOW_H_
#define LITEWINDOW_H_

#include <string>
#include <gtk/gtk.h>
#include "BitStorm.h"

class CLiteWindow
{
public:
	CLiteWindow();
	virtual ~CLiteWindow();
private:
	IBTTask* _task;
	GtkWidget* _window;
	GtkWidget* _taskNameLabel;
	GtkWidget* _totalSizeLabel;
	GtkWidget* _progressBar;
	GtkWidget* _timeLabel;
	GtkWidget* _downloadToLabel;
	GtkWidget* _downloadRateLabel;
	GtkWidget* _downloadedLabel;
	GtkWidget* _peersLabel;
	GtkWidget* _uploadRateLabel;
	GtkWidget* _uploadedLabel;
	GtkWidget* _shareLabel;
	GtkWidget* _aboutButton;
	GtkWidget* _pauseButton;
	GtkWidget* _exitButton;
	GtkWidget* _maxUploadButton;
	GtkWidget* _maxUploadSpin;
	GtkWidget* _maxDownloadSpin;
	GtkWidget* _cacheSizeSpin;
	
	unsigned int _startTick;
private:
	void createWindow();
	void updateGUI();	
	
	static gboolean delete_event(GtkWidget* widget, GdkEvent* event, gpointer data);
	static void destroy(GtkWidget* widget, gpointer data);
	static gboolean timerFunc(gpointer data); 
	static void exit_button_clicked_event(GtkWidget* widget, gpointer data);
	static void about_button_clicked_event(GtkWidget* widget, gpointer data);
public:
	void run(IBTTask* task);		
	
	static std::string getUserInputTorrentFilePath();
	static std::string getUserInputDestPath(const char* fileName);
	static void showMessage(const char* msg);
};

#endif /*LITEWINDOW_H_*/
