/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.rsrc;

import com.kreative.ksfl.KSFLUtilities;
import com.kreative.rsrc.MacResource;
import com.kreative.rsrc.MacResourceAlreadyExistsException;
import com.kreative.rsrc.MacResourceProvider;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class MacResourceFile
extends MacResourceProvider {
    public static final int CREATE_NEVER = 0;
    public static final int CREATE_IF_EMPTY = 1;
    public static final int CREATE_ALWAYS = 2;
    private RandomAccessFile raf;
    private boolean readOnly = false;
    private int resMap;
    private int typeList;
    private int nameList;
    private int resData;
    private int resMapLen;
    private int resDataLen;
    private String textEncoding = "MACROMAN";
    private static final int INSERTED_TYPE_RECORD = 1;
    private static final int INSERTED_OBJECT_RECORD = 2;
    private static final int INSERTED_NAME = 3;
    private static final int INSERTED_DATA = 4;
    private static final int REMOVED_TYPE_RECORD = 1;
    private static final int REMOVED_OBJECT_RECORD = 2;
    private static final int REMOVED_NAME = 3;
    private static final int REMOVED_DATA = 4;

    private String gps(int b) {
        try {
            this.raf.seek(b);
            int l = this.raf.readByte() & 0xFF;
            byte[] s = new byte[l];
            this.raf.read(s);
            try {
                return new String(s, this.textEncoding);
            }
            catch (UnsupportedEncodingException uue) {
                return new String(s);
            }
        }
        catch (IOException e) {
            return "";
        }
    }

    private byte[] gb(String a) {
        try {
            return a.getBytes(this.textEncoding);
        }
        catch (UnsupportedEncodingException uue) {
            return a.getBytes();
        }
    }

    private int[] locateType(int type) {
        try {
            this.raf.seek(this.typeList);
            int m = this.raf.readShort() + 1;
            int i = 0;
            while (i < m) {
                int t = this.raf.readInt();
                if (t == type) {
                    int cnt = this.raf.readShort() + 1;
                    int lst = this.typeList + this.raf.readShort();
                    return new int[]{this.typeList + 2 + 8 * i, cnt, lst};
                }
                this.raf.readInt();
                ++i;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private int[] locate(int type, short id) {
        try {
            int[] t = this.locateType(type);
            if (t != null) {
                this.raf.seek(t[2]);
                int i = 0;
                while (i < t[1]) {
                    short thisid = this.raf.readShort();
                    if (thisid == id) {
                        short n = this.raf.readShort();
                        int d = this.raf.readInt() & 0xFFFFFF;
                        return new int[]{t[0], t[1], t[2], t[2] + 12 * i, n < 0 ? 0 : this.nameList + n, d < 0 ? 0 : this.resData + d};
                    }
                    this.raf.skipBytes(10);
                    ++i;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private int[] locate(int type, String name) {
        try {
            int[] t = this.locateType(type);
            if (t != null) {
                int i = 0;
                while (i < t[1]) {
                    this.raf.seek(t[2] + 12 * i + 2);
                    short n = this.raf.readShort();
                    if (n >= 0 && this.gps(this.nameList + n).equals(name)) {
                        this.raf.seek(t[2] + 12 * i + 4);
                        int d = this.raf.readInt() & 0xFFFFFF;
                        return new int[]{t[0], t[1], t[2], t[2] + 12 * i, n < 0 ? 0 : this.nameList + n, d < 0 ? 0 : this.resData + d};
                    }
                    ++i;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private void cut(int[] loc, int offset, int length, int what, int type, short id) throws IOException {
        boolean typeListAdjusted = false;
        boolean nameListAdjusted = false;
        boolean resDataAdjusted = false;
        KSFLUtilities.cut(this.raf, (long)offset, length);
        if (this.resMap > offset) {
            this.resMap -= length;
        }
        if (this.typeList > offset) {
            this.typeList -= length;
            typeListAdjusted = true;
        }
        if (this.nameList > offset) {
            this.nameList -= length;
            nameListAdjusted = true;
        }
        if (this.resData > offset) {
            this.resData -= length;
            resDataAdjusted = true;
        }
        if (what == 1 || what == 2 || what == 3) {
            this.resMapLen -= length;
        }
        if (what == 4) {
            this.resDataLen -= length;
        }
        if (loc != null) {
            if (loc.length > 0 && loc[0] > offset) {
                loc[0] = loc[0] - length;
            }
            if (loc.length > 1 && what == 2) {
                loc[1] = loc[1] - 1;
            }
            if (loc.length > 2 && loc[2] > offset) {
                loc[2] = loc[2] - length;
            }
            if (loc.length > 3 && loc[3] > offset) {
                loc[3] = loc[3] - length;
            }
            if (loc.length > 4 && loc[4] > offset) {
                loc[4] = loc[4] - length;
            }
            if (loc.length > 5 && loc[5] > offset) {
                loc[5] = loc[5] - length;
            }
        }
        this.raf.seek(0L);
        this.raf.writeInt(this.resData);
        this.raf.writeInt(this.resMap);
        this.raf.writeInt(this.resDataLen);
        this.raf.writeInt(this.resMapLen);
        this.raf.seek(this.resMap);
        this.raf.writeInt(this.resData);
        this.raf.writeInt(this.resMap);
        this.raf.writeInt(this.resDataLen);
        this.raf.writeInt(this.resMapLen);
        this.raf.seek(this.resMap + 24);
        this.raf.writeShort(this.typeList - this.resMap);
        this.raf.writeShort(this.nameList - this.resMap);
        this.raf.seek(this.typeList);
        int numtypes = this.raf.readShort() + 1;
        if (what == 1) {
            this.raf.seek(this.typeList);
            this.raf.writeShort(--numtypes - 1);
        }
        int i = 0;
        while (i < numtypes) {
            this.raf.seek(this.typeList + 2 + 8 * i);
            int thistype = this.raf.readInt();
            int numrefs = this.raf.readShort() + 1;
            if (what == 2 && thistype == type) {
                this.raf.seek(this.typeList + 2 + 8 * i + 4);
                this.raf.writeShort(--numrefs - 1);
            }
            int reflist = this.typeList + this.raf.readShort();
            if (!typeListAdjusted && reflist > offset) {
                this.raf.seek(this.typeList + 2 + 8 * i + 6);
                this.raf.writeShort((reflist -= length) - this.typeList);
            }
            int j = 0;
            while (j < numrefs) {
                this.raf.seek(reflist + 12 * j);
                this.raf.readShort();
                short name = this.raf.readShort();
                int dattr = this.raf.readInt();
                int data = dattr & 0xFFFFFF;
                int attr = dattr & 0xFF000000;
                if (name >= 0 && !nameListAdjusted && this.nameList + name > offset) {
                    this.raf.seek(reflist + 12 * j + 2);
                    this.raf.writeShort(name - length);
                }
                if (data >= 0 && !resDataAdjusted && this.resData + data > offset) {
                    this.raf.seek(reflist + 12 * j + 4);
                    this.raf.writeInt(data - length & 0xFFFFFF | attr);
                }
                ++j;
            }
            ++i;
        }
    }

    private void paste(int[] loc, int offset, byte[] stuff, int what, int type, short id) throws IOException {
        boolean typeListAdjusted = false;
        boolean nameListAdjusted = false;
        boolean resDataAdjusted = false;
        KSFLUtilities.paste(this.raf, (long)offset, stuff);
        if (this.resMap >= offset) {
            this.resMap += stuff.length;
        }
        if (this.typeList >= offset) {
            this.typeList += stuff.length;
            typeListAdjusted = true;
        }
        if (this.nameList > offset || this.nameList == offset && what != 3) {
            this.nameList += stuff.length;
            nameListAdjusted = true;
        }
        if (this.resData > offset || this.resData == offset && what != 4) {
            this.resData += stuff.length;
            resDataAdjusted = true;
        }
        if (what == 1 || what == 2 || what == 3) {
            this.resMapLen += stuff.length;
        }
        if (what == 4) {
            this.resDataLen += stuff.length;
        }
        if (loc != null) {
            if (loc.length > 0 && (loc[0] > offset || loc[0] == offset && what != 1)) {
                loc[0] = loc[0] + stuff.length;
            }
            if (loc.length > 1 && what == 2) {
                loc[1] = loc[1] + 1;
            }
            if (loc.length > 2 && (loc[2] > offset || loc[2] == offset && what != 2)) {
                loc[2] = loc[2] + stuff.length;
            }
            if (loc.length > 3 && (loc[3] > offset || loc[3] == offset && what != 2)) {
                loc[3] = loc[3] + stuff.length;
            }
            if (loc.length > 4 && (loc[4] > offset || loc[4] == offset && what != 3)) {
                loc[4] = loc[4] + stuff.length;
            }
            if (loc.length > 5 && (loc[5] > offset || loc[5] == offset && what != 4)) {
                loc[5] = loc[5] + stuff.length;
            }
        }
        this.raf.seek(0L);
        this.raf.writeInt(this.resData);
        this.raf.writeInt(this.resMap);
        this.raf.writeInt(this.resDataLen);
        this.raf.writeInt(this.resMapLen);
        this.raf.seek(this.resMap);
        this.raf.writeInt(this.resData);
        this.raf.writeInt(this.resMap);
        this.raf.writeInt(this.resDataLen);
        this.raf.writeInt(this.resMapLen);
        this.raf.seek(this.resMap + 24);
        this.raf.writeShort(this.typeList - this.resMap);
        this.raf.writeShort(this.nameList - this.resMap);
        this.raf.seek(this.typeList);
        int numtypes = this.raf.readShort() + 1;
        if (what == 1) {
            this.raf.seek(this.typeList);
            this.raf.writeShort(++numtypes - 1);
        }
        int i = 0;
        while (i < numtypes) {
            this.raf.seek(this.typeList + 2 + 8 * i);
            int thistype = this.raf.readInt();
            int numrefs = this.raf.readShort() + 1;
            if (what == 2 && thistype == type) {
                this.raf.seek(this.typeList + 2 + 8 * i + 4);
                this.raf.writeShort(++numrefs - 1);
            }
            int reflist = this.typeList + this.raf.readShort();
            if (!(typeListAdjusted || reflist <= offset && (reflist != offset || what == 2 && thistype == type))) {
                this.raf.seek(this.typeList + 2 + 8 * i + 6);
                this.raf.writeShort((reflist += stuff.length) - this.typeList);
            }
            int j = 0;
            while (j < numrefs) {
                this.raf.seek(reflist + 12 * j);
                short thisid = this.raf.readShort();
                short name = this.raf.readShort();
                int dattr = this.raf.readInt();
                int data = dattr & 0xFFFFFF;
                int attr = dattr & 0xFF000000;
                if (!(name < 0 || nameListAdjusted || this.nameList + name <= offset && (this.nameList + name != offset || what == 3 && thistype == type && thisid == id))) {
                    this.raf.seek(reflist + 12 * j + 2);
                    this.raf.writeShort(name + stuff.length);
                }
                if (!(data < 0 || resDataAdjusted || this.resData + data <= offset && (this.resData + data != offset || what == 4 && thistype == type && thisid == id))) {
                    this.raf.seek(reflist + 12 * j + 4);
                    this.raf.writeInt(data + stuff.length & 0xFFFFFF | attr);
                }
                ++j;
            }
            ++i;
        }
    }

    public MacResourceFile(File f, String mode, int create) throws IOException {
        this.raf = new RandomAccessFile(f, mode);
        this.readOnly = mode.equalsIgnoreCase("r");
        if (create == 2 || create == 1 && this.raf.length() == 0L) {
            this.raf.setLength(286L);
            this.raf.seek(0L);
            this.raf.writeInt(256);
            this.raf.writeInt(256);
            this.raf.writeInt(0);
            this.raf.writeInt(30);
            this.raf.seek(256L);
            this.raf.writeInt(256);
            this.raf.writeInt(256);
            this.raf.writeInt(0);
            this.raf.writeInt(30);
            this.raf.writeInt(0);
            this.raf.writeShort(0);
            this.raf.writeShort(0);
            this.raf.writeShort(28);
            this.raf.writeShort(30);
            this.raf.writeShort(-1);
            this.resData = 256;
            this.resMap = 256;
            this.resDataLen = 0;
            this.resMapLen = 30;
            this.typeList = 284;
            this.nameList = 286;
        } else {
            this.raf.seek(0L);
            this.resData = this.raf.readInt();
            this.resMap = this.raf.readInt();
            this.resDataLen = this.raf.readInt();
            this.resMapLen = this.raf.readInt();
            this.raf.seek(this.resMap + 24);
            this.typeList = this.resMap + this.raf.readShort();
            this.nameList = this.resMap + this.raf.readShort();
        }
    }

    public synchronized String getTextEncoding() {
        return this.textEncoding;
    }

    public synchronized void setTextEncoding(String encoding) {
        this.textEncoding = encoding;
    }

    public RandomAccessFile getRandomAccessFile() {
        return this.raf;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public synchronized void flush() {
    }

    @Override
    public synchronized void close() {
        try {
            this.raf.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public synchronized short getResourceMapAttributes() {
        try {
            this.raf.seek(this.resMap + 22);
            return this.raf.readShort();
        }
        catch (IOException e) {
            return 0;
        }
    }

    @Override
    public synchronized void setResourceMapAttributes(short attr) {
        try {
            this.raf.seek(this.resMap + 22);
            this.raf.writeShort(attr);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public synchronized boolean add(MacResource r) throws MacResourceAlreadyExistsException {
        try {
            if (this.locate(r.type, r.id) != null) {
                throw new MacResourceAlreadyExistsException();
            }
            if (this.locateType(r.type) == null) {
                byte[] th = new byte[8];
                KSFLUtilities.putInt(th, 0, r.type);
                KSFLUtilities.putShort(th, 4, (short)-1);
                KSFLUtilities.putShort(th, 6, (short)(this.nameList - this.typeList));
                this.raf.seek(this.typeList);
                int lasttype = this.typeList + 2 + 8 * (this.raf.readShort() + 1);
                this.paste(null, lasttype, th, 1, r.type, r.id);
            }
            int[] t = this.locateType(r.type);
            byte[] ref = new byte[12];
            KSFLUtilities.putShort(ref, 0, r.id);
            KSFLUtilities.putShort(ref, 2, r.name != null && r.name.length() > 0 ? (short)(this.resMap + this.resMapLen - this.nameList) : (short)-1);
            KSFLUtilities.putInt(ref, 4, this.resDataLen);
            ref[4] = r.getAttributes();
            KSFLUtilities.putInt(ref, 8, 0);
            this.paste(null, t[2] + 12 * t[1], ref, 2, r.type, r.id);
            if (r.name != null && r.name.length() > 0) {
                byte[] n = this.gb(r.name);
                if (n.length > 255) {
                    n = KSFLUtilities.copy(n, 0, 255);
                }
                n = KSFLUtilities.paste(n, 0, new byte[]{(byte)n.length});
                this.paste(null, this.resMap + this.resMapLen, n, 3, r.type, r.id);
            }
            byte[] d = KSFLUtilities.paste(r.data, 0, 4);
            KSFLUtilities.putInt(d, 0, r.data.length);
            this.paste(null, this.resData + this.resDataLen, d, 4, r.type, r.id);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public synchronized boolean contains(int type, short id) {
        return this.locate(type, id) != null;
    }

    @Override
    public synchronized boolean contains(int type, String name) {
        return this.locate(type, name) != null;
    }

    @Override
    public synchronized MacResource get(int type, short id) {
        try {
            int[] l = this.locate(type, id);
            if (l != null) {
                this.raf.seek(l[0]);
                int t = this.raf.readInt();
                this.raf.seek(l[3]);
                short i = this.raf.readShort();
                this.raf.seek(l[3] + 4);
                byte a = this.raf.readByte();
                this.raf.seek(l[5]);
                int dl = this.raf.readInt();
                return new MacResource(t, i, a, l[4] > 0 ? this.gps(l[4]) : "", l[5] > 0 ? KSFLUtilities.copy(this.raf, (long)(l[5] + 4), dl) : new byte[]{});
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public synchronized MacResource get(int type, String name) {
        try {
            int[] l = this.locate(type, name);
            if (l != null) {
                this.raf.seek(l[0]);
                int t = this.raf.readInt();
                this.raf.seek(l[3]);
                short i = this.raf.readShort();
                this.raf.seek(l[3] + 4);
                byte a = this.raf.readByte();
                this.raf.seek(l[5]);
                int dl = this.raf.readInt();
                return new MacResource(t, i, a, l[4] > 0 ? this.gps(l[4]) : "", l[5] > 0 ? KSFLUtilities.copy(this.raf, (long)(l[5] + 4), dl) : new byte[]{});
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public synchronized MacResource getAttributes(int type, short id) {
        try {
            int[] l = this.locate(type, id);
            if (l != null) {
                this.raf.seek(l[0]);
                int t = this.raf.readInt();
                this.raf.seek(l[3]);
                short i = this.raf.readShort();
                this.raf.seek(l[3] + 4);
                byte a = this.raf.readByte();
                return new MacResource(t, i, a, l[4] > 0 ? this.gps(l[4]) : "", new byte[0]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public synchronized MacResource getAttributes(int type, String name) {
        try {
            int[] l = this.locate(type, name);
            if (l != null) {
                this.raf.seek(l[0]);
                int t = this.raf.readInt();
                this.raf.seek(l[3]);
                short i = this.raf.readShort();
                this.raf.seek(l[3] + 4);
                byte a = this.raf.readByte();
                return new MacResource(t, i, a, l[4] > 0 ? this.gps(l[4]) : "", new byte[0]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public synchronized byte[] getData(int type, short id) {
        try {
            int[] l = this.locate(type, id);
            if (l != null) {
                this.raf.seek(l[5]);
                int dl = this.raf.readInt();
                return l[5] > 0 ? KSFLUtilities.copy(this.raf, (long)(l[5] + 4), dl) : new byte[]{};
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public synchronized byte[] getData(int type, String name) {
        try {
            int[] l = this.locate(type, name);
            if (l != null) {
                this.raf.seek(l[5]);
                int dl = this.raf.readInt();
                return l[5] > 0 ? KSFLUtilities.copy(this.raf, (long)(l[5] + 4), dl) : new byte[]{};
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public synchronized boolean remove(int type, short id) {
        try {
            int[] loc = this.locate(type, id);
            if (loc != null) {
                if (loc[5] > 0) {
                    this.raf.seek(loc[5]);
                    int dlen = this.raf.readInt() + 4;
                    this.cut(loc, loc[5], dlen, 4, type, id);
                }
                if (loc[4] > 0) {
                    this.raf.seek(loc[4]);
                    int nlen = (this.raf.readByte() & 0xFF) + 1;
                    this.cut(loc, loc[4], nlen, 3, type, id);
                }
                this.cut(loc, loc[3], 12, 2, type, id);
                if (loc[1] <= 0) {
                    this.cut(loc, loc[0], 8, 1, type, id);
                }
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public synchronized boolean remove(int type, String name) {
        try {
            int[] loc = this.locate(type, name);
            if (loc != null) {
                this.raf.seek(loc[3]);
                short id = this.raf.readShort();
                if (loc[5] > 0) {
                    this.raf.seek(loc[5]);
                    int dlen = this.raf.readInt() + 4;
                    this.cut(loc, loc[5], dlen, 4, type, id);
                }
                if (loc[4] > 0) {
                    this.raf.seek(loc[4]);
                    int nlen = (this.raf.readByte() & 0xFF) + 1;
                    this.cut(loc, loc[4], nlen, 3, type, id);
                }
                this.cut(loc, loc[3], 12, 2, type, id);
                if (loc[1] <= 0) {
                    this.cut(loc, loc[0], 8, 1, type, id);
                }
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public synchronized boolean set(int type, short id, MacResource r) throws MacResourceAlreadyExistsException {
        if (!this.contains(type, id)) {
            return false;
        }
        if (r.name == null) {
            r.name = "";
        }
        if (r.data == null) {
            r.data = new byte[0];
        }
        return this.setAttributes(type, id, r) && this.setData(r.type, r.id, r.data);
    }

    @Override
    public synchronized boolean set(int type, String name, MacResource r) throws MacResourceAlreadyExistsException {
        short id = this.getIDFromName(type, name);
        if (!this.contains(type, id)) {
            return false;
        }
        if (r.name == null) {
            r.name = "";
        }
        if (r.data == null) {
            r.data = new byte[0];
        }
        return this.setAttributes(type, id, r) && this.setData(r.type, r.id, r.data);
    }

    @Override
    public synchronized boolean setAttributes(int type, short id, MacResource r) throws MacResourceAlreadyExistsException {
        try {
            int[] loc = this.locate(type, id);
            if (loc != null) {
                int[] loce = this.locate(r.type, r.id);
                if (loce != null && (loce[0] != loc[0] || loce[1] != loc[1] || loce[2] != loc[2] || loce[3] != loc[3] || loce[4] != loc[4] || loce[5] != loc[5])) {
                    throw new MacResourceAlreadyExistsException();
                }
                if (type != r.type) {
                    if (this.locateType(r.type) == null) {
                        byte[] th = new byte[8];
                        KSFLUtilities.putInt(th, 0, r.type);
                        KSFLUtilities.putShort(th, 4, (short)-1);
                        KSFLUtilities.putShort(th, 6, (short)(this.nameList - this.typeList));
                        this.raf.seek(this.typeList);
                        int lasttype = this.typeList + 2 + 8 * (this.raf.readShort() + 1);
                        this.paste(loc, lasttype, th, 1, r.type, r.id);
                    }
                    int[] t = this.locateType(r.type);
                    byte[] ref = new byte[12];
                    KSFLUtilities.putShort(ref, 0, r.id);
                    KSFLUtilities.putShort(ref, 2, loc[4] > 0 ? (short)(loc[4] - this.nameList) : (short)-1);
                    KSFLUtilities.putInt(ref, 4, loc[5] > 0 ? loc[5] - this.resData : -1);
                    ref[4] = r.getAttributes();
                    KSFLUtilities.putInt(ref, 8, 0);
                    this.paste(loc, t[2] + 12 * t[1], ref, 2, r.type, r.id);
                    this.cut(loc, loc[3], 12, 2, type, id);
                    this.raf.seek(loc[0] + 4);
                    if (this.raf.readShort() < 0) {
                        this.cut(loc, loc[0], 8, 1, type, id);
                    }
                } else {
                    this.raf.seek(loc[3]);
                    this.raf.writeShort(r.id);
                    this.raf.skipBytes(2);
                    this.raf.writeByte(r.getAttributes());
                }
                if (r.name != null && r.name.length() > 0) {
                    byte[] n = this.gb(r.name);
                    if (n.length > 255) {
                        n = KSFLUtilities.copy(n, 0, 255);
                    }
                    n = KSFLUtilities.paste(n, 0, new byte[]{(byte)n.length});
                    if (loc[4] > 0) {
                        this.paste(loc, loc[4], n, 3, r.type, r.id);
                        this.raf.seek(loc[4] + n.length);
                        int nl = (this.raf.readByte() & 0xFF) + 1;
                        this.cut(loc, loc[4] + n.length, nl, 3, r.type, r.id);
                    } else {
                        this.raf.seek(loc[3] + 2);
                        this.raf.writeShort(this.resMap + this.resMapLen - this.nameList);
                        this.paste(loc, this.resMap + this.resMapLen, n, 3, r.type, r.id);
                    }
                } else if (loc[4] > 0) {
                    this.raf.seek(loc[4]);
                    int nl = (this.raf.readByte() & 0xFF) + 1;
                    this.cut(loc, loc[4], nl, 3, r.type, r.id);
                    this.raf.seek(loc[3] + 2);
                    this.raf.writeShort(-1);
                    loc[4] = 0;
                }
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public synchronized boolean setAttributes(int type, String name, MacResource r) throws MacResourceAlreadyExistsException {
        try {
            int[] loc = this.locate(type, name);
            if (loc != null) {
                int[] loce = this.locate(r.type, r.id);
                if (loce != null && (loce[0] != loc[0] || loce[1] != loc[1] || loce[2] != loc[2] || loce[3] != loc[3] || loce[4] != loc[4] || loce[5] != loc[5])) {
                    throw new MacResourceAlreadyExistsException();
                }
                this.raf.seek(loc[3]);
                short id = this.raf.readShort();
                if (type != r.type) {
                    if (this.locateType(r.type) == null) {
                        byte[] th = new byte[8];
                        KSFLUtilities.putInt(th, 0, r.type);
                        KSFLUtilities.putShort(th, 4, (short)-1);
                        KSFLUtilities.putShort(th, 6, (short)(this.nameList - this.typeList));
                        this.raf.seek(this.typeList);
                        int lasttype = this.typeList + 2 + 8 * (this.raf.readShort() + 1);
                        this.paste(loc, lasttype, th, 1, r.type, r.id);
                    }
                    int[] t = this.locateType(r.type);
                    byte[] ref = new byte[12];
                    KSFLUtilities.putShort(ref, 0, r.id);
                    KSFLUtilities.putShort(ref, 2, loc[4] > 0 ? (short)(loc[4] - this.nameList) : (short)-1);
                    KSFLUtilities.putInt(ref, 4, loc[5] > 0 ? loc[5] - this.resData : -1);
                    ref[4] = r.getAttributes();
                    KSFLUtilities.putInt(ref, 8, 0);
                    this.paste(loc, t[2] + 12 * t[1], ref, 2, r.type, r.id);
                    this.cut(loc, loc[3], 12, 2, type, id);
                    this.raf.seek(loc[0] + 4);
                    if (this.raf.readShort() < 0) {
                        this.cut(loc, loc[0], 8, 1, type, id);
                    }
                } else {
                    this.raf.seek(loc[3]);
                    this.raf.writeShort(r.id);
                    this.raf.skipBytes(2);
                    this.raf.writeByte(r.getAttributes());
                }
                if (r.name != null && r.name.length() > 0) {
                    byte[] n = this.gb(r.name);
                    if (n.length > 255) {
                        n = KSFLUtilities.copy(n, 0, 255);
                    }
                    n = KSFLUtilities.paste(n, 0, new byte[]{(byte)n.length});
                    if (loc[4] > 0) {
                        this.paste(loc, loc[4], n, 3, r.type, r.id);
                        this.raf.seek(loc[4] + n.length);
                        int nl = (this.raf.readByte() & 0xFF) + 1;
                        this.cut(loc, loc[4] + n.length, nl, 3, r.type, r.id);
                    } else {
                        this.raf.seek(loc[3] + 2);
                        this.raf.writeShort(this.resMap + this.resMapLen - this.nameList);
                        this.paste(loc, this.resMap + this.resMapLen, n, 3, r.type, r.id);
                    }
                } else if (loc[4] > 0) {
                    this.raf.seek(loc[4]);
                    int nl = (this.raf.readByte() & 0xFF) + 1;
                    this.cut(loc, loc[4], nl, 3, r.type, r.id);
                    this.raf.seek(loc[3] + 2);
                    this.raf.writeShort(-1);
                    loc[4] = 0;
                }
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public synchronized boolean setData(int type, short id, byte[] data) {
        try {
            int[] loc = this.locate(type, id);
            if (loc != null) {
                if (loc[5] > 0) {
                    this.raf.seek(loc[5]);
                    int dlen = this.raf.readInt() + 4;
                    this.cut(loc, loc[5], dlen, 4, type, id);
                } else {
                    loc[5] = this.resData + this.resDataLen;
                }
                byte[] d = KSFLUtilities.paste(data, 0, 4);
                KSFLUtilities.putInt(d, 0, data.length);
                this.paste(loc, loc[5], d, 4, type, id);
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public synchronized boolean setData(int type, String name, byte[] data) {
        try {
            int[] loc = this.locate(type, name);
            if (loc != null) {
                this.raf.seek(loc[3]);
                short id = this.raf.readShort();
                if (loc[5] > 0) {
                    this.raf.seek(loc[5]);
                    int dlen = this.raf.readInt() + 4;
                    this.cut(loc, loc[5], dlen, 4, type, id);
                } else {
                    loc[5] = this.resData + this.resDataLen;
                }
                byte[] d = KSFLUtilities.paste(data, 0, 4);
                KSFLUtilities.putInt(d, 0, data.length);
                this.paste(loc, loc[5], d, 4, type, id);
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public synchronized int getTypeCount() {
        try {
            this.raf.seek(this.typeList);
            return this.raf.readShort() + 1;
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    @Override
    public synchronized int getType(int index) {
        try {
            this.raf.seek(this.typeList + 2 + 8 * index);
            return this.raf.readInt();
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    @Override
    public synchronized int[] getTypes() {
        try {
            this.raf.seek(this.typeList);
            int m = this.raf.readShort() + 1;
            int[] a = new int[m];
            int i = 0;
            while (i < m) {
                a[i] = this.raf.readInt();
                this.raf.readInt();
                ++i;
            }
            return a;
        }
        catch (IOException iOException) {
            return new int[0];
        }
    }

    @Override
    public synchronized int getResourceCount(int type) {
        int[] t = this.locateType(type);
        if (t != null) {
            return t[1];
        }
        return 0;
    }

    @Override
    public synchronized short getID(int type, int index) {
        try {
            int[] t = this.locateType(type);
            if (t != null) {
                this.raf.seek(t[2] + 12 * index);
                return this.raf.readShort();
            }
            return 0;
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    @Override
    public synchronized short[] getIDs(int type) {
        try {
            int[] t = this.locateType(type);
            if (t != null) {
                short[] a = new short[t[1]];
                int i = 0;
                while (i < t[1]) {
                    this.raf.seek(t[2] + 12 * i);
                    a[i] = this.raf.readShort();
                    ++i;
                }
                return a;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new short[0];
    }

    @Override
    public synchronized String getName(int type, int index) {
        block3: {
            short n;
            block4: {
                int[] t = this.locateType(type);
                if (t == null) break block3;
                this.raf.seek(t[2] + 12 * index + 2);
                n = this.raf.readShort();
                if (n >= 0) break block4;
                return "";
            }
            try {
                return this.gps(this.nameList + n);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return "";
    }

    @Override
    public synchronized String[] getNames(int type) {
        ArrayList<String> a = new ArrayList<String>();
        try {
            int[] t = this.locateType(type);
            if (t != null) {
                int i = 0;
                while (i < t[1]) {
                    this.raf.seek(t[2] + 12 * i + 2);
                    short n = this.raf.readShort();
                    if (n < 0) {
                        a.add("");
                    } else {
                        a.add(this.gps(this.nameList + n));
                    }
                    ++i;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return a.toArray(new String[0]);
    }

    @Override
    public synchronized short getNextAvailableID(int type, short start) {
        try {
            ArrayList<Short> a = new ArrayList<Short>();
            int[] t = this.locateType(type);
            if (t != null) {
                int i = 0;
                while (i < t[1]) {
                    this.raf.seek(t[2] + 12 * i);
                    a.add(this.raf.readShort());
                    ++i;
                }
            }
            short next = start;
            while (a.contains(next)) {
                next = (short)(next + 1);
            }
            return next;
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    @Override
    public synchronized String getNameFromID(int type, short id) {
        int[] l = this.locate(type, id);
        if (l != null) {
            return l[4] > 0 ? this.gps(l[4]) : "";
        }
        return "";
    }

    @Override
    public synchronized short getIDFromName(int type, String name) {
        try {
            int[] l = this.locate(type, name);
            if (l != null) {
                this.raf.seek(l[3]);
                return this.raf.readShort();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 0;
    }
}

