/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.cff;

import com.kreative.cff.Chunk;
import com.kreative.cff.ChunkFile;
import com.kreative.cff.ChunkSpec;
import com.kreative.cff.FieldSize;
import com.kreative.cff.FieldSpec;
import com.kreative.cff.FieldType;
import com.kreative.cff.Header;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;

public class ChunkFileSpec
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final ChunkFileSpec CFSPEC_IFF = new ChunkFileSpec(new ChunkSpec(), new ChunkSpec(new FieldSpec[]{new FieldSpec(FieldType.CHARACTER_TYPE, FieldSize.MEDIUM), new FieldSpec(FieldType.SIZE_WITHOUT_HEADER, FieldSize.MEDIUM), FieldSpec.DATA}, true));
    public static final ChunkFileSpec CFSPEC_RIFF = new ChunkFileSpec(new ChunkSpec(), new ChunkSpec(new FieldSpec[]{new FieldSpec(FieldType.CHARACTER_TYPE, FieldSize.MEDIUM), new FieldSpec(FieldType.SIZE_WITHOUT_HEADER, FieldSize.MEDIUM, true), FieldSpec.DATA}, true));
    public static final ChunkFileSpec CFSPEC_MIDI = new ChunkFileSpec(new ChunkSpec(), new ChunkSpec(new FieldSpec[]{new FieldSpec(FieldType.CHARACTER_TYPE, FieldSize.MEDIUM), new FieldSpec(FieldType.SIZE_WITHOUT_HEADER, FieldSize.MEDIUM), FieldSpec.DATA}));
    public static final ChunkFileSpec CFSPEC_PNG = new ChunkFileSpec(new ChunkSpec(new FieldSpec[]{new FieldSpec(FieldType.INTEGER_TYPE, FieldSize.LONG)}), new ChunkSpec(new FieldSpec[]{new FieldSpec(FieldType.SIZE_WITHOUT_HEADER, FieldSize.MEDIUM), new FieldSpec(FieldType.CHARACTER_TYPE, FieldSize.MEDIUM), FieldSpec.DATA, new FieldSpec(FieldType.CHECKSUM, FieldSize.MEDIUM)}));
    public static final ChunkFileSpec CFSPEC_ICNS = new ChunkFileSpec(new ChunkSpec(new FieldSpec[]{new FieldSpec(FieldType.CHARACTER_TYPE, FieldSize.MEDIUM), new FieldSpec(FieldType.SIZE_WITH_HEADER, FieldSize.MEDIUM)}), new ChunkSpec(new FieldSpec[]{new FieldSpec(FieldType.CHARACTER_TYPE, FieldSize.MEDIUM), new FieldSpec(FieldType.SIZE_WITH_HEADER, FieldSize.MEDIUM), FieldSpec.DATA}));
    public static final ChunkFileSpec CFSPEC_HYPERCARD = new ChunkFileSpec(new ChunkSpec(), new ChunkSpec(new FieldSpec[]{new FieldSpec(FieldType.SIZE_WITH_HEADER, FieldSize.MEDIUM), new FieldSpec(FieldType.CHARACTER_TYPE, FieldSize.MEDIUM), new FieldSpec(FieldType.ID_NUMBER, FieldSize.MEDIUM), new FieldSpec(FieldType.FILLER, FieldSize.MEDIUM), FieldSpec.DATA}));
    public static final ChunkFileSpec CFSPEC_DFF1BE = new ChunkFileSpec(new ChunkSpec(new FieldSpec[]{new FieldSpec(FieldType.CHARACTER_TYPE, FieldSize.MEDIUM)}), new ChunkSpec(new FieldSpec[]{new FieldSpec(FieldType.CHARACTER_TYPE, FieldSize.LONG), new FieldSpec(FieldType.ID_NUMBER, FieldSize.SHORT), new FieldSpec(FieldType.FILLER, FieldSize.SHORT), new FieldSpec(FieldType.SIZE_WITHOUT_HEADER, FieldSize.MEDIUM), FieldSpec.DATA}));
    public static final ChunkFileSpec CFSPEC_DFF1LE = new ChunkFileSpec(new ChunkSpec(new FieldSpec[]{new FieldSpec(FieldType.CHARACTER_TYPE, FieldSize.MEDIUM, true)}), new ChunkSpec(new FieldSpec[]{new FieldSpec(FieldType.CHARACTER_TYPE, FieldSize.LONG, true), new FieldSpec(FieldType.ID_NUMBER, FieldSize.SHORT, true), new FieldSpec(FieldType.FILLER, FieldSize.SHORT, true), new FieldSpec(FieldType.SIZE_WITHOUT_HEADER, FieldSize.MEDIUM, true), FieldSpec.DATA}));
    private ChunkSpec fileHeaderSpec;
    private ChunkSpec chunkHeaderSpec;

    public ChunkFileSpec(ChunkSpec fileHS, ChunkSpec chunkHS) {
        this.fileHeaderSpec = fileHS;
        this.chunkHeaderSpec = chunkHS;
    }

    public ChunkFileSpec(String spec) {
        String[] things = spec.trim().split("[:;=]+");
        switch (things.length) {
            case 0: {
                this.fileHeaderSpec = new ChunkSpec();
                this.chunkHeaderSpec = new ChunkSpec();
                break;
            }
            case 1: {
                this.fileHeaderSpec = new ChunkSpec();
                this.chunkHeaderSpec = new ChunkSpec(things[0]);
                break;
            }
            default: {
                this.fileHeaderSpec = new ChunkSpec(things[0]);
                this.chunkHeaderSpec = new ChunkSpec(things[1]);
            }
        }
    }

    public ChunkFileSpec(byte[] spec, int index) {
        this.fileHeaderSpec = new ChunkSpec(spec, index);
        this.chunkHeaderSpec = new ChunkSpec(spec, index + 1 + this.fileHeaderSpec.size());
    }

    public ChunkSpec fileHeaderSpec() {
        return this.fileHeaderSpec;
    }

    public ChunkSpec chunkHeaderSpec() {
        return this.chunkHeaderSpec;
    }

    public String stringRepresentation() {
        String a = this.fileHeaderSpec.stringRepresentation();
        String b = this.chunkHeaderSpec.stringRepresentation();
        if (a == null || a.length() == 0) {
            return b;
        }
        return String.valueOf(a) + ":" + b;
    }

    public byte[] bitPatternRepresentation() {
        byte[] a = this.fileHeaderSpec.bitPatternRepresentation();
        byte[] b = this.chunkHeaderSpec.bitPatternRepresentation();
        byte[] c = new byte[a.length + b.length];
        int ci = 0;
        int ai = 0;
        while (ai < a.length) {
            c[ci] = a[ai];
            ++ai;
            ++ci;
        }
        int bi = 0;
        while (bi < b.length) {
            c[ci] = b[bi];
            ++bi;
            ++ci;
        }
        return c;
    }

    public ChunkFile readChunkHeaders(DataInput in) throws IOException {
        Header fh = this.fileHeaderSpec.readHeader(in);
        ChunkFile cf = new ChunkFile(fh);
        if (fh.containsKey((Object)FieldType.CHUNK_COUNT)) {
            long i = 0L;
            long c = ((Number)fh.get((Object)FieldType.CHUNK_COUNT)).longValue();
            while (i < c) {
                Header h = this.chunkHeaderSpec.readHeader(in);
                ++i;
                cf.add(new Chunk(h, new byte[0]));
            }
        } else if (fh.containsKey((Object)FieldType.SIZE_WITHOUT_HEADER)) {
            long i = 0L;
            long c = ((Number)fh.get((Object)FieldType.SIZE_WITHOUT_HEADER)).longValue();
            while (i < c) {
                long dl;
                Header h = this.chunkHeaderSpec.readHeader(in);
                long l = h.containsKey((Object)FieldType.SIZE_WITH_HEADER) ? ((Number)h.get((Object)FieldType.SIZE_WITH_HEADER)).longValue() : (dl = h.containsKey((Object)FieldType.SIZE_WITHOUT_HEADER) ? (long)this.chunkHeaderSpec.byteCount() + ((Number)h.get((Object)FieldType.SIZE_WITHOUT_HEADER)).longValue() : 0L);
                if (this.chunkHeaderSpec.evenPadded() && dl % 2L == 1L) {
                    ++dl;
                }
                i += dl;
                cf.add(new Chunk(h, new byte[0]));
            }
        } else if (fh.containsKey((Object)FieldType.SIZE_WITH_HEADER)) {
            long i = this.fileHeaderSpec.byteCount();
            long c = ((Number)fh.get((Object)FieldType.SIZE_WITH_HEADER)).longValue();
            while (i < c) {
                long dl;
                Header h = this.chunkHeaderSpec.readHeader(in);
                long l = h.containsKey((Object)FieldType.SIZE_WITH_HEADER) ? ((Number)h.get((Object)FieldType.SIZE_WITH_HEADER)).longValue() : (dl = h.containsKey((Object)FieldType.SIZE_WITHOUT_HEADER) ? (long)this.chunkHeaderSpec.byteCount() + ((Number)h.get((Object)FieldType.SIZE_WITHOUT_HEADER)).longValue() : 0L);
                if (this.chunkHeaderSpec.evenPadded() && dl % 2L == 1L) {
                    ++dl;
                }
                i += dl;
                cf.add(new Chunk(h, new byte[0]));
            }
        } else {
            try {
                while (true) {
                    Header h = this.chunkHeaderSpec.readHeader(in);
                    cf.add(new Chunk(h, new byte[0]));
                }
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }
        return cf;
    }

    public ChunkFile readChunkFile(DataInput in) throws IOException {
        Header fh = this.fileHeaderSpec.readHeader(in);
        ChunkFile cf = new ChunkFile(fh);
        if (fh.containsKey((Object)FieldType.CHUNK_COUNT)) {
            long i = 0L;
            long c = ((Number)fh.get((Object)FieldType.CHUNK_COUNT)).longValue();
            while (i < c) {
                Chunk ch = this.chunkHeaderSpec.readChunk(in);
                ++i;
                cf.add(ch);
            }
        } else if (fh.containsKey((Object)FieldType.SIZE_WITHOUT_HEADER)) {
            long i = 0L;
            long c = ((Number)fh.get((Object)FieldType.SIZE_WITHOUT_HEADER)).longValue();
            while (i < c) {
                Chunk ch = this.chunkHeaderSpec.readChunk(in);
                i += (long)(this.chunkHeaderSpec.byteCount() + ch.getData().length);
                if (this.chunkHeaderSpec.evenPadded() && ch.getData().length % 2 == 1) {
                    ++i;
                }
                cf.add(ch);
            }
        } else if (fh.containsKey((Object)FieldType.SIZE_WITH_HEADER)) {
            long i = this.fileHeaderSpec.byteCount();
            long c = ((Number)fh.get((Object)FieldType.SIZE_WITH_HEADER)).longValue();
            while (i < c) {
                Chunk ch = this.chunkHeaderSpec.readChunk(in);
                i += (long)(this.chunkHeaderSpec.byteCount() + ch.getData().length);
                if (this.chunkHeaderSpec.evenPadded() && ch.getData().length % 2 == 1) {
                    ++i;
                }
                cf.add(ch);
            }
        } else {
            try {
                while (true) {
                    Chunk ch = this.chunkHeaderSpec.readChunk(in);
                    cf.add(ch);
                }
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }
        return cf;
    }

    public void writeChunkFile(DataOutput out, ChunkFile cf) throws IOException {
        long l;
        Header fh = cf.getHeader();
        if (fh.containsKey((Object)FieldType.CHUNK_COUNT)) {
            fh.put(FieldType.CHUNK_COUNT, cf.size());
        }
        if (fh.containsKey((Object)FieldType.SIZE_WITHOUT_HEADER)) {
            l = this.chunkHeaderSpec.byteCount() * cf.size();
            for (Chunk ch : cf) {
                l += (long)ch.getData().length;
                if (!this.chunkHeaderSpec.evenPadded() || ch.getData().length % 2 != 1) continue;
                ++l;
            }
            fh.put(FieldType.SIZE_WITHOUT_HEADER, l);
        }
        if (fh.containsKey((Object)FieldType.SIZE_WITH_HEADER)) {
            l = this.fileHeaderSpec.byteCount() + this.chunkHeaderSpec.byteCount() * cf.size();
            for (Chunk ch : cf) {
                l += (long)ch.getData().length;
                if (!this.chunkHeaderSpec.evenPadded() || ch.getData().length % 2 != 1) continue;
                ++l;
            }
            fh.put(FieldType.SIZE_WITH_HEADER, l);
        }
        this.fileHeaderSpec.writeHeader(out, fh);
        for (Chunk ch : cf) {
            this.chunkHeaderSpec.writeChunk(out, ch);
        }
    }

    public boolean equals(Object o) {
        return o instanceof ChunkFileSpec && ((ChunkFileSpec)o).fileHeaderSpec.equals(this.fileHeaderSpec) && ((ChunkFileSpec)o).chunkHeaderSpec.equals(this.chunkHeaderSpec);
    }

    public int hashCode() {
        return this.fileHeaderSpec.hashCode() ^ this.chunkHeaderSpec.hashCode();
    }
}

