# THIS FILE IS AUTOMATICALLY GENERATED.  EDIT THE SOURCE FILE NOT THIS ONE

"""Various descriptions of data specific to LG VX8500"""

from common import PhoneBookBusyException

from prototypes import *
from prototypeslg import *

# Make all lg stuff available in this module as well
from p_lg import *

# we are the same as lgvx8300 except as noted below
from p_brew import *
from p_lgvx8300 import *

# We use LSB for all integer like fields
UINT=UINTlsb
BOOL=BOOLlsb

# Phonebook stuff
RTPathIndexFile='pim/pbRingIdSetAsPath.dat'
MsgRTIndexFile='pim/pbMsgRingIdSetAsPath.dat'
WPPathIndexFile='pim/pbPictureIdSetAsPath.dat'
pb_file_name='pim/pbentry.dat'

#Play List stuff
PLIndexFileName='dload/aodplaylist.lgpl'
PLFilePath='dload'
PLExt='.clgpl'
PLMaxSize=50    # Max number of items per playlist

# T9 User Database, how do we handle the Spanish DB?
T9USERDBFILENAME='t9udb/t9udb_eng.dat'
Default_Header='\x36\x00' \
               '\x00\x00\x00\x00\x00\x00\x00\x00'
Default_Header2=        '\xFB\x07\xF6\x0F\xF1\x17' \
                '\xEC\x1F\xE7\x27\xE2\x2F\xDD\x37' \
                '\xD8\x3F\xD3\x47'
class pbfileentry(BaseProtogenClass):
    __fields=['serial1', 'entrynumber', 'data1', 'ringtone', 'msgringtone', 'wallpaper', 'data2']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(pbfileentry,self).__init__(**dict)
        if self.__class__ is pbfileentry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(pbfileentry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(pbfileentry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_serial1.writetobuffer(buf)
        self.__field_entrynumber.writetobuffer(buf)
        self.__field_data1.writetobuffer(buf)
        self.__field_ringtone.writetobuffer(buf)
        self.__field_msgringtone.writetobuffer(buf)
        self.__field_wallpaper.writetobuffer(buf)
        self.__field_data2.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_serial1=UINT(**{'sizeinbytes': 4})
        self.__field_serial1.readfrombuffer(buf)
        self.__field_entrynumber=UINT(**{'sizeinbytes': 2})
        self.__field_entrynumber.readfrombuffer(buf)
        self.__field_data1=DATA(**{'sizeinbytes': 123})
        self.__field_data1.readfrombuffer(buf)
        self.__field_ringtone=UINT(**{'sizeinbytes': 2})
        self.__field_ringtone.readfrombuffer(buf)
        self.__field_msgringtone=UINT(**{'sizeinbytes': 2})
        self.__field_msgringtone.readfrombuffer(buf)
        self.__field_wallpaper=UINT(**{'sizeinbytes': 2})
        self.__field_wallpaper.readfrombuffer(buf)
        self.__field_data2=DATA(**{'sizeinbytes': 250})
        self.__field_data2.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_serial1(self):
        return self.__field_serial1.getvalue()

    def __setfield_serial1(self, value):
        if isinstance(value,UINT):
            self.__field_serial1=value
        else:
            self.__field_serial1=UINT(value,**{'sizeinbytes': 4})

    def __delfield_serial1(self): del self.__field_serial1

    serial1=property(__getfield_serial1, __setfield_serial1, __delfield_serial1, None)

    def __getfield_entrynumber(self):
        return self.__field_entrynumber.getvalue()

    def __setfield_entrynumber(self, value):
        if isinstance(value,UINT):
            self.__field_entrynumber=value
        else:
            self.__field_entrynumber=UINT(value,**{'sizeinbytes': 2})

    def __delfield_entrynumber(self): del self.__field_entrynumber

    entrynumber=property(__getfield_entrynumber, __setfield_entrynumber, __delfield_entrynumber, None)

    def __getfield_data1(self):
        return self.__field_data1.getvalue()

    def __setfield_data1(self, value):
        if isinstance(value,DATA):
            self.__field_data1=value
        else:
            self.__field_data1=DATA(value,**{'sizeinbytes': 123})

    def __delfield_data1(self): del self.__field_data1

    data1=property(__getfield_data1, __setfield_data1, __delfield_data1, None)

    def __getfield_ringtone(self):
        return self.__field_ringtone.getvalue()

    def __setfield_ringtone(self, value):
        if isinstance(value,UINT):
            self.__field_ringtone=value
        else:
            self.__field_ringtone=UINT(value,**{'sizeinbytes': 2})

    def __delfield_ringtone(self): del self.__field_ringtone

    ringtone=property(__getfield_ringtone, __setfield_ringtone, __delfield_ringtone, None)

    def __getfield_msgringtone(self):
        return self.__field_msgringtone.getvalue()

    def __setfield_msgringtone(self, value):
        if isinstance(value,UINT):
            self.__field_msgringtone=value
        else:
            self.__field_msgringtone=UINT(value,**{'sizeinbytes': 2})

    def __delfield_msgringtone(self): del self.__field_msgringtone

    msgringtone=property(__getfield_msgringtone, __setfield_msgringtone, __delfield_msgringtone, None)

    def __getfield_wallpaper(self):
        return self.__field_wallpaper.getvalue()

    def __setfield_wallpaper(self, value):
        if isinstance(value,UINT):
            self.__field_wallpaper=value
        else:
            self.__field_wallpaper=UINT(value,**{'sizeinbytes': 2})

    def __delfield_wallpaper(self): del self.__field_wallpaper

    wallpaper=property(__getfield_wallpaper, __setfield_wallpaper, __delfield_wallpaper, None)

    def __getfield_data2(self):
        return self.__field_data2.getvalue()

    def __setfield_data2(self, value):
        if isinstance(value,DATA):
            self.__field_data2=value
        else:
            self.__field_data2=DATA(value,**{'sizeinbytes': 250})

    def __delfield_data2(self): del self.__field_data2

    data2=property(__getfield_data2, __setfield_data2, __delfield_data2, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('serial1', self.__field_serial1, None)
        yield ('entrynumber', self.__field_entrynumber, None)
        yield ('data1', self.__field_data1, None)
        yield ('ringtone', self.__field_ringtone, None)
        yield ('msgringtone', self.__field_msgringtone, None)
        yield ('wallpaper', self.__field_wallpaper, None)
        yield ('data2', self.__field_data2, None)




class pbfile(BaseProtogenClass):
    __fields=['items']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(pbfile,self).__init__(**dict)
        if self.__class__ is pbfile:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(pbfile,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(pbfile,kwargs)
        if len(args):
            dict2={ 'elementclass': pbfileentry }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_items=LIST(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_items.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_items=LIST(**{ 'elementclass': pbfileentry })
        self.__field_items.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_items(self):
        return self.__field_items.getvalue()

    def __setfield_items(self, value):
        if isinstance(value,LIST):
            self.__field_items=value
        else:
            self.__field_items=LIST(value,**{ 'elementclass': pbfileentry })

    def __delfield_items(self): del self.__field_items

    items=property(__getfield_items, __setfield_items, __delfield_items, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('items', self.__field_items, None)




class PathIndexEntry(BaseProtogenClass):
    __fields=['pathname']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(PathIndexEntry,self).__init__(**dict)
        if self.__class__ is PathIndexEntry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(PathIndexEntry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(PathIndexEntry,kwargs)
        if len(args):
            dict2={'sizeinbytes': 255,  'encoding': PHONE_ENCODING,                  'default': '' }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_pathname=USTRING(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_pathname
        except:
            self.__field_pathname=USTRING(**{'sizeinbytes': 255,  'encoding': PHONE_ENCODING,                  'default': '' })
        self.__field_pathname.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_pathname=USTRING(**{'sizeinbytes': 255,  'encoding': PHONE_ENCODING,                  'default': '' })
        self.__field_pathname.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_pathname(self):
        try: self.__field_pathname
        except:
            self.__field_pathname=USTRING(**{'sizeinbytes': 255,  'encoding': PHONE_ENCODING,                  'default': '' })
        return self.__field_pathname.getvalue()

    def __setfield_pathname(self, value):
        if isinstance(value,USTRING):
            self.__field_pathname=value
        else:
            self.__field_pathname=USTRING(value,**{'sizeinbytes': 255,  'encoding': PHONE_ENCODING,                  'default': '' })

    def __delfield_pathname(self): del self.__field_pathname

    pathname=property(__getfield_pathname, __setfield_pathname, __delfield_pathname, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('pathname', self.__field_pathname, None)




class PathIndexFile(BaseProtogenClass):
    __fields=['items']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(PathIndexFile,self).__init__(**dict)
        if self.__class__ is PathIndexFile:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(PathIndexFile,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(PathIndexFile,kwargs)
        if len(args):
            dict2={ 'elementclass': PathIndexEntry,             'createdefault': True,             'length': NUMPHONEBOOKENTRIES }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_items=LIST(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_items
        except:
            self.__field_items=LIST(**{ 'elementclass': PathIndexEntry,             'createdefault': True,             'length': NUMPHONEBOOKENTRIES })
        self.__field_items.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_items=LIST(**{ 'elementclass': PathIndexEntry,             'createdefault': True,             'length': NUMPHONEBOOKENTRIES })
        self.__field_items.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_items(self):
        try: self.__field_items
        except:
            self.__field_items=LIST(**{ 'elementclass': PathIndexEntry,             'createdefault': True,             'length': NUMPHONEBOOKENTRIES })
        return self.__field_items.getvalue()

    def __setfield_items(self, value):
        if isinstance(value,LIST):
            self.__field_items=value
        else:
            self.__field_items=LIST(value,**{ 'elementclass': PathIndexEntry,             'createdefault': True,             'length': NUMPHONEBOOKENTRIES })

    def __delfield_items(self): del self.__field_items

    items=property(__getfield_items, __setfield_items, __delfield_items, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('items', self.__field_items, None)




class PLIndexEntry(BaseProtogenClass):
    __fields=['pathname']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(PLIndexEntry,self).__init__(**dict)
        if self.__class__ is PLIndexEntry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(PLIndexEntry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(PLIndexEntry,kwargs)
        if len(args):
            dict2={'sizeinbytes': 255,  'encoding': PHONE_ENCODING }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_pathname=USTRING(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_pathname.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_pathname=USTRING(**{'sizeinbytes': 255,  'encoding': PHONE_ENCODING })
        self.__field_pathname.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_pathname(self):
        return self.__field_pathname.getvalue()

    def __setfield_pathname(self, value):
        if isinstance(value,USTRING):
            self.__field_pathname=value
        else:
            self.__field_pathname=USTRING(value,**{'sizeinbytes': 255,  'encoding': PHONE_ENCODING })

    def __delfield_pathname(self): del self.__field_pathname

    pathname=property(__getfield_pathname, __setfield_pathname, __delfield_pathname, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('pathname', self.__field_pathname, None)




class PLIndexFile(BaseProtogenClass):
    __fields=['items']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(PLIndexFile,self).__init__(**dict)
        if self.__class__ is PLIndexFile:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(PLIndexFile,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(PLIndexFile,kwargs)
        if len(args):
            dict2={ 'elementclass': PLIndexEntry,             'createdefault': True }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_items=LIST(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_items
        except:
            self.__field_items=LIST(**{ 'elementclass': PLIndexEntry,             'createdefault': True })
        self.__field_items.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_items=LIST(**{ 'elementclass': PLIndexEntry,             'createdefault': True })
        self.__field_items.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_items(self):
        try: self.__field_items
        except:
            self.__field_items=LIST(**{ 'elementclass': PLIndexEntry,             'createdefault': True })
        return self.__field_items.getvalue()

    def __setfield_items(self, value):
        if isinstance(value,LIST):
            self.__field_items=value
        else:
            self.__field_items=LIST(value,**{ 'elementclass': PLIndexEntry,             'createdefault': True })

    def __delfield_items(self): del self.__field_items

    items=property(__getfield_items, __setfield_items, __delfield_items, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('items', self.__field_items, None)




class PLSongEntry(BaseProtogenClass):
    __fields=['pathname', 'tunename', 'artistname', 'albumname', 'genre', 'dunno1', 'date', 'size', 'zero']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(PLSongEntry,self).__init__(**dict)
        if self.__class__ is PLSongEntry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(PLSongEntry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(PLSongEntry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_pathname.writetobuffer(buf)
        try: self.__field_tunename
        except:
            self.__field_tunename=USTRING(**{'sizeinbytes': 255,  'encoding': PHONE_ENCODING,                  'default': self.pathname })
        self.__field_tunename.writetobuffer(buf)
        try: self.__field_artistname
        except:
            self.__field_artistname=USTRING(**{'sizeinbytes': 100,  'encoding': PHONE_ENCODING,                  'default': 'Unknown' })
        self.__field_artistname.writetobuffer(buf)
        try: self.__field_albumname
        except:
            self.__field_albumname=USTRING(**{'sizeinbytes': 100,  'encoding': PHONE_ENCODING,                  'default': 'Unknown' })
        self.__field_albumname.writetobuffer(buf)
        try: self.__field_genre
        except:
            self.__field_genre=USTRING(**{'sizeinbytes': 102,  'encoding': PHONE_ENCODING,                  'default': 'Unknown' })
        self.__field_genre.writetobuffer(buf)
        try: self.__field_dunno1
        except:
            self.__field_dunno1=UINT(**{'sizeinbytes': 4,  'default': 2 })
        self.__field_dunno1.writetobuffer(buf)
        try: self.__field_date
        except:
            self.__field_date=GPSDATE(**{'sizeinbytes': 4,  'default': GPSDATE.now() })
        self.__field_date.writetobuffer(buf)
        self.__field_size.writetobuffer(buf)
        try: self.__field_zero
        except:
            self.__field_zero=UINT(**{'sizeinbytes': 4,  'default': 0 })
        self.__field_zero.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_pathname=USTRING(**{'sizeinbytes': 255,  'encoding': PHONE_ENCODING })
        self.__field_pathname.readfrombuffer(buf)
        self.__field_tunename=USTRING(**{'sizeinbytes': 255,  'encoding': PHONE_ENCODING,                  'default': self.pathname })
        self.__field_tunename.readfrombuffer(buf)
        self.__field_artistname=USTRING(**{'sizeinbytes': 100,  'encoding': PHONE_ENCODING,                  'default': 'Unknown' })
        self.__field_artistname.readfrombuffer(buf)
        self.__field_albumname=USTRING(**{'sizeinbytes': 100,  'encoding': PHONE_ENCODING,                  'default': 'Unknown' })
        self.__field_albumname.readfrombuffer(buf)
        self.__field_genre=USTRING(**{'sizeinbytes': 102,  'encoding': PHONE_ENCODING,                  'default': 'Unknown' })
        self.__field_genre.readfrombuffer(buf)
        self.__field_dunno1=UINT(**{'sizeinbytes': 4,  'default': 2 })
        self.__field_dunno1.readfrombuffer(buf)
        self.__field_date=GPSDATE(**{'sizeinbytes': 4,  'default': GPSDATE.now() })
        self.__field_date.readfrombuffer(buf)
        self.__field_size=UINT(**{'sizeinbytes': 4})
        self.__field_size.readfrombuffer(buf)
        self.__field_zero=UINT(**{'sizeinbytes': 4,  'default': 0 })
        self.__field_zero.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_pathname(self):
        return self.__field_pathname.getvalue()

    def __setfield_pathname(self, value):
        if isinstance(value,USTRING):
            self.__field_pathname=value
        else:
            self.__field_pathname=USTRING(value,**{'sizeinbytes': 255,  'encoding': PHONE_ENCODING })

    def __delfield_pathname(self): del self.__field_pathname

    pathname=property(__getfield_pathname, __setfield_pathname, __delfield_pathname, None)

    def __getfield_tunename(self):
        try: self.__field_tunename
        except:
            self.__field_tunename=USTRING(**{'sizeinbytes': 255,  'encoding': PHONE_ENCODING,                  'default': self.pathname })
        return self.__field_tunename.getvalue()

    def __setfield_tunename(self, value):
        if isinstance(value,USTRING):
            self.__field_tunename=value
        else:
            self.__field_tunename=USTRING(value,**{'sizeinbytes': 255,  'encoding': PHONE_ENCODING,                  'default': self.pathname })

    def __delfield_tunename(self): del self.__field_tunename

    tunename=property(__getfield_tunename, __setfield_tunename, __delfield_tunename, None)

    def __getfield_artistname(self):
        try: self.__field_artistname
        except:
            self.__field_artistname=USTRING(**{'sizeinbytes': 100,  'encoding': PHONE_ENCODING,                  'default': 'Unknown' })
        return self.__field_artistname.getvalue()

    def __setfield_artistname(self, value):
        if isinstance(value,USTRING):
            self.__field_artistname=value
        else:
            self.__field_artistname=USTRING(value,**{'sizeinbytes': 100,  'encoding': PHONE_ENCODING,                  'default': 'Unknown' })

    def __delfield_artistname(self): del self.__field_artistname

    artistname=property(__getfield_artistname, __setfield_artistname, __delfield_artistname, None)

    def __getfield_albumname(self):
        try: self.__field_albumname
        except:
            self.__field_albumname=USTRING(**{'sizeinbytes': 100,  'encoding': PHONE_ENCODING,                  'default': 'Unknown' })
        return self.__field_albumname.getvalue()

    def __setfield_albumname(self, value):
        if isinstance(value,USTRING):
            self.__field_albumname=value
        else:
            self.__field_albumname=USTRING(value,**{'sizeinbytes': 100,  'encoding': PHONE_ENCODING,                  'default': 'Unknown' })

    def __delfield_albumname(self): del self.__field_albumname

    albumname=property(__getfield_albumname, __setfield_albumname, __delfield_albumname, None)

    def __getfield_genre(self):
        try: self.__field_genre
        except:
            self.__field_genre=USTRING(**{'sizeinbytes': 102,  'encoding': PHONE_ENCODING,                  'default': 'Unknown' })
        return self.__field_genre.getvalue()

    def __setfield_genre(self, value):
        if isinstance(value,USTRING):
            self.__field_genre=value
        else:
            self.__field_genre=USTRING(value,**{'sizeinbytes': 102,  'encoding': PHONE_ENCODING,                  'default': 'Unknown' })

    def __delfield_genre(self): del self.__field_genre

    genre=property(__getfield_genre, __setfield_genre, __delfield_genre, None)

    def __getfield_dunno1(self):
        try: self.__field_dunno1
        except:
            self.__field_dunno1=UINT(**{'sizeinbytes': 4,  'default': 2 })
        return self.__field_dunno1.getvalue()

    def __setfield_dunno1(self, value):
        if isinstance(value,UINT):
            self.__field_dunno1=value
        else:
            self.__field_dunno1=UINT(value,**{'sizeinbytes': 4,  'default': 2 })

    def __delfield_dunno1(self): del self.__field_dunno1

    dunno1=property(__getfield_dunno1, __setfield_dunno1, __delfield_dunno1, None)

    def __getfield_date(self):
        try: self.__field_date
        except:
            self.__field_date=GPSDATE(**{'sizeinbytes': 4,  'default': GPSDATE.now() })
        return self.__field_date.getvalue()

    def __setfield_date(self, value):
        if isinstance(value,GPSDATE):
            self.__field_date=value
        else:
            self.__field_date=GPSDATE(value,**{'sizeinbytes': 4,  'default': GPSDATE.now() })

    def __delfield_date(self): del self.__field_date

    date=property(__getfield_date, __setfield_date, __delfield_date, None)

    def __getfield_size(self):
        return self.__field_size.getvalue()

    def __setfield_size(self, value):
        if isinstance(value,UINT):
            self.__field_size=value
        else:
            self.__field_size=UINT(value,**{'sizeinbytes': 4})

    def __delfield_size(self): del self.__field_size

    size=property(__getfield_size, __setfield_size, __delfield_size, None)

    def __getfield_zero(self):
        try: self.__field_zero
        except:
            self.__field_zero=UINT(**{'sizeinbytes': 4,  'default': 0 })
        return self.__field_zero.getvalue()

    def __setfield_zero(self, value):
        if isinstance(value,UINT):
            self.__field_zero=value
        else:
            self.__field_zero=UINT(value,**{'sizeinbytes': 4,  'default': 0 })

    def __delfield_zero(self): del self.__field_zero

    zero=property(__getfield_zero, __setfield_zero, __delfield_zero, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('pathname', self.__field_pathname, None)
        yield ('tunename', self.__field_tunename, None)
        yield ('artistname', self.__field_artistname, None)
        yield ('albumname', self.__field_albumname, None)
        yield ('genre', self.__field_genre, None)
        yield ('dunno1', self.__field_dunno1, None)
        yield ('date', self.__field_date, None)
        yield ('size', self.__field_size, None)
        yield ('zero', self.__field_zero, None)




class PLPlayListFile(BaseProtogenClass):
    __fields=['items']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(PLPlayListFile,self).__init__(**dict)
        if self.__class__ is PLPlayListFile:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(PLPlayListFile,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(PLPlayListFile,kwargs)
        if len(args):
            dict2={ 'elementclass': PLSongEntry,             'createdefault': True }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_items=LIST(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_items
        except:
            self.__field_items=LIST(**{ 'elementclass': PLSongEntry,             'createdefault': True })
        self.__field_items.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_items=LIST(**{ 'elementclass': PLSongEntry,             'createdefault': True })
        self.__field_items.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_items(self):
        try: self.__field_items
        except:
            self.__field_items=LIST(**{ 'elementclass': PLSongEntry,             'createdefault': True })
        return self.__field_items.getvalue()

    def __setfield_items(self, value):
        if isinstance(value,LIST):
            self.__field_items=value
        else:
            self.__field_items=LIST(value,**{ 'elementclass': PLSongEntry,             'createdefault': True })

    def __delfield_items(self): del self.__field_items

    items=property(__getfield_items, __setfield_items, __delfield_items, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('items', self.__field_items, None)




class msg_record(BaseProtogenClass):
    __fields=['binary', 'unknown3', 'unknown4', 'unknown6', 'length', 'msg']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(msg_record,self).__init__(**dict)
        if self.__class__ is msg_record:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(msg_record,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(msg_record,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_binary.writetobuffer(buf)
        self.__field_unknown3.writetobuffer(buf)
        self.__field_unknown4.writetobuffer(buf)
        self.__field_unknown6.writetobuffer(buf)
        self.__field_length.writetobuffer(buf)
        try: self.__field_msg
        except:
            self.__field_msg=LIST(**{'elementclass': _gen_p_lgvx8500_111, 'length': 219})
        self.__field_msg.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_binary=UINT(**{'sizeinbytes': 1})
        self.__field_binary.readfrombuffer(buf)
        self.__field_unknown3=UINT(**{'sizeinbytes': 1})
        self.__field_unknown3.readfrombuffer(buf)
        self.__field_unknown4=UINT(**{'sizeinbytes': 1})
        self.__field_unknown4.readfrombuffer(buf)
        self.__field_unknown6=UINT(**{'sizeinbytes': 1})
        self.__field_unknown6.readfrombuffer(buf)
        self.__field_length=UINT(**{'sizeinbytes': 1})
        self.__field_length.readfrombuffer(buf)
        self.__field_msg=LIST(**{'elementclass': _gen_p_lgvx8500_111, 'length': 219})
        self.__field_msg.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_binary(self):
        return self.__field_binary.getvalue()

    def __setfield_binary(self, value):
        if isinstance(value,UINT):
            self.__field_binary=value
        else:
            self.__field_binary=UINT(value,**{'sizeinbytes': 1})

    def __delfield_binary(self): del self.__field_binary

    binary=property(__getfield_binary, __setfield_binary, __delfield_binary, None)

    def __getfield_unknown3(self):
        return self.__field_unknown3.getvalue()

    def __setfield_unknown3(self, value):
        if isinstance(value,UINT):
            self.__field_unknown3=value
        else:
            self.__field_unknown3=UINT(value,**{'sizeinbytes': 1})

    def __delfield_unknown3(self): del self.__field_unknown3

    unknown3=property(__getfield_unknown3, __setfield_unknown3, __delfield_unknown3, None)

    def __getfield_unknown4(self):
        return self.__field_unknown4.getvalue()

    def __setfield_unknown4(self, value):
        if isinstance(value,UINT):
            self.__field_unknown4=value
        else:
            self.__field_unknown4=UINT(value,**{'sizeinbytes': 1})

    def __delfield_unknown4(self): del self.__field_unknown4

    unknown4=property(__getfield_unknown4, __setfield_unknown4, __delfield_unknown4, None)

    def __getfield_unknown6(self):
        return self.__field_unknown6.getvalue()

    def __setfield_unknown6(self, value):
        if isinstance(value,UINT):
            self.__field_unknown6=value
        else:
            self.__field_unknown6=UINT(value,**{'sizeinbytes': 1})

    def __delfield_unknown6(self): del self.__field_unknown6

    unknown6=property(__getfield_unknown6, __setfield_unknown6, __delfield_unknown6, None)

    def __getfield_length(self):
        return self.__field_length.getvalue()

    def __setfield_length(self, value):
        if isinstance(value,UINT):
            self.__field_length=value
        else:
            self.__field_length=UINT(value,**{'sizeinbytes': 1})

    def __delfield_length(self): del self.__field_length

    length=property(__getfield_length, __setfield_length, __delfield_length, None)

    def __getfield_msg(self):
        try: self.__field_msg
        except:
            self.__field_msg=LIST(**{'elementclass': _gen_p_lgvx8500_111, 'length': 219})
        return self.__field_msg.getvalue()

    def __setfield_msg(self, value):
        if isinstance(value,LIST):
            self.__field_msg=value
        else:
            self.__field_msg=LIST(value,**{'elementclass': _gen_p_lgvx8500_111, 'length': 219})

    def __delfield_msg(self): del self.__field_msg

    msg=property(__getfield_msg, __setfield_msg, __delfield_msg, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('binary', self.__field_binary, None)
        yield ('unknown3', self.__field_unknown3, None)
        yield ('unknown4', self.__field_unknown4, None)
        yield ('unknown6', self.__field_unknown6, None)
        yield ('length', self.__field_length, None)
        yield ('msg', self.__field_msg, None)




class _gen_p_lgvx8500_111(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['byte']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_lgvx8500_111,self).__init__(**dict)
        if self.__class__ is _gen_p_lgvx8500_111:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_lgvx8500_111,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_lgvx8500_111,kwargs)
        if len(args):
            dict2={'sizeinbytes': 1}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_byte=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_byte.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_byte=UINT(**{'sizeinbytes': 1})
        self.__field_byte.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_byte(self):
        return self.__field_byte.getvalue()

    def __setfield_byte(self, value):
        if isinstance(value,UINT):
            self.__field_byte=value
        else:
            self.__field_byte=UINT(value,**{'sizeinbytes': 1})

    def __delfield_byte(self): del self.__field_byte

    byte=property(__getfield_byte, __setfield_byte, __delfield_byte, "individual byte of message")

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('byte', self.__field_byte, "individual byte of message")




class recipient_record(BaseProtogenClass):
    __fields=['unknown1', 'number', 'status', 'dunno1', 'timesent', 'timereceived', 'unknown2', 'unknown3']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(recipient_record,self).__init__(**dict)
        if self.__class__ is recipient_record:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(recipient_record,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(recipient_record,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_unknown1.writetobuffer(buf)
        self.__field_number.writetobuffer(buf)
        self.__field_status.writetobuffer(buf)
        self.__field_dunno1.writetobuffer(buf)
        self.__field_timesent.writetobuffer(buf)
        self.__field_timereceived.writetobuffer(buf)
        self.__field_unknown2.writetobuffer(buf)
        self.__field_unknown3.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_unknown1=DATA(**{'sizeinbytes': 33})
        self.__field_unknown1.readfrombuffer(buf)
        self.__field_number=USTRING(**{'sizeinbytes': 50})
        self.__field_number.readfrombuffer(buf)
        self.__field_status=UINT(**{'sizeinbytes': 1})
        self.__field_status.readfrombuffer(buf)
        self.__field_dunno1=UNKNOWN(**{'sizeinbytes': 3})
        self.__field_dunno1.readfrombuffer(buf)
        self.__field_timesent=LGCALDATE(**{'sizeinbytes': 4})
        self.__field_timesent.readfrombuffer(buf)
        self.__field_timereceived=LGCALDATE(**{'sizeinbytes': 4})
        self.__field_timereceived.readfrombuffer(buf)
        self.__field_unknown2=UINT(**{'sizeinbytes': 1})
        self.__field_unknown2.readfrombuffer(buf)
        self.__field_unknown3=DATA(**{'sizeinbytes': 57})
        self.__field_unknown3.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_unknown1(self):
        return self.__field_unknown1.getvalue()

    def __setfield_unknown1(self, value):
        if isinstance(value,DATA):
            self.__field_unknown1=value
        else:
            self.__field_unknown1=DATA(value,**{'sizeinbytes': 33})

    def __delfield_unknown1(self): del self.__field_unknown1

    unknown1=property(__getfield_unknown1, __setfield_unknown1, __delfield_unknown1, None)

    def __getfield_number(self):
        return self.__field_number.getvalue()

    def __setfield_number(self, value):
        if isinstance(value,USTRING):
            self.__field_number=value
        else:
            self.__field_number=USTRING(value,**{'sizeinbytes': 50})

    def __delfield_number(self): del self.__field_number

    number=property(__getfield_number, __setfield_number, __delfield_number, None)

    def __getfield_status(self):
        return self.__field_status.getvalue()

    def __setfield_status(self, value):
        if isinstance(value,UINT):
            self.__field_status=value
        else:
            self.__field_status=UINT(value,**{'sizeinbytes': 1})

    def __delfield_status(self): del self.__field_status

    status=property(__getfield_status, __setfield_status, __delfield_status, None)

    def __getfield_dunno1(self):
        return self.__field_dunno1.getvalue()

    def __setfield_dunno1(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_dunno1=value
        else:
            self.__field_dunno1=UNKNOWN(value,**{'sizeinbytes': 3})

    def __delfield_dunno1(self): del self.__field_dunno1

    dunno1=property(__getfield_dunno1, __setfield_dunno1, __delfield_dunno1, None)

    def __getfield_timesent(self):
        return self.__field_timesent.getvalue()

    def __setfield_timesent(self, value):
        if isinstance(value,LGCALDATE):
            self.__field_timesent=value
        else:
            self.__field_timesent=LGCALDATE(value,**{'sizeinbytes': 4})

    def __delfield_timesent(self): del self.__field_timesent

    timesent=property(__getfield_timesent, __setfield_timesent, __delfield_timesent, None)

    def __getfield_timereceived(self):
        return self.__field_timereceived.getvalue()

    def __setfield_timereceived(self, value):
        if isinstance(value,LGCALDATE):
            self.__field_timereceived=value
        else:
            self.__field_timereceived=LGCALDATE(value,**{'sizeinbytes': 4})

    def __delfield_timereceived(self): del self.__field_timereceived

    timereceived=property(__getfield_timereceived, __setfield_timereceived, __delfield_timereceived, None)

    def __getfield_unknown2(self):
        return self.__field_unknown2.getvalue()

    def __setfield_unknown2(self, value):
        if isinstance(value,UINT):
            self.__field_unknown2=value
        else:
            self.__field_unknown2=UINT(value,**{'sizeinbytes': 1})

    def __delfield_unknown2(self): del self.__field_unknown2

    unknown2=property(__getfield_unknown2, __setfield_unknown2, __delfield_unknown2, None)

    def __getfield_unknown3(self):
        return self.__field_unknown3.getvalue()

    def __setfield_unknown3(self, value):
        if isinstance(value,DATA):
            self.__field_unknown3=value
        else:
            self.__field_unknown3=DATA(value,**{'sizeinbytes': 57})

    def __delfield_unknown3(self): del self.__field_unknown3

    unknown3=property(__getfield_unknown3, __setfield_unknown3, __delfield_unknown3, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('unknown1', self.__field_unknown1, None)
        yield ('number', self.__field_number, None)
        yield ('status', self.__field_status, None)
        yield ('dunno1', self.__field_dunno1, None)
        yield ('timesent', self.__field_timesent, None)
        yield ('timereceived', self.__field_timereceived, None)
        yield ('unknown2', self.__field_unknown2, None)
        yield ('unknown3', self.__field_unknown3, None)




class sms_saved(BaseProtogenClass):
    __fields=['outboxmsg', 'GPStime', 'outbox']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(sms_saved,self).__init__(**dict)
        if self.__class__ is sms_saved:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(sms_saved,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(sms_saved,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed
        try: self.__field_outboxmsg
        except:
            self.__field_outboxmsg=BOOL(**{ 'default': True })


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_GPStime.writetobuffer(buf)
        self.__field_outbox.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_GPStime=GPSDATE(**{'sizeinbytes': 4})
        self.__field_GPStime.readfrombuffer(buf)
        self.__field_outbox=sms_out()
        self.__field_outbox.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_outboxmsg(self):
        try: self.__field_outboxmsg
        except:
            self.__field_outboxmsg=BOOL(**{ 'default': True })
        return self.__field_outboxmsg.getvalue()

    def __setfield_outboxmsg(self, value):
        if isinstance(value,BOOL):
            self.__field_outboxmsg=value
        else:
            self.__field_outboxmsg=BOOL(value,**{ 'default': True })

    def __delfield_outboxmsg(self): del self.__field_outboxmsg

    outboxmsg=property(__getfield_outboxmsg, __setfield_outboxmsg, __delfield_outboxmsg, None)

    def __getfield_GPStime(self):
        return self.__field_GPStime.getvalue()

    def __setfield_GPStime(self, value):
        if isinstance(value,GPSDATE):
            self.__field_GPStime=value
        else:
            self.__field_GPStime=GPSDATE(value,**{'sizeinbytes': 4})

    def __delfield_GPStime(self): del self.__field_GPStime

    GPStime=property(__getfield_GPStime, __setfield_GPStime, __delfield_GPStime, None)

    def __getfield_outbox(self):
        return self.__field_outbox.getvalue()

    def __setfield_outbox(self, value):
        if isinstance(value,sms_out):
            self.__field_outbox=value
        else:
            self.__field_outbox=sms_out(value,)

    def __delfield_outbox(self): del self.__field_outbox

    outbox=property(__getfield_outbox, __setfield_outbox, __delfield_outbox, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('outboxmsg', self.__field_outboxmsg, None)
        yield ('GPStime', self.__field_GPStime, None)
        yield ('outbox', self.__field_outbox, None)




class sms_out(BaseProtogenClass):
    __fields=['index', 'locked', 'timesent', 'unknown2', 'subject', 'num_msg_elements', 'messages', 'unknown1', 'priority', 'unknown5', 'callback', 'recipients', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(sms_out,self).__init__(**dict)
        if self.__class__ is sms_out:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(sms_out,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(sms_out,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_index.writetobuffer(buf)
        self.__field_locked.writetobuffer(buf)
        self.__field_timesent.writetobuffer(buf)
        self.__field_unknown2.writetobuffer(buf)
        self.__field_subject.writetobuffer(buf)
        self.__field_num_msg_elements.writetobuffer(buf)
        try: self.__field_messages
        except:
            self.__field_messages=LIST(**{'elementclass': msg_record, 'length': 7})
        self.__field_messages.writetobuffer(buf)
        self.__field_unknown1.writetobuffer(buf)
        self.__field_priority.writetobuffer(buf)
        self.__field_unknown5.writetobuffer(buf)
        self.__field_callback.writetobuffer(buf)
        try: self.__field_recipients
        except:
            self.__field_recipients=LIST(**{'elementclass': recipient_record,'length': 9})
        self.__field_recipients.writetobuffer(buf)
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_index=UINT(**{'sizeinbytes': 4})
        self.__field_index.readfrombuffer(buf)
        self.__field_locked=UINT(**{'sizeinbytes': 1})
        self.__field_locked.readfrombuffer(buf)
        self.__field_timesent=LGCALDATE(**{'sizeinbytes': 4})
        self.__field_timesent.readfrombuffer(buf)
        self.__field_unknown2=UNKNOWN(**{'sizeinbytes': 7})
        self.__field_unknown2.readfrombuffer(buf)
        self.__field_subject=USTRING(**{'sizeinbytes': 61, 'encoding': PHONE_ENCODING})
        self.__field_subject.readfrombuffer(buf)
        self.__field_num_msg_elements=UINT(**{'sizeinbytes': 1})
        self.__field_num_msg_elements.readfrombuffer(buf)
        self.__field_messages=LIST(**{'elementclass': msg_record, 'length': 7})
        self.__field_messages.readfrombuffer(buf)
        self.__field_unknown1=UNKNOWN(**{'sizeinbytes': 8})
        self.__field_unknown1.readfrombuffer(buf)
        self.__field_priority=UINT(**{'sizeinbytes': 1})
        self.__field_priority.readfrombuffer(buf)
        self.__field_unknown5=UNKNOWN(**{'sizeinbytes': 16})
        self.__field_unknown5.readfrombuffer(buf)
        self.__field_callback=USTRING(**{'sizeinbytes': 73})
        self.__field_callback.readfrombuffer(buf)
        self.__field_recipients=LIST(**{'elementclass': recipient_record,'length': 9})
        self.__field_recipients.readfrombuffer(buf)
        self.__field_pad=UNKNOWN()
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_index(self):
        return self.__field_index.getvalue()

    def __setfield_index(self, value):
        if isinstance(value,UINT):
            self.__field_index=value
        else:
            self.__field_index=UINT(value,**{'sizeinbytes': 4})

    def __delfield_index(self): del self.__field_index

    index=property(__getfield_index, __setfield_index, __delfield_index, None)

    def __getfield_locked(self):
        return self.__field_locked.getvalue()

    def __setfield_locked(self, value):
        if isinstance(value,UINT):
            self.__field_locked=value
        else:
            self.__field_locked=UINT(value,**{'sizeinbytes': 1})

    def __delfield_locked(self): del self.__field_locked

    locked=property(__getfield_locked, __setfield_locked, __delfield_locked, None)

    def __getfield_timesent(self):
        return self.__field_timesent.getvalue()

    def __setfield_timesent(self, value):
        if isinstance(value,LGCALDATE):
            self.__field_timesent=value
        else:
            self.__field_timesent=LGCALDATE(value,**{'sizeinbytes': 4})

    def __delfield_timesent(self): del self.__field_timesent

    timesent=property(__getfield_timesent, __setfield_timesent, __delfield_timesent, None)

    def __getfield_unknown2(self):
        return self.__field_unknown2.getvalue()

    def __setfield_unknown2(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_unknown2=value
        else:
            self.__field_unknown2=UNKNOWN(value,**{'sizeinbytes': 7})

    def __delfield_unknown2(self): del self.__field_unknown2

    unknown2=property(__getfield_unknown2, __setfield_unknown2, __delfield_unknown2, None)

    def __getfield_subject(self):
        return self.__field_subject.getvalue()

    def __setfield_subject(self, value):
        if isinstance(value,USTRING):
            self.__field_subject=value
        else:
            self.__field_subject=USTRING(value,**{'sizeinbytes': 61, 'encoding': PHONE_ENCODING})

    def __delfield_subject(self): del self.__field_subject

    subject=property(__getfield_subject, __setfield_subject, __delfield_subject, None)

    def __getfield_num_msg_elements(self):
        return self.__field_num_msg_elements.getvalue()

    def __setfield_num_msg_elements(self, value):
        if isinstance(value,UINT):
            self.__field_num_msg_elements=value
        else:
            self.__field_num_msg_elements=UINT(value,**{'sizeinbytes': 1})

    def __delfield_num_msg_elements(self): del self.__field_num_msg_elements

    num_msg_elements=property(__getfield_num_msg_elements, __setfield_num_msg_elements, __delfield_num_msg_elements, None)

    def __getfield_messages(self):
        try: self.__field_messages
        except:
            self.__field_messages=LIST(**{'elementclass': msg_record, 'length': 7})
        return self.__field_messages.getvalue()

    def __setfield_messages(self, value):
        if isinstance(value,LIST):
            self.__field_messages=value
        else:
            self.__field_messages=LIST(value,**{'elementclass': msg_record, 'length': 7})

    def __delfield_messages(self): del self.__field_messages

    messages=property(__getfield_messages, __setfield_messages, __delfield_messages, None)

    def __getfield_unknown1(self):
        return self.__field_unknown1.getvalue()

    def __setfield_unknown1(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_unknown1=value
        else:
            self.__field_unknown1=UNKNOWN(value,**{'sizeinbytes': 8})

    def __delfield_unknown1(self): del self.__field_unknown1

    unknown1=property(__getfield_unknown1, __setfield_unknown1, __delfield_unknown1, None)

    def __getfield_priority(self):
        return self.__field_priority.getvalue()

    def __setfield_priority(self, value):
        if isinstance(value,UINT):
            self.__field_priority=value
        else:
            self.__field_priority=UINT(value,**{'sizeinbytes': 1})

    def __delfield_priority(self): del self.__field_priority

    priority=property(__getfield_priority, __setfield_priority, __delfield_priority, None)

    def __getfield_unknown5(self):
        return self.__field_unknown5.getvalue()

    def __setfield_unknown5(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_unknown5=value
        else:
            self.__field_unknown5=UNKNOWN(value,**{'sizeinbytes': 16})

    def __delfield_unknown5(self): del self.__field_unknown5

    unknown5=property(__getfield_unknown5, __setfield_unknown5, __delfield_unknown5, None)

    def __getfield_callback(self):
        return self.__field_callback.getvalue()

    def __setfield_callback(self, value):
        if isinstance(value,USTRING):
            self.__field_callback=value
        else:
            self.__field_callback=USTRING(value,**{'sizeinbytes': 73})

    def __delfield_callback(self): del self.__field_callback

    callback=property(__getfield_callback, __setfield_callback, __delfield_callback, None)

    def __getfield_recipients(self):
        try: self.__field_recipients
        except:
            self.__field_recipients=LIST(**{'elementclass': recipient_record,'length': 9})
        return self.__field_recipients.getvalue()

    def __setfield_recipients(self, value):
        if isinstance(value,LIST):
            self.__field_recipients=value
        else:
            self.__field_recipients=LIST(value,**{'elementclass': recipient_record,'length': 9})

    def __delfield_recipients(self): del self.__field_recipients

    recipients=property(__getfield_recipients, __setfield_recipients, __delfield_recipients, None)

    def __getfield_pad(self):
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,)

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('index', self.__field_index, None)
        yield ('locked', self.__field_locked, None)
        yield ('timesent', self.__field_timesent, None)
        yield ('unknown2', self.__field_unknown2, None)
        yield ('subject', self.__field_subject, None)
        yield ('num_msg_elements', self.__field_num_msg_elements, None)
        yield ('messages', self.__field_messages, None)
        yield ('unknown1', self.__field_unknown1, None)
        yield ('priority', self.__field_priority, None)
        yield ('unknown5', self.__field_unknown5, None)
        yield ('callback', self.__field_callback, None)
        yield ('recipients', self.__field_recipients, None)
        yield ('pad', self.__field_pad, None)




class SMSINBOXMSGFRAGMENT(BaseProtogenClass):
    __fields=['msg']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(SMSINBOXMSGFRAGMENT,self).__init__(**dict)
        if self.__class__ is SMSINBOXMSGFRAGMENT:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(SMSINBOXMSGFRAGMENT,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(SMSINBOXMSGFRAGMENT,kwargs)
        if len(args):
            dict2={'elementclass': _gen_p_lgvx8500_145, 'length': 181}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_msg=LIST(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_msg
        except:
            self.__field_msg=LIST(**{'elementclass': _gen_p_lgvx8500_145, 'length': 181})
        self.__field_msg.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_msg=LIST(**{'elementclass': _gen_p_lgvx8500_145, 'length': 181})
        self.__field_msg.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_msg(self):
        try: self.__field_msg
        except:
            self.__field_msg=LIST(**{'elementclass': _gen_p_lgvx8500_145, 'length': 181})
        return self.__field_msg.getvalue()

    def __setfield_msg(self, value):
        if isinstance(value,LIST):
            self.__field_msg=value
        else:
            self.__field_msg=LIST(value,**{'elementclass': _gen_p_lgvx8500_145, 'length': 181})

    def __delfield_msg(self): del self.__field_msg

    msg=property(__getfield_msg, __setfield_msg, __delfield_msg, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('msg', self.__field_msg, None)




class _gen_p_lgvx8500_145(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['byte']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_lgvx8500_145,self).__init__(**dict)
        if self.__class__ is _gen_p_lgvx8500_145:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_lgvx8500_145,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_lgvx8500_145,kwargs)
        if len(args):
            dict2={'sizeinbytes': 1}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_byte=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_byte.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_byte=UINT(**{'sizeinbytes': 1})
        self.__field_byte.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_byte(self):
        return self.__field_byte.getvalue()

    def __setfield_byte(self, value):
        if isinstance(value,UINT):
            self.__field_byte=value
        else:
            self.__field_byte=UINT(value,**{'sizeinbytes': 1})

    def __delfield_byte(self): del self.__field_byte

    byte=property(__getfield_byte, __setfield_byte, __delfield_byte, "individual byte of message")

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('byte', self.__field_byte, "individual byte of message")




class sms_in(BaseProtogenClass):
    __fields=['unknown1', 'lg_time', 'unknown2', 'GPStime', 'timesent', 'read', 'locked', 'priority', 'dunno1', 'subject', 'dunno2', 'num_msg_elements', 'msglengths', 'unknown9', 'msgs', 'dunno3', 'sender_length', 'sender', 'dunno4', 'callback_length', 'callback', 'PAD', 'bin_header1', 'bin_header2', 'multipartID', 'bin_header3']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(sms_in,self).__init__(**dict)
        if self.__class__ is sms_in:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(sms_in,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(sms_in,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed
        try: self.__field_bin_header1
        except:
            self.__field_bin_header1=UINT(**{ 'default': 0 })
        try: self.__field_bin_header2
        except:
            self.__field_bin_header2=UINT(**{ 'default': 0 })
        try: self.__field_multipartID
        except:
            self.__field_multipartID=UINT(**{ 'default': 0 })
        try: self.__field_bin_header3
        except:
            self.__field_bin_header3=UINT(**{ 'default': 0 })


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_unknown1.writetobuffer(buf)
        self.__field_lg_time.writetobuffer(buf)
        self.__field_unknown2.writetobuffer(buf)
        self.__field_GPStime.writetobuffer(buf)
        self.__field_timesent.writetobuffer(buf)
        self.__field_read.writetobuffer(buf)
        self.__field_locked.writetobuffer(buf)
        self.__field_priority.writetobuffer(buf)
        self.__field_dunno1.writetobuffer(buf)
        self.__field_subject.writetobuffer(buf)
        self.__field_dunno2.writetobuffer(buf)
        self.__field_num_msg_elements.writetobuffer(buf)
        try: self.__field_msglengths
        except:
            self.__field_msglengths=LIST(**{'elementclass': _gen_p_lgvx8500_162, 'length': 10})
        self.__field_msglengths.writetobuffer(buf)
        self.__field_unknown9.writetobuffer(buf)
        try: self.__field_msgs
        except:
            self.__field_msgs=LIST(**{'length': 10, 'elementclass': SMSINBOXMSGFRAGMENT})
        self.__field_msgs.writetobuffer(buf)
        self.__field_dunno3.writetobuffer(buf)
        self.__field_sender_length.writetobuffer(buf)
        try: self.__field_sender
        except:
            self.__field_sender=LIST(**{'elementclass': _gen_p_lgvx8500_168, 'length': 49})
        self.__field_sender.writetobuffer(buf)
        self.__field_dunno4.writetobuffer(buf)
        self.__field_callback_length.writetobuffer(buf)
        self.__field_callback.writetobuffer(buf)
        self.__field_PAD.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_unknown1=UNKNOWN(**{'sizeinbytes': 7})
        self.__field_unknown1.readfrombuffer(buf)
        self.__field_lg_time=LGCALDATE(**{'sizeinbytes': 4})
        self.__field_lg_time.readfrombuffer(buf)
        self.__field_unknown2=UINT(**{'sizeinbytes': 1})
        self.__field_unknown2.readfrombuffer(buf)
        self.__field_GPStime=GPSDATE(**{'sizeinbytes': 4})
        self.__field_GPStime.readfrombuffer(buf)
        self.__field_timesent=SMSDATE(**{'sizeinbytes': 6})
        self.__field_timesent.readfrombuffer(buf)
        self.__field_read=UINT(**{'sizeinbytes': 1})
        self.__field_read.readfrombuffer(buf)
        self.__field_locked=UINT(**{'sizeinbytes': 1})
        self.__field_locked.readfrombuffer(buf)
        self.__field_priority=UINT(**{'sizeinbytes': 1})
        self.__field_priority.readfrombuffer(buf)
        self.__field_dunno1=UNKNOWN(**{'sizeinbytes': 6})
        self.__field_dunno1.readfrombuffer(buf)
        self.__field_subject=USTRING(**{'sizeinbytes': 23, 'encoding': PHONE_ENCODING,                'raiseonunterminatedread': False })
        self.__field_subject.readfrombuffer(buf)
        self.__field_dunno2=UNKNOWN(**{'sizeinbytes': 47})
        self.__field_dunno2.readfrombuffer(buf)
        self.__field_num_msg_elements=UINT(**{'sizeinbytes': 1})
        self.__field_num_msg_elements.readfrombuffer(buf)
        self.__field_msglengths=LIST(**{'elementclass': _gen_p_lgvx8500_162, 'length': 10})
        self.__field_msglengths.readfrombuffer(buf)
        self.__field_unknown9=UNKNOWN(**{'sizeinbytes': 10})
        self.__field_unknown9.readfrombuffer(buf)
        self.__field_msgs=LIST(**{'length': 10, 'elementclass': SMSINBOXMSGFRAGMENT})
        self.__field_msgs.readfrombuffer(buf)
        self.__field_dunno3=UNKNOWN(**{'sizeinbytes': 2594})
        self.__field_dunno3.readfrombuffer(buf)
        self.__field_sender_length=UINT(**{'sizeinbytes': 1})
        self.__field_sender_length.readfrombuffer(buf)
        self.__field_sender=LIST(**{'elementclass': _gen_p_lgvx8500_168, 'length': 49})
        self.__field_sender.readfrombuffer(buf)
        self.__field_dunno4=UNKNOWN(**{'sizeinbytes': 3})
        self.__field_dunno4.readfrombuffer(buf)
        self.__field_callback_length=UINT(**{'sizeinbytes': 1})
        self.__field_callback_length.readfrombuffer(buf)
        self.__field_callback=USTRING(**{'sizeinbytes': 55})
        self.__field_callback.readfrombuffer(buf)
        self.__field_PAD=UNKNOWN()
        self.__field_PAD.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_unknown1(self):
        return self.__field_unknown1.getvalue()

    def __setfield_unknown1(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_unknown1=value
        else:
            self.__field_unknown1=UNKNOWN(value,**{'sizeinbytes': 7})

    def __delfield_unknown1(self): del self.__field_unknown1

    unknown1=property(__getfield_unknown1, __setfield_unknown1, __delfield_unknown1, None)

    def __getfield_lg_time(self):
        return self.__field_lg_time.getvalue()

    def __setfield_lg_time(self, value):
        if isinstance(value,LGCALDATE):
            self.__field_lg_time=value
        else:
            self.__field_lg_time=LGCALDATE(value,**{'sizeinbytes': 4})

    def __delfield_lg_time(self): del self.__field_lg_time

    lg_time=property(__getfield_lg_time, __setfield_lg_time, __delfield_lg_time, None)

    def __getfield_unknown2(self):
        return self.__field_unknown2.getvalue()

    def __setfield_unknown2(self, value):
        if isinstance(value,UINT):
            self.__field_unknown2=value
        else:
            self.__field_unknown2=UINT(value,**{'sizeinbytes': 1})

    def __delfield_unknown2(self): del self.__field_unknown2

    unknown2=property(__getfield_unknown2, __setfield_unknown2, __delfield_unknown2, None)

    def __getfield_GPStime(self):
        return self.__field_GPStime.getvalue()

    def __setfield_GPStime(self, value):
        if isinstance(value,GPSDATE):
            self.__field_GPStime=value
        else:
            self.__field_GPStime=GPSDATE(value,**{'sizeinbytes': 4})

    def __delfield_GPStime(self): del self.__field_GPStime

    GPStime=property(__getfield_GPStime, __setfield_GPStime, __delfield_GPStime, None)

    def __getfield_timesent(self):
        return self.__field_timesent.getvalue()

    def __setfield_timesent(self, value):
        if isinstance(value,SMSDATE):
            self.__field_timesent=value
        else:
            self.__field_timesent=SMSDATE(value,**{'sizeinbytes': 6})

    def __delfield_timesent(self): del self.__field_timesent

    timesent=property(__getfield_timesent, __setfield_timesent, __delfield_timesent, None)

    def __getfield_read(self):
        return self.__field_read.getvalue()

    def __setfield_read(self, value):
        if isinstance(value,UINT):
            self.__field_read=value
        else:
            self.__field_read=UINT(value,**{'sizeinbytes': 1})

    def __delfield_read(self): del self.__field_read

    read=property(__getfield_read, __setfield_read, __delfield_read, None)

    def __getfield_locked(self):
        return self.__field_locked.getvalue()

    def __setfield_locked(self, value):
        if isinstance(value,UINT):
            self.__field_locked=value
        else:
            self.__field_locked=UINT(value,**{'sizeinbytes': 1})

    def __delfield_locked(self): del self.__field_locked

    locked=property(__getfield_locked, __setfield_locked, __delfield_locked, None)

    def __getfield_priority(self):
        return self.__field_priority.getvalue()

    def __setfield_priority(self, value):
        if isinstance(value,UINT):
            self.__field_priority=value
        else:
            self.__field_priority=UINT(value,**{'sizeinbytes': 1})

    def __delfield_priority(self): del self.__field_priority

    priority=property(__getfield_priority, __setfield_priority, __delfield_priority, None)

    def __getfield_dunno1(self):
        return self.__field_dunno1.getvalue()

    def __setfield_dunno1(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_dunno1=value
        else:
            self.__field_dunno1=UNKNOWN(value,**{'sizeinbytes': 6})

    def __delfield_dunno1(self): del self.__field_dunno1

    dunno1=property(__getfield_dunno1, __setfield_dunno1, __delfield_dunno1, None)

    def __getfield_subject(self):
        return self.__field_subject.getvalue()

    def __setfield_subject(self, value):
        if isinstance(value,USTRING):
            self.__field_subject=value
        else:
            self.__field_subject=USTRING(value,**{'sizeinbytes': 23, 'encoding': PHONE_ENCODING,                'raiseonunterminatedread': False })

    def __delfield_subject(self): del self.__field_subject

    subject=property(__getfield_subject, __setfield_subject, __delfield_subject, None)

    def __getfield_dunno2(self):
        return self.__field_dunno2.getvalue()

    def __setfield_dunno2(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_dunno2=value
        else:
            self.__field_dunno2=UNKNOWN(value,**{'sizeinbytes': 47})

    def __delfield_dunno2(self): del self.__field_dunno2

    dunno2=property(__getfield_dunno2, __setfield_dunno2, __delfield_dunno2, None)

    def __getfield_num_msg_elements(self):
        return self.__field_num_msg_elements.getvalue()

    def __setfield_num_msg_elements(self, value):
        if isinstance(value,UINT):
            self.__field_num_msg_elements=value
        else:
            self.__field_num_msg_elements=UINT(value,**{'sizeinbytes': 1})

    def __delfield_num_msg_elements(self): del self.__field_num_msg_elements

    num_msg_elements=property(__getfield_num_msg_elements, __setfield_num_msg_elements, __delfield_num_msg_elements, None)

    def __getfield_msglengths(self):
        try: self.__field_msglengths
        except:
            self.__field_msglengths=LIST(**{'elementclass': _gen_p_lgvx8500_162, 'length': 10})
        return self.__field_msglengths.getvalue()

    def __setfield_msglengths(self, value):
        if isinstance(value,LIST):
            self.__field_msglengths=value
        else:
            self.__field_msglengths=LIST(value,**{'elementclass': _gen_p_lgvx8500_162, 'length': 10})

    def __delfield_msglengths(self): del self.__field_msglengths

    msglengths=property(__getfield_msglengths, __setfield_msglengths, __delfield_msglengths, None)

    def __getfield_unknown9(self):
        return self.__field_unknown9.getvalue()

    def __setfield_unknown9(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_unknown9=value
        else:
            self.__field_unknown9=UNKNOWN(value,**{'sizeinbytes': 10})

    def __delfield_unknown9(self): del self.__field_unknown9

    unknown9=property(__getfield_unknown9, __setfield_unknown9, __delfield_unknown9, None)

    def __getfield_msgs(self):
        try: self.__field_msgs
        except:
            self.__field_msgs=LIST(**{'length': 10, 'elementclass': SMSINBOXMSGFRAGMENT})
        return self.__field_msgs.getvalue()

    def __setfield_msgs(self, value):
        if isinstance(value,LIST):
            self.__field_msgs=value
        else:
            self.__field_msgs=LIST(value,**{'length': 10, 'elementclass': SMSINBOXMSGFRAGMENT})

    def __delfield_msgs(self): del self.__field_msgs

    msgs=property(__getfield_msgs, __setfield_msgs, __delfield_msgs, None)

    def __getfield_dunno3(self):
        return self.__field_dunno3.getvalue()

    def __setfield_dunno3(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_dunno3=value
        else:
            self.__field_dunno3=UNKNOWN(value,**{'sizeinbytes': 2594})

    def __delfield_dunno3(self): del self.__field_dunno3

    dunno3=property(__getfield_dunno3, __setfield_dunno3, __delfield_dunno3, None)

    def __getfield_sender_length(self):
        return self.__field_sender_length.getvalue()

    def __setfield_sender_length(self, value):
        if isinstance(value,UINT):
            self.__field_sender_length=value
        else:
            self.__field_sender_length=UINT(value,**{'sizeinbytes': 1})

    def __delfield_sender_length(self): del self.__field_sender_length

    sender_length=property(__getfield_sender_length, __setfield_sender_length, __delfield_sender_length, None)

    def __getfield_sender(self):
        try: self.__field_sender
        except:
            self.__field_sender=LIST(**{'elementclass': _gen_p_lgvx8500_168, 'length': 49})
        return self.__field_sender.getvalue()

    def __setfield_sender(self, value):
        if isinstance(value,LIST):
            self.__field_sender=value
        else:
            self.__field_sender=LIST(value,**{'elementclass': _gen_p_lgvx8500_168, 'length': 49})

    def __delfield_sender(self): del self.__field_sender

    sender=property(__getfield_sender, __setfield_sender, __delfield_sender, None)

    def __getfield_dunno4(self):
        return self.__field_dunno4.getvalue()

    def __setfield_dunno4(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_dunno4=value
        else:
            self.__field_dunno4=UNKNOWN(value,**{'sizeinbytes': 3})

    def __delfield_dunno4(self): del self.__field_dunno4

    dunno4=property(__getfield_dunno4, __setfield_dunno4, __delfield_dunno4, None)

    def __getfield_callback_length(self):
        return self.__field_callback_length.getvalue()

    def __setfield_callback_length(self, value):
        if isinstance(value,UINT):
            self.__field_callback_length=value
        else:
            self.__field_callback_length=UINT(value,**{'sizeinbytes': 1})

    def __delfield_callback_length(self): del self.__field_callback_length

    callback_length=property(__getfield_callback_length, __setfield_callback_length, __delfield_callback_length, None)

    def __getfield_callback(self):
        return self.__field_callback.getvalue()

    def __setfield_callback(self, value):
        if isinstance(value,USTRING):
            self.__field_callback=value
        else:
            self.__field_callback=USTRING(value,**{'sizeinbytes': 55})

    def __delfield_callback(self): del self.__field_callback

    callback=property(__getfield_callback, __setfield_callback, __delfield_callback, None)

    def __getfield_PAD(self):
        return self.__field_PAD.getvalue()

    def __setfield_PAD(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_PAD=value
        else:
            self.__field_PAD=UNKNOWN(value,)

    def __delfield_PAD(self): del self.__field_PAD

    PAD=property(__getfield_PAD, __setfield_PAD, __delfield_PAD, None)

    def __getfield_bin_header1(self):
        try: self.__field_bin_header1
        except:
            self.__field_bin_header1=UINT(**{ 'default': 0 })
        return self.__field_bin_header1.getvalue()

    def __setfield_bin_header1(self, value):
        if isinstance(value,UINT):
            self.__field_bin_header1=value
        else:
            self.__field_bin_header1=UINT(value,**{ 'default': 0 })

    def __delfield_bin_header1(self): del self.__field_bin_header1

    bin_header1=property(__getfield_bin_header1, __setfield_bin_header1, __delfield_bin_header1, None)

    def __getfield_bin_header2(self):
        try: self.__field_bin_header2
        except:
            self.__field_bin_header2=UINT(**{ 'default': 0 })
        return self.__field_bin_header2.getvalue()

    def __setfield_bin_header2(self, value):
        if isinstance(value,UINT):
            self.__field_bin_header2=value
        else:
            self.__field_bin_header2=UINT(value,**{ 'default': 0 })

    def __delfield_bin_header2(self): del self.__field_bin_header2

    bin_header2=property(__getfield_bin_header2, __setfield_bin_header2, __delfield_bin_header2, None)

    def __getfield_multipartID(self):
        try: self.__field_multipartID
        except:
            self.__field_multipartID=UINT(**{ 'default': 0 })
        return self.__field_multipartID.getvalue()

    def __setfield_multipartID(self, value):
        if isinstance(value,UINT):
            self.__field_multipartID=value
        else:
            self.__field_multipartID=UINT(value,**{ 'default': 0 })

    def __delfield_multipartID(self): del self.__field_multipartID

    multipartID=property(__getfield_multipartID, __setfield_multipartID, __delfield_multipartID, None)

    def __getfield_bin_header3(self):
        try: self.__field_bin_header3
        except:
            self.__field_bin_header3=UINT(**{ 'default': 0 })
        return self.__field_bin_header3.getvalue()

    def __setfield_bin_header3(self, value):
        if isinstance(value,UINT):
            self.__field_bin_header3=value
        else:
            self.__field_bin_header3=UINT(value,**{ 'default': 0 })

    def __delfield_bin_header3(self): del self.__field_bin_header3

    bin_header3=property(__getfield_bin_header3, __setfield_bin_header3, __delfield_bin_header3, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('unknown1', self.__field_unknown1, None)
        yield ('lg_time', self.__field_lg_time, None)
        yield ('unknown2', self.__field_unknown2, None)
        yield ('GPStime', self.__field_GPStime, None)
        yield ('timesent', self.__field_timesent, None)
        yield ('read', self.__field_read, None)
        yield ('locked', self.__field_locked, None)
        yield ('priority', self.__field_priority, None)
        yield ('dunno1', self.__field_dunno1, None)
        yield ('subject', self.__field_subject, None)
        yield ('dunno2', self.__field_dunno2, None)
        yield ('num_msg_elements', self.__field_num_msg_elements, None)
        yield ('msglengths', self.__field_msglengths, None)
        yield ('unknown9', self.__field_unknown9, None)
        yield ('msgs', self.__field_msgs, None)
        yield ('dunno3', self.__field_dunno3, None)
        yield ('sender_length', self.__field_sender_length, None)
        yield ('sender', self.__field_sender, None)
        yield ('dunno4', self.__field_dunno4, None)
        yield ('callback_length', self.__field_callback_length, None)
        yield ('callback', self.__field_callback, None)
        yield ('PAD', self.__field_PAD, None)
        yield ('bin_header1', self.__field_bin_header1, None)
        yield ('bin_header2', self.__field_bin_header2, None)
        yield ('multipartID', self.__field_multipartID, None)
        yield ('bin_header3', self.__field_bin_header3, None)




class _gen_p_lgvx8500_162(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['msglength']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_lgvx8500_162,self).__init__(**dict)
        if self.__class__ is _gen_p_lgvx8500_162:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_lgvx8500_162,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_lgvx8500_162,kwargs)
        if len(args):
            dict2={'sizeinbytes': 1}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_msglength=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_msglength.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_msglength=UINT(**{'sizeinbytes': 1})
        self.__field_msglength.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_msglength(self):
        return self.__field_msglength.getvalue()

    def __setfield_msglength(self, value):
        if isinstance(value,UINT):
            self.__field_msglength=value
        else:
            self.__field_msglength=UINT(value,**{'sizeinbytes': 1})

    def __delfield_msglength(self): del self.__field_msglength

    msglength=property(__getfield_msglength, __setfield_msglength, __delfield_msglength, "lengths of individual messages in septets")

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('msglength', self.__field_msglength, "lengths of individual messages in septets")




class _gen_p_lgvx8500_168(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['byte']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_lgvx8500_168,self).__init__(**dict)
        if self.__class__ is _gen_p_lgvx8500_168:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_lgvx8500_168,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_lgvx8500_168,kwargs)
        if len(args):
            dict2={'sizeinbytes': 1}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_byte=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_byte.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_byte=UINT(**{'sizeinbytes': 1})
        self.__field_byte.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_byte(self):
        return self.__field_byte.getvalue()

    def __setfield_byte(self, value):
        if isinstance(value,UINT):
            self.__field_byte=value
        else:
            self.__field_byte=UINT(value,**{'sizeinbytes': 1})

    def __delfield_byte(self): del self.__field_byte

    byte=property(__getfield_byte, __setfield_byte, __delfield_byte, "individual byte of senders phone number")

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('byte', self.__field_byte, "individual byte of senders phone number")




class sms_quick_text(BaseProtogenClass):
    __fields=['msgs']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(sms_quick_text,self).__init__(**dict)
        if self.__class__ is sms_quick_text:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(sms_quick_text,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(sms_quick_text,kwargs)
        if len(args):
            dict2={'elementclass': _gen_p_lgvx8500_182,  'length': SMS_CANNED_MAX_ITEMS, 'createdefault': True}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_msgs=LIST(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_msgs
        except:
            self.__field_msgs=LIST(**{'elementclass': _gen_p_lgvx8500_182,  'length': SMS_CANNED_MAX_ITEMS, 'createdefault': True})
        self.__field_msgs.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_msgs=LIST(**{'elementclass': _gen_p_lgvx8500_182,  'length': SMS_CANNED_MAX_ITEMS, 'createdefault': True})
        self.__field_msgs.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_msgs(self):
        try: self.__field_msgs
        except:
            self.__field_msgs=LIST(**{'elementclass': _gen_p_lgvx8500_182,  'length': SMS_CANNED_MAX_ITEMS, 'createdefault': True})
        return self.__field_msgs.getvalue()

    def __setfield_msgs(self, value):
        if isinstance(value,LIST):
            self.__field_msgs=value
        else:
            self.__field_msgs=LIST(value,**{'elementclass': _gen_p_lgvx8500_182,  'length': SMS_CANNED_MAX_ITEMS, 'createdefault': True})

    def __delfield_msgs(self): del self.__field_msgs

    msgs=property(__getfield_msgs, __setfield_msgs, __delfield_msgs, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('msgs', self.__field_msgs, None)




class _gen_p_lgvx8500_182(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['msg']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_lgvx8500_182,self).__init__(**dict)
        if self.__class__ is _gen_p_lgvx8500_182:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_lgvx8500_182,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_lgvx8500_182,kwargs)
        if len(args):
            dict2={'sizeinbytes': 101, 'encoding': PHONE_ENCODING, 'default': ""}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_msg=USTRING(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_msg
        except:
            self.__field_msg=USTRING(**{'sizeinbytes': 101, 'encoding': PHONE_ENCODING, 'default': ""})
        self.__field_msg.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_msg=USTRING(**{'sizeinbytes': 101, 'encoding': PHONE_ENCODING, 'default': ""})
        self.__field_msg.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_msg(self):
        try: self.__field_msg
        except:
            self.__field_msg=USTRING(**{'sizeinbytes': 101, 'encoding': PHONE_ENCODING, 'default': ""})
        return self.__field_msg.getvalue()

    def __setfield_msg(self, value):
        if isinstance(value,USTRING):
            self.__field_msg=value
        else:
            self.__field_msg=USTRING(value,**{'sizeinbytes': 101, 'encoding': PHONE_ENCODING, 'default': ""})

    def __delfield_msg(self): del self.__field_msg

    msg=property(__getfield_msg, __setfield_msg, __delfield_msg, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('msg', self.__field_msg, None)




class LockKeyReq(BaseProtogenClass):
    __fields=['cmd', 'lock']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(LockKeyReq,self).__init__(**dict)
        if self.__class__ is LockKeyReq:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(LockKeyReq,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(LockKeyReq,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_cmd
        except:
            self.__field_cmd=UINT(**{'sizeinbytes': 1,  'default': 0x21 })
        self.__field_cmd.writetobuffer(buf)
        try: self.__field_lock
        except:
            self.__field_lock=UINT(**{'sizeinbytes': 2,  'default': 0 })
        self.__field_lock.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_cmd=UINT(**{'sizeinbytes': 1,  'default': 0x21 })
        self.__field_cmd.readfrombuffer(buf)
        self.__field_lock=UINT(**{'sizeinbytes': 2,  'default': 0 })
        self.__field_lock.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_cmd(self):
        try: self.__field_cmd
        except:
            self.__field_cmd=UINT(**{'sizeinbytes': 1,  'default': 0x21 })
        return self.__field_cmd.getvalue()

    def __setfield_cmd(self, value):
        if isinstance(value,UINT):
            self.__field_cmd=value
        else:
            self.__field_cmd=UINT(value,**{'sizeinbytes': 1,  'default': 0x21 })

    def __delfield_cmd(self): del self.__field_cmd

    cmd=property(__getfield_cmd, __setfield_cmd, __delfield_cmd, None)

    def __getfield_lock(self):
        try: self.__field_lock
        except:
            self.__field_lock=UINT(**{'sizeinbytes': 2,  'default': 0 })
        return self.__field_lock.getvalue()

    def __setfield_lock(self, value):
        if isinstance(value,UINT):
            self.__field_lock=value
        else:
            self.__field_lock=UINT(value,**{'sizeinbytes': 2,  'default': 0 })

    def __delfield_lock(self): del self.__field_lock

    lock=property(__getfield_lock, __setfield_lock, __delfield_lock, "0=Lock, 1=Unlock")

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('cmd', self.__field_cmd, None)
        yield ('lock', self.__field_lock, "0=Lock, 1=Unlock")




class KeyPressReq(BaseProtogenClass):
    __fields=['cmd', 'hold', 'key']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(KeyPressReq,self).__init__(**dict)
        if self.__class__ is KeyPressReq:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(KeyPressReq,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(KeyPressReq,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_cmd
        except:
            self.__field_cmd=UINT(**{'sizeinbytes': 1,  'default': 0x20 })
        self.__field_cmd.writetobuffer(buf)
        try: self.__field_hold
        except:
            self.__field_hold=UINT(**{'sizeinbytes': 1,  'default': 0 })
        self.__field_hold.writetobuffer(buf)
        self.__field_key.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_cmd=UINT(**{'sizeinbytes': 1,  'default': 0x20 })
        self.__field_cmd.readfrombuffer(buf)
        self.__field_hold=UINT(**{'sizeinbytes': 1,  'default': 0 })
        self.__field_hold.readfrombuffer(buf)
        self.__field_key=STRING(**{'sizeinbytes': 1,  'terminator': None,                'sizeinbytes': 1 })
        self.__field_key.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_cmd(self):
        try: self.__field_cmd
        except:
            self.__field_cmd=UINT(**{'sizeinbytes': 1,  'default': 0x20 })
        return self.__field_cmd.getvalue()

    def __setfield_cmd(self, value):
        if isinstance(value,UINT):
            self.__field_cmd=value
        else:
            self.__field_cmd=UINT(value,**{'sizeinbytes': 1,  'default': 0x20 })

    def __delfield_cmd(self): del self.__field_cmd

    cmd=property(__getfield_cmd, __setfield_cmd, __delfield_cmd, None)

    def __getfield_hold(self):
        try: self.__field_hold
        except:
            self.__field_hold=UINT(**{'sizeinbytes': 1,  'default': 0 })
        return self.__field_hold.getvalue()

    def __setfield_hold(self, value):
        if isinstance(value,UINT):
            self.__field_hold=value
        else:
            self.__field_hold=UINT(value,**{'sizeinbytes': 1,  'default': 0 })

    def __delfield_hold(self): del self.__field_hold

    hold=property(__getfield_hold, __setfield_hold, __delfield_hold, None)

    def __getfield_key(self):
        return self.__field_key.getvalue()

    def __setfield_key(self, value):
        if isinstance(value,STRING):
            self.__field_key=value
        else:
            self.__field_key=STRING(value,**{'sizeinbytes': 1,  'terminator': None,                'sizeinbytes': 1 })

    def __delfield_key(self): del self.__field_key

    key=property(__getfield_key, __setfield_key, __delfield_key, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('cmd', self.__field_cmd, None)
        yield ('hold', self.__field_hold, None)
        yield ('key', self.__field_key, None)




class t9udbfile(BaseProtogenClass):
    __fields=['file_length', 'unknown1', 'word_count', 'unknown2', 'free_space', 'unknown3', 'extra_cnt', 'unknown4', 'extras', 'A0', 'blocks']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(t9udbfile,self).__init__(**dict)
        if self.__class__ is t9udbfile:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(t9udbfile,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(t9udbfile,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_file_length
        except:
            self.__field_file_length=UINT(**{'sizeinbytes': 2,  'default': 0x5000 })
        self.__field_file_length.writetobuffer(buf)
        try: self.__field_unknown1
        except:
            self.__field_unknown1=DATA(**{'sizeinbytes': 6,  'default': '\x7B\x1B\x00\x00\x01\x00' })
        self.__field_unknown1.writetobuffer(buf)
        self.__field_word_count.writetobuffer(buf)
        try: self.__field_unknown2
        except:
            self.__field_unknown2=UINT(**{'sizeinbytes': 2,  'default': 0x00 })
        self.__field_unknown2.writetobuffer(buf)
        self.__field_free_space.writetobuffer(buf)
        try: self.__field_unknown3
        except:
            self.__field_unknown3=DATA(**{'sizeinbytes': 10,  'default': Default_Header })
        self.__field_unknown3.writetobuffer(buf)
        try: self.__field_extra_cnt
        except:
            self.__field_extra_cnt=UINT(**{'sizeinbytes': 2,  'default': 0 })
        self.__field_extra_cnt.writetobuffer(buf)
        try: self.__field_unknown4
        except:
            self.__field_unknown4=DATA(**{'sizeinbytes': 18,  'default': Default_Header2 })
        self.__field_unknown4.writetobuffer(buf)
        if self.extra_cnt:
            try: self.__field_extras
            except:
                self.__field_extras=LIST(**{'elementclass': _gen_p_lgvx8500_208,  'length': self.extra_cnt })
            self.__field_extras.writetobuffer(buf)
        try: self.__field_A0
        except:
            self.__field_A0=UINT(**{'sizeinbytes': 1,  'constant': 0xA0 })
        self.__field_A0.writetobuffer(buf)
        try: self.__field_blocks
        except:
            self.__field_blocks=LIST(**{'elementclass': _gen_p_lgvx8500_211,  'createdefault': True })
        self.__field_blocks.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_file_length=UINT(**{'sizeinbytes': 2,  'default': 0x5000 })
        self.__field_file_length.readfrombuffer(buf)
        self.__field_unknown1=DATA(**{'sizeinbytes': 6,  'default': '\x7B\x1B\x00\x00\x01\x00' })
        self.__field_unknown1.readfrombuffer(buf)
        self.__field_word_count=UINT(**{'sizeinbytes': 2})
        self.__field_word_count.readfrombuffer(buf)
        self.__field_unknown2=UINT(**{'sizeinbytes': 2,  'default': 0x00 })
        self.__field_unknown2.readfrombuffer(buf)
        self.__field_free_space=UINT(**{'sizeinbytes': 2})
        self.__field_free_space.readfrombuffer(buf)
        self.__field_unknown3=DATA(**{'sizeinbytes': 10,  'default': Default_Header })
        self.__field_unknown3.readfrombuffer(buf)
        self.__field_extra_cnt=UINT(**{'sizeinbytes': 2,  'default': 0 })
        self.__field_extra_cnt.readfrombuffer(buf)
        self.__field_unknown4=DATA(**{'sizeinbytes': 18,  'default': Default_Header2 })
        self.__field_unknown4.readfrombuffer(buf)
        if self.extra_cnt:
            self.__field_extras=LIST(**{'elementclass': _gen_p_lgvx8500_208,  'length': self.extra_cnt })
            self.__field_extras.readfrombuffer(buf)
        self.__field_A0=UINT(**{'sizeinbytes': 1,  'constant': 0xA0 })
        self.__field_A0.readfrombuffer(buf)
        self.__field_blocks=LIST(**{'elementclass': _gen_p_lgvx8500_211,  'createdefault': True })
        self.__field_blocks.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_file_length(self):
        try: self.__field_file_length
        except:
            self.__field_file_length=UINT(**{'sizeinbytes': 2,  'default': 0x5000 })
        return self.__field_file_length.getvalue()

    def __setfield_file_length(self, value):
        if isinstance(value,UINT):
            self.__field_file_length=value
        else:
            self.__field_file_length=UINT(value,**{'sizeinbytes': 2,  'default': 0x5000 })

    def __delfield_file_length(self): del self.__field_file_length

    file_length=property(__getfield_file_length, __setfield_file_length, __delfield_file_length, None)

    def __getfield_unknown1(self):
        try: self.__field_unknown1
        except:
            self.__field_unknown1=DATA(**{'sizeinbytes': 6,  'default': '\x7B\x1B\x00\x00\x01\x00' })
        return self.__field_unknown1.getvalue()

    def __setfield_unknown1(self, value):
        if isinstance(value,DATA):
            self.__field_unknown1=value
        else:
            self.__field_unknown1=DATA(value,**{'sizeinbytes': 6,  'default': '\x7B\x1B\x00\x00\x01\x00' })

    def __delfield_unknown1(self): del self.__field_unknown1

    unknown1=property(__getfield_unknown1, __setfield_unknown1, __delfield_unknown1, None)

    def __getfield_word_count(self):
        return self.__field_word_count.getvalue()

    def __setfield_word_count(self, value):
        if isinstance(value,UINT):
            self.__field_word_count=value
        else:
            self.__field_word_count=UINT(value,**{'sizeinbytes': 2})

    def __delfield_word_count(self): del self.__field_word_count

    word_count=property(__getfield_word_count, __setfield_word_count, __delfield_word_count, None)

    def __getfield_unknown2(self):
        try: self.__field_unknown2
        except:
            self.__field_unknown2=UINT(**{'sizeinbytes': 2,  'default': 0x00 })
        return self.__field_unknown2.getvalue()

    def __setfield_unknown2(self, value):
        if isinstance(value,UINT):
            self.__field_unknown2=value
        else:
            self.__field_unknown2=UINT(value,**{'sizeinbytes': 2,  'default': 0x00 })

    def __delfield_unknown2(self): del self.__field_unknown2

    unknown2=property(__getfield_unknown2, __setfield_unknown2, __delfield_unknown2, None)

    def __getfield_free_space(self):
        return self.__field_free_space.getvalue()

    def __setfield_free_space(self, value):
        if isinstance(value,UINT):
            self.__field_free_space=value
        else:
            self.__field_free_space=UINT(value,**{'sizeinbytes': 2})

    def __delfield_free_space(self): del self.__field_free_space

    free_space=property(__getfield_free_space, __setfield_free_space, __delfield_free_space, None)

    def __getfield_unknown3(self):
        try: self.__field_unknown3
        except:
            self.__field_unknown3=DATA(**{'sizeinbytes': 10,  'default': Default_Header })
        return self.__field_unknown3.getvalue()

    def __setfield_unknown3(self, value):
        if isinstance(value,DATA):
            self.__field_unknown3=value
        else:
            self.__field_unknown3=DATA(value,**{'sizeinbytes': 10,  'default': Default_Header })

    def __delfield_unknown3(self): del self.__field_unknown3

    unknown3=property(__getfield_unknown3, __setfield_unknown3, __delfield_unknown3, None)

    def __getfield_extra_cnt(self):
        try: self.__field_extra_cnt
        except:
            self.__field_extra_cnt=UINT(**{'sizeinbytes': 2,  'default': 0 })
        return self.__field_extra_cnt.getvalue()

    def __setfield_extra_cnt(self, value):
        if isinstance(value,UINT):
            self.__field_extra_cnt=value
        else:
            self.__field_extra_cnt=UINT(value,**{'sizeinbytes': 2,  'default': 0 })

    def __delfield_extra_cnt(self): del self.__field_extra_cnt

    extra_cnt=property(__getfield_extra_cnt, __setfield_extra_cnt, __delfield_extra_cnt, None)

    def __getfield_unknown4(self):
        try: self.__field_unknown4
        except:
            self.__field_unknown4=DATA(**{'sizeinbytes': 18,  'default': Default_Header2 })
        return self.__field_unknown4.getvalue()

    def __setfield_unknown4(self, value):
        if isinstance(value,DATA):
            self.__field_unknown4=value
        else:
            self.__field_unknown4=DATA(value,**{'sizeinbytes': 18,  'default': Default_Header2 })

    def __delfield_unknown4(self): del self.__field_unknown4

    unknown4=property(__getfield_unknown4, __setfield_unknown4, __delfield_unknown4, None)

    def __getfield_extras(self):
        try: self.__field_extras
        except:
            self.__field_extras=LIST(**{'elementclass': _gen_p_lgvx8500_208,  'length': self.extra_cnt })
        return self.__field_extras.getvalue()

    def __setfield_extras(self, value):
        if isinstance(value,LIST):
            self.__field_extras=value
        else:
            self.__field_extras=LIST(value,**{'elementclass': _gen_p_lgvx8500_208,  'length': self.extra_cnt })

    def __delfield_extras(self): del self.__field_extras

    extras=property(__getfield_extras, __setfield_extras, __delfield_extras, None)

    def __getfield_A0(self):
        try: self.__field_A0
        except:
            self.__field_A0=UINT(**{'sizeinbytes': 1,  'constant': 0xA0 })
        return self.__field_A0.getvalue()

    def __setfield_A0(self, value):
        if isinstance(value,UINT):
            self.__field_A0=value
        else:
            self.__field_A0=UINT(value,**{'sizeinbytes': 1,  'constant': 0xA0 })

    def __delfield_A0(self): del self.__field_A0

    A0=property(__getfield_A0, __setfield_A0, __delfield_A0, None)

    def __getfield_blocks(self):
        try: self.__field_blocks
        except:
            self.__field_blocks=LIST(**{'elementclass': _gen_p_lgvx8500_211,  'createdefault': True })
        return self.__field_blocks.getvalue()

    def __setfield_blocks(self, value):
        if isinstance(value,LIST):
            self.__field_blocks=value
        else:
            self.__field_blocks=LIST(value,**{'elementclass': _gen_p_lgvx8500_211,  'createdefault': True })

    def __delfield_blocks(self): del self.__field_blocks

    blocks=property(__getfield_blocks, __setfield_blocks, __delfield_blocks, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('file_length', self.__field_file_length, None)
        yield ('unknown1', self.__field_unknown1, None)
        yield ('word_count', self.__field_word_count, None)
        yield ('unknown2', self.__field_unknown2, None)
        yield ('free_space', self.__field_free_space, None)
        yield ('unknown3', self.__field_unknown3, None)
        yield ('extra_cnt', self.__field_extra_cnt, None)
        yield ('unknown4', self.__field_unknown4, None)
        if self.extra_cnt:
            yield ('extras', self.__field_extras, None)
        yield ('A0', self.__field_A0, None)
        yield ('blocks', self.__field_blocks, None)




class _gen_p_lgvx8500_208(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['extra']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_lgvx8500_208,self).__init__(**dict)
        if self.__class__ is _gen_p_lgvx8500_208:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_lgvx8500_208,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_lgvx8500_208,kwargs)
        if len(args):
            dict2={'sizeinbytes': 1,  'default': 0 }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_extra=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_extra
        except:
            self.__field_extra=UINT(**{'sizeinbytes': 1,  'default': 0 })
        self.__field_extra.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_extra=UINT(**{'sizeinbytes': 1,  'default': 0 })
        self.__field_extra.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_extra(self):
        try: self.__field_extra
        except:
            self.__field_extra=UINT(**{'sizeinbytes': 1,  'default': 0 })
        return self.__field_extra.getvalue()

    def __setfield_extra(self, value):
        if isinstance(value,UINT):
            self.__field_extra=value
        else:
            self.__field_extra=UINT(value,**{'sizeinbytes': 1,  'default': 0 })

    def __delfield_extra(self): del self.__field_extra

    extra=property(__getfield_extra, __setfield_extra, __delfield_extra, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('extra', self.__field_extra, None)




class _gen_p_lgvx8500_211(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['block']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_lgvx8500_211,self).__init__(**dict)
        if self.__class__ is _gen_p_lgvx8500_211:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_lgvx8500_211,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_lgvx8500_211,kwargs)
        if len(args):
            dict2={}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_block=T9USERDBBLOCK(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_block.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_block=T9USERDBBLOCK()
        self.__field_block.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_block(self):
        return self.__field_block.getvalue()

    def __setfield_block(self, value):
        if isinstance(value,T9USERDBBLOCK):
            self.__field_block=value
        else:
            self.__field_block=T9USERDBBLOCK(value,)

    def __delfield_block(self): del self.__field_block

    block=property(__getfield_block, __setfield_block, __delfield_block, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('block', self.__field_block, None)




class DMKeyReq(BaseProtogenClass):
    __fields=['cmd', 'body']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(DMKeyReq,self).__init__(**dict)
        if self.__class__ is DMKeyReq:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(DMKeyReq,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(DMKeyReq,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_cmd
        except:
            self.__field_cmd=UINT(**{'sizeinbytes': 1,  'default': 0xFE })
        self.__field_cmd.writetobuffer(buf)
        try: self.__field_body
        except:
            self.__field_body=STRING(**{'sizeinbytes': 6,  'terminator': None,               'default': '\x00\x00\x00\x00\x00\x00' })
        self.__field_body.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_cmd=UINT(**{'sizeinbytes': 1,  'default': 0xFE })
        self.__field_cmd.readfrombuffer(buf)
        self.__field_body=STRING(**{'sizeinbytes': 6,  'terminator': None,               'default': '\x00\x00\x00\x00\x00\x00' })
        self.__field_body.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_cmd(self):
        try: self.__field_cmd
        except:
            self.__field_cmd=UINT(**{'sizeinbytes': 1,  'default': 0xFE })
        return self.__field_cmd.getvalue()

    def __setfield_cmd(self, value):
        if isinstance(value,UINT):
            self.__field_cmd=value
        else:
            self.__field_cmd=UINT(value,**{'sizeinbytes': 1,  'default': 0xFE })

    def __delfield_cmd(self): del self.__field_cmd

    cmd=property(__getfield_cmd, __setfield_cmd, __delfield_cmd, None)

    def __getfield_body(self):
        try: self.__field_body
        except:
            self.__field_body=STRING(**{'sizeinbytes': 6,  'terminator': None,               'default': '\x00\x00\x00\x00\x00\x00' })
        return self.__field_body.getvalue()

    def __setfield_body(self, value):
        if isinstance(value,STRING):
            self.__field_body=value
        else:
            self.__field_body=STRING(value,**{'sizeinbytes': 6,  'terminator': None,               'default': '\x00\x00\x00\x00\x00\x00' })

    def __delfield_body(self): del self.__field_body

    body=property(__getfield_body, __setfield_body, __delfield_body, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('cmd', self.__field_cmd, None)
        yield ('body', self.__field_body, None)




class DMKeyResp(BaseProtogenClass):
    __fields=['cmd', 'code', 'key', 'one']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(DMKeyResp,self).__init__(**dict)
        if self.__class__ is DMKeyResp:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(DMKeyResp,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(DMKeyResp,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_cmd.writetobuffer(buf)
        self.__field_code.writetobuffer(buf)
        self.__field_key.writetobuffer(buf)
        self.__field_one.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_cmd=UINT(**{'sizeinbytes': 1})
        self.__field_cmd.readfrombuffer(buf)
        self.__field_code=UINT(**{'sizeinbytes': 1})
        self.__field_code.readfrombuffer(buf)
        self.__field_key=UINT(**{'sizeinbytes': 4})
        self.__field_key.readfrombuffer(buf)
        self.__field_one=UINT(**{'sizeinbytes': 1})
        self.__field_one.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_cmd(self):
        return self.__field_cmd.getvalue()

    def __setfield_cmd(self, value):
        if isinstance(value,UINT):
            self.__field_cmd=value
        else:
            self.__field_cmd=UINT(value,**{'sizeinbytes': 1})

    def __delfield_cmd(self): del self.__field_cmd

    cmd=property(__getfield_cmd, __setfield_cmd, __delfield_cmd, None)

    def __getfield_code(self):
        return self.__field_code.getvalue()

    def __setfield_code(self, value):
        if isinstance(value,UINT):
            self.__field_code=value
        else:
            self.__field_code=UINT(value,**{'sizeinbytes': 1})

    def __delfield_code(self): del self.__field_code

    code=property(__getfield_code, __setfield_code, __delfield_code, None)

    def __getfield_key(self):
        return self.__field_key.getvalue()

    def __setfield_key(self, value):
        if isinstance(value,UINT):
            self.__field_key=value
        else:
            self.__field_key=UINT(value,**{'sizeinbytes': 4})

    def __delfield_key(self): del self.__field_key

    key=property(__getfield_key, __setfield_key, __delfield_key, None)

    def __getfield_one(self):
        return self.__field_one.getvalue()

    def __setfield_one(self, value):
        if isinstance(value,UINT):
            self.__field_one=value
        else:
            self.__field_one=UINT(value,**{'sizeinbytes': 1})

    def __delfield_one(self): del self.__field_one

    one=property(__getfield_one, __setfield_one, __delfield_one, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('cmd', self.__field_cmd, None)
        yield ('code', self.__field_code, None)
        yield ('key', self.__field_key, None)
        yield ('one', self.__field_one, None)




class DMReq(BaseProtogenClass):
    __fields=['cmd', 'one', 'key', 'zero']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(DMReq,self).__init__(**dict)
        if self.__class__ is DMReq:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(DMReq,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(DMReq,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_cmd
        except:
            self.__field_cmd=UINT(**{'sizeinbytes': 1,  'default': 0xFE })
        self.__field_cmd.writetobuffer(buf)
        try: self.__field_one
        except:
            self.__field_one=UINT(**{'sizeinbytes': 1,  'default': 1 })
        self.__field_one.writetobuffer(buf)
        self.__field_key.writetobuffer(buf)
        try: self.__field_zero
        except:
            self.__field_zero=UINT(**{'sizeinbytes': 1,  'default': 0 })
        self.__field_zero.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_cmd=UINT(**{'sizeinbytes': 1,  'default': 0xFE })
        self.__field_cmd.readfrombuffer(buf)
        self.__field_one=UINT(**{'sizeinbytes': 1,  'default': 1 })
        self.__field_one.readfrombuffer(buf)
        self.__field_key=UINT(**{'sizeinbytes': 4})
        self.__field_key.readfrombuffer(buf)
        self.__field_zero=UINT(**{'sizeinbytes': 1,  'default': 0 })
        self.__field_zero.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_cmd(self):
        try: self.__field_cmd
        except:
            self.__field_cmd=UINT(**{'sizeinbytes': 1,  'default': 0xFE })
        return self.__field_cmd.getvalue()

    def __setfield_cmd(self, value):
        if isinstance(value,UINT):
            self.__field_cmd=value
        else:
            self.__field_cmd=UINT(value,**{'sizeinbytes': 1,  'default': 0xFE })

    def __delfield_cmd(self): del self.__field_cmd

    cmd=property(__getfield_cmd, __setfield_cmd, __delfield_cmd, None)

    def __getfield_one(self):
        try: self.__field_one
        except:
            self.__field_one=UINT(**{'sizeinbytes': 1,  'default': 1 })
        return self.__field_one.getvalue()

    def __setfield_one(self, value):
        if isinstance(value,UINT):
            self.__field_one=value
        else:
            self.__field_one=UINT(value,**{'sizeinbytes': 1,  'default': 1 })

    def __delfield_one(self): del self.__field_one

    one=property(__getfield_one, __setfield_one, __delfield_one, None)

    def __getfield_key(self):
        return self.__field_key.getvalue()

    def __setfield_key(self, value):
        if isinstance(value,UINT):
            self.__field_key=value
        else:
            self.__field_key=UINT(value,**{'sizeinbytes': 4})

    def __delfield_key(self): del self.__field_key

    key=property(__getfield_key, __setfield_key, __delfield_key, None)

    def __getfield_zero(self):
        try: self.__field_zero
        except:
            self.__field_zero=UINT(**{'sizeinbytes': 1,  'default': 0 })
        return self.__field_zero.getvalue()

    def __setfield_zero(self, value):
        if isinstance(value,UINT):
            self.__field_zero=value
        else:
            self.__field_zero=UINT(value,**{'sizeinbytes': 1,  'default': 0 })

    def __delfield_zero(self): del self.__field_zero

    zero=property(__getfield_zero, __setfield_zero, __delfield_zero, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('cmd', self.__field_cmd, None)
        yield ('one', self.__field_one, None)
        yield ('key', self.__field_key, None)
        yield ('zero', self.__field_zero, None)




class DMResp(BaseProtogenClass):
    __fields=['cmd', 'one', 'key', 'zero2one']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(DMResp,self).__init__(**dict)
        if self.__class__ is DMResp:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(DMResp,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(DMResp,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_cmd.writetobuffer(buf)
        self.__field_one.writetobuffer(buf)
        self.__field_key.writetobuffer(buf)
        self.__field_zero2one.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_cmd=UINT(**{'sizeinbytes': 1})
        self.__field_cmd.readfrombuffer(buf)
        self.__field_one=UINT(**{'sizeinbytes': 1})
        self.__field_one.readfrombuffer(buf)
        self.__field_key=UINT(**{'sizeinbytes': 4})
        self.__field_key.readfrombuffer(buf)
        self.__field_zero2one=UINT(**{'sizeinbytes': 1})
        self.__field_zero2one.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_cmd(self):
        return self.__field_cmd.getvalue()

    def __setfield_cmd(self, value):
        if isinstance(value,UINT):
            self.__field_cmd=value
        else:
            self.__field_cmd=UINT(value,**{'sizeinbytes': 1})

    def __delfield_cmd(self): del self.__field_cmd

    cmd=property(__getfield_cmd, __setfield_cmd, __delfield_cmd, None)

    def __getfield_one(self):
        return self.__field_one.getvalue()

    def __setfield_one(self, value):
        if isinstance(value,UINT):
            self.__field_one=value
        else:
            self.__field_one=UINT(value,**{'sizeinbytes': 1})

    def __delfield_one(self): del self.__field_one

    one=property(__getfield_one, __setfield_one, __delfield_one, None)

    def __getfield_key(self):
        return self.__field_key.getvalue()

    def __setfield_key(self, value):
        if isinstance(value,UINT):
            self.__field_key=value
        else:
            self.__field_key=UINT(value,**{'sizeinbytes': 4})

    def __delfield_key(self): del self.__field_key

    key=property(__getfield_key, __setfield_key, __delfield_key, None)

    def __getfield_zero2one(self):
        return self.__field_zero2one.getvalue()

    def __setfield_zero2one(self, value):
        if isinstance(value,UINT):
            self.__field_zero2one=value
        else:
            self.__field_zero2one=UINT(value,**{'sizeinbytes': 1})

    def __delfield_zero2one(self): del self.__field_zero2one

    zero2one=property(__getfield_zero2one, __setfield_zero2one, __delfield_zero2one, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('cmd', self.__field_cmd, None)
        yield ('one', self.__field_one, None)
        yield ('key', self.__field_key, None)
        yield ('zero2one', self.__field_zero2one, None)




