# (PD) 2001 The Bitzi Corporation
# Please see file COPYING or http://bitzi.com/publicdomain 
# for more info.
#
# $Id: bitcollider.spec,v 1.8 2002/07/08 19:39:57 mayhemchaos Exp $
#
%define  name     bitcollider
%define  version  0.4.0
%define  release  1
%define  prefix   /usr

Name:       %{name}
Version:    %{version}
Release:    %{release}
Summary:    Bitzi's Bitcollider utility and libbitcollider
Source:     http://www.bitzi.com/bitcollider/source/%{name}-%{version}.tar.gz
URL:        http://www.bitzi.com
Group:      Applications/Internet
BuildRoot:  %{_tmppath}/%{name}-buildroot
Copyright:  Public Domain
Prefix:     %{_prefix}
Docdir:     %{prefix}/doc

%description
This package includes Bitzi's bitcollide utility and the libbitcollider
shared/static libraries. The bitcollide utility allows the user to look
up any mp3/video/image/file in the Bitzi community metadata project.

%package    devel
Summary:    Headers for developing programs with the bitcollider library.
Group:      Development/Libraries
Requires:   %{name}

%description devel
This package contains the headers that programmers will need to develop
applications with libbitcollider.

%package    vorbis
Summary:    Ogg/Vorbis bitcollider plugin for extracting metadata from Vorbis files.
Group:      Development/Libraries
Requires:   %{name} libogg >= 1.0beta4, libvorbis >= 1.0beta4

%description vorbis
This package contains the Ogg/Vorbis plugin to extract metadata from
Vorbis files.

%prep
%setup -q

%build
./configure --prefix=%{prefix}
make 

%install
rm -rf $RPM_BUILD_ROOT
make prefix=$RPM_BUILD_ROOT%{prefix} install
install -s src/bitcollider $RPM_BUILD_ROOT%{prefix}/bin
install -s plugins/*.bcp $RPM_BUILD_ROOT%{prefix}/lib/bitcollider/plugins
strip $RPM_BUILD_ROOT%{prefix}/lib/*.so.*
strip $RPM_BUILD_ROOT%{prefix}/lib/*.a
strip $RPM_BUILD_ROOT%{prefix}/lib/*.so

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig
%postun -p /sbin/ldconfig

%files
%defattr(-, root, root)
%{prefix}/bin/bitcollider
%doc AUTHORS COPYING NEWS README INSTALL
%{prefix}/lib/*.so.*
%{prefix}/lib/bitcollider/plugins/wav.bcp
%{prefix}/lib/bitcollider/plugins/image.bcp

%files devel
%defattr(-, root, root)
%{prefix}/include/bitcollider
%{prefix}/lib/*.la
%{prefix}/lib/*.a
%{prefix}/lib/*.so

%files vorbis
%defattr(-, root, root)
%{prefix}/lib/bitcollider/plugins/vorbis.bcp

%changelog
* Mon Feb 19 2001 Robert Kaye <rob@bitzi.com> 1.0.0pre1
- First attempt to create a spec file for this library
