" PML syntax file
" Language: PyMol Scripting Language 2.0
" Filetypes: .pml
" Maintainer: bioSyntax
" Version: v0.1
"
" Copyright (C) 2012 Thomas Holder
" Copyright (C) 2009 Michal Gajda
"

if exists("b:current_syntax")
  finish
endif

set iskeyword=@,48-57,_,192-255,.

syntax match   pymolIdentifier "[a-zA-Z0-9().]"

" pymol -k
" PyMOL> print('\n  \\ '.join(sorted(filter(lambda kw: not (kw.startswith('_') or kw in ['python', 'run']), cmd.kw_list))))
syntax keyword pymolCommand
  \ abort
  \ accept
  \ alias
  \ align
  \ alignto
  \ alphatoall
  \ alter
  \ alter_state
  \ angle
  \ api
  \ as
  \ assert
  \ attach
  \ backward
  \ bg_color
  \ bond
  \ button
  \ cache
  \ callout
  \ capture
  \ cartoon
  \ cd
  \ cealign
  \ center
  \ centerofmass
  \ check
  \ class
  \ clean
  \ clip
  \ cls
  \ color
  \ config_mouse
  \ copy
  \ copy_to
  \ count_atoms
  \ count_discrete
  \ count_frames
  \ count_states
  \ create
  \ cycle_valence
  \ decline
  \ def
  \ del
  \ delete
  \ deprotect
  \ desaturate
  \ deselect
  \ dihedral
  \ dir
  \ disable
  \ distance
  \ drag
  \ draw
  \ dss
  \ dump
  \ edit
  \ edit_mode
  \ embed
  \ enable
  \ ending
  \ exec
  \ export_dots
  \ extra_fit
  \ extract
  \ fab
  \ feedback
  \ fetch
  \ fit
  \ fix_chemistry
  \ flag
  \ focal_blur
  \ for
  \ fork
  \ forward
  \ fragment
  \ frame
  \ full_screen
  \ fuse
  \ get
  \ get_angle
  \ get_area
  \ get_bond
  \ get_chains
  \ get_dihedral
  \ get_distance
  \ get_extent
  \ get_position
  \ get_property
  \ get_property_list
  \ get_renderer
  \ get_sasa_relative
  \ get_symmetry
  \ get_title
  \ get_type
  \ get_version
  \ get_view
  \ get_viewport
  \ global
  \ gradient
  \ group
  \ h_add
  \ h_fill
  \ h_fix
  \ help
  \ help_setting
  \ hide
  \ id_atom
  \ identify
  \ if
  \ import
  \ index
  \ indicate
  \ intra_fit
  \ intra_rms
  \ intra_rms_cur
  \ invert
  \ isodot
  \ isolevel
  \ isomesh
  \ isosurface
  \ iterate
  \ iterate_state
  \ join_states
  \ label
  \ load
  \ load_embedded
  \ load_mtz
  \ load_png
  \ load_traj
  \ loadall
  \ log
  \ log_close
  \ log_open
  \ ls
  \ madd
  \ map_double
  \ map_halve
  \ map_new
  \ map_set
  \ map_set_border
  \ map_trim
  \ mappend
  \ mask
  \ matrix_copy
  \ matrix_reset
  \ mclear
  \ mcopy
  \ mdelete
  \ mdo
  \ mdump
  \ mem
  \ meter_reset
  \ middle
  \ minsert
  \ mmatrix
  \ mmove
  \ morph
  \ mouse
  \ move
  \ movie.load
  \ movie.nutate
  \ movie.pause
  \ movie.produce
  \ movie.rock
  \ movie.roll
  \ movie.screw
  \ movie.sweep
  \ movie.tdroll
  \ movie.zoom
  \ mplay
  \ mpng
  \ mse2met
  \ mset
  \ mstop
  \ mtoggle
  \ multisave
  \ mview
  \ order
  \ orient
  \ origin
  \ overlap
  \ pair_fit
  \ pass
  \ phi_psi
  \ png
  \ pop
  \ protect
  \ pseudoatom
  \ pwd
  \ quit
  \ raise
  \ ramp_new
  \ ramp_update
  \ ray
  \ rebuild
  \ recolor
  \ redo
  \ reference
  \ refresh
  \ refresh_wizard
  \ reinitialize
  \ remove
  \ remove_picked
  \ rename
  \ replace
  \ replace_wizard
  \ reset
  \ resume
  \ rewind
  \ rms
  \ rms_cur
  \ rock
  \ rotate
  \ save
  \ scene
  \ scene_order
  \ sculpt_activate
  \ sculpt_deactivate
  \ sculpt_iterate
  \ sculpt_purge
  \ select
  \ set
  \ set_atom_property
  \ set_bond
  \ set_color
  \ set_dihedral
  \ set_geometry
  \ set_key
  \ set_name
  \ set_property
  \ set_symmetry
  \ set_title
  \ set_view
  \ show
  \ slice_new
  \ smooth
  \ sort
  \ space
  \ spawn
  \ spectrum
  \ spheroid
  \ splash
  \ split_chains
  \ split_states
  \ stereo
  \ super
  \ symexp
  \ symmetry_copy
  \ system
  \ toggle
  \ torsion
  \ translate
  \ try
  \ turn
  \ unbond
  \ undo
  \ ungroup
  \ uniquify
  \ unmask
  \ unpick
  \ unset
  \ unset_bond
  \ unset_deep
  \ update
  \ util.cbab
  \ util.cbac
  \ util.cbag
  \ util.cbak
  \ util.cbam
  \ util.cbao
  \ util.cbap
  \ util.cbas
  \ util.cbaw
  \ util.cbay
  \ util.cbc
  \ util.chainbow
  \ util.cnc
  \ util.rainbow
  \ util.ss
  \ valence
  \ vdw_fit
  \ view
  \ viewport
  \ volume
  \ volume_color
  \ volume_panel
  \ volume_ramp_new
  \ while
  \ window
  \ wizard
  \ zoom

" PyMOL> print('\n  \\ '.join(sorted(set(cmd.setting.name_list).difference(cmd.kw_list))))
syntax keyword pymolSetting
  \ active_selections
  \ alignment_as_cylinders
  \ all_states
  \ ambient
  \ ambient_occlusion_mode
  \ ambient_occlusion_scale
  \ ambient_occlusion_smooth
  \ anaglyph_mode
  \ angle_color
  \ angle_label_position
  \ angle_size
  \ animation
  \ animation_duration
  \ antialias
  \ antialias_shader
  \ assembly
  \ async_builds
  \ ati_bugs
  \ atom_name_wildcard
  \ atom_type_format
  \ auto_classify_atoms
  \ auto_color
  \ auto_color_next
  \ auto_copy_images
  \ auto_defer_atom_count
  \ auto_defer_builds
  \ auto_dss
  \ auto_hide_selections
  \ auto_indicate_flags
  \ auto_number_selections
  \ auto_overlay
  \ auto_remove_hydrogens
  \ auto_rename_duplicate_objects
  \ auto_sculpt
  \ auto_show_classified
  \ auto_show_lines
  \ auto_show_nonbonded
  \ auto_show_selections
  \ auto_show_spheres
  \ auto_zoom
  \ autoclose_dialogs
  \ backface_cull
  \ batch_prefix
  \ bg_gradient
  \ bg_image_filename
  \ bg_image_linear
  \ bg_image_mode
  \ bg_image_tilesize
  \ bg_rgb
  \ bg_rgb_bottom
  \ bg_rgb_top
  \ button_mode
  \ button_mode_name
  \ cache_display
  \ cache_frames
  \ cache_max
  \ cache_memory
  \ cache_mode
  \ cartoon_all_alt
  \ cartoon_color
  \ cartoon_cylindrical_helices
  \ cartoon_debug
  \ cartoon_discrete_colors
  \ cartoon_dumbbell_length
  \ cartoon_dumbbell_radius
  \ cartoon_dumbbell_width
  \ cartoon_fancy_helices
  \ cartoon_fancy_sheets
  \ cartoon_flat_cycles
  \ cartoon_flat_sheets
  \ cartoon_gap_cutoff
  \ cartoon_helix_radius
  \ cartoon_highlight_color
  \ cartoon_ladder_color
  \ cartoon_ladder_mode
  \ cartoon_ladder_radius
  \ cartoon_loop_cap
  \ cartoon_loop_quality
  \ cartoon_loop_radius
  \ cartoon_nucleic_acid_as_cylinders
  \ cartoon_nucleic_acid_color
  \ cartoon_nucleic_acid_mode
  \ cartoon_oval_length
  \ cartoon_oval_quality
  \ cartoon_oval_width
  \ cartoon_power
  \ cartoon_power_b
  \ cartoon_putty_quality
  \ cartoon_putty_radius
  \ cartoon_putty_range
  \ cartoon_putty_scale_max
  \ cartoon_putty_scale_min
  \ cartoon_putty_scale_power
  \ cartoon_putty_transform
  \ cartoon_rect_length
  \ cartoon_rect_width
  \ cartoon_refine
  \ cartoon_refine_normals
  \ cartoon_refine_tips
  \ cartoon_ring_color
  \ cartoon_ring_finder
  \ cartoon_ring_mode
  \ cartoon_ring_radius
  \ cartoon_ring_transparency
  \ cartoon_ring_width
  \ cartoon_round_helices
  \ cartoon_sampling
  \ cartoon_side_chain_helper
  \ cartoon_smooth_cycles
  \ cartoon_smooth_first
  \ cartoon_smooth_last
  \ cartoon_smooth_loops
  \ cartoon_throw
  \ cartoon_trace_atoms
  \ cartoon_transparency
  \ cartoon_tube_cap
  \ cartoon_tube_quality
  \ cartoon_tube_radius
  \ cartoon_use_shader
  \ cavity_cull
  \ cgo_debug
  \ cgo_dot_radius
  \ cgo_dot_width
  \ cgo_ellipsoid_quality
  \ cgo_lighting
  \ cgo_line_radius
  \ cgo_line_width
  \ cgo_ray_width_scale
  \ cgo_shader_ub_color
  \ cgo_shader_ub_flags
  \ cgo_shader_ub_normal
  \ cgo_sphere_quality
  \ cgo_transparency
  \ cgo_use_shader
  \ chromadepth
  \ cif_keepinmemory
  \ cif_use_auth
  \ clamp_colors
  \ clean_electro_mode
  \ collada_background_box
  \ collada_export_lighting
  \ collada_geometry_mode
  \ cone_quality
  \ connect_bonded
  \ connect_cutoff
  \ connect_mode
  \ coulomb_cutoff
  \ coulomb_dielectric
  \ coulomb_units_factor
  \ dash_as_cylinders
  \ dash_color
  \ dash_gap
  \ dash_length
  \ dash_radius
  \ dash_round_ends
  \ dash_transparency
  \ dash_use_shader
  \ dash_width
  \ debug_pick
  \ default_2fofc_map_rep
  \ default_buster_names
  \ default_fofc_map_rep
  \ default_phenix_names
  \ default_phenix_no_fill_names
  \ default_refmac_names
  \ defer_builds_mode
  \ defer_updates
  \ depth_cue
  \ dihedral_color
  \ dihedral_label_position
  \ dihedral_size
  \ direct
  \ display_scale_factor
  \ dist_counter
  \ distance_exclusion
  \ dot_as_spheres
  \ dot_color
  \ dot_density
  \ dot_hydrogens
  \ dot_lighting
  \ dot_mode
  \ dot_normals
  \ dot_radius
  \ dot_solvent
  \ dot_use_shader
  \ dot_width
  \ draw_frames
  \ draw_mode
  \ dynamic_measures
  \ dynamic_width
  \ dynamic_width_factor
  \ dynamic_width_max
  \ dynamic_width_min
  \ edit_light
  \ editor_auto_dihedral
  \ editor_auto_measure
  \ editor_auto_origin
  \ editor_bond_cycle_mode
  \ editor_label_fragments
  \ ellipsoid_color
  \ ellipsoid_probability
  \ ellipsoid_quality
  \ ellipsoid_scale
  \ ellipsoid_transparency
  \ fast_idle
  \ fetch_host
  \ fetch_path
  \ fetch_type_default
  \ field_of_view
  \ fit_iterations
  \ fit_kabsch
  \ fit_tolerance
  \ float_labels
  \ fog
  \ fog_start
  \ gamma
  \ gaussian_b_adjust
  \ gaussian_b_floor
  \ gaussian_resolution
  \ geometry_export_mode
  \ gradient_max_length
  \ gradient_min_length
  \ gradient_min_slope
  \ gradient_normal_min_dot
  \ gradient_spacing
  \ gradient_step_size
  \ gradient_symmetry
  \ grid_max
  \ grid_mode
  \ grid_slot
  \ group_arrow_prefix
  \ group_auto_mode
  \ group_full_member_names
  \ h_bond_cone
  \ h_bond_cutoff_center
  \ h_bond_cutoff_edge
  \ h_bond_exclusion
  \ h_bond_from_proton
  \ h_bond_max_angle
  \ h_bond_power_a
  \ h_bond_power_b
  \ half_bonds
  \ hash_max
  \ heavy_neighbor_cutoff
  \ hide_long_bonds
  \ hide_underscore_names
  \ idle_delay
  \ ignore_case
  \ ignore_case_chain
  \ ignore_pdb_segi
  \ image_copy_always
  \ image_dots_per_inch
  \ internal_feedback
  \ internal_gui
  \ internal_gui_control_size
  \ internal_gui_mode
  \ internal_gui_width
  \ internal_prompt
  \ isomesh_auto_state
  \ keep_alive
  \ label_anchor
  \ label_angle_digits
  \ label_bg_color
  \ label_bg_outline
  \ label_bg_transparency
  \ label_color
  \ label_connector
  \ label_connector_color
  \ label_connector_ext_length
  \ label_connector_mode
  \ label_connector_width
  \ label_digits
  \ label_dihedral_digits
  \ label_distance_digits
  \ label_font_id
  \ label_multiline_justification
  \ label_multiline_spacing
  \ label_outline_color
  \ label_padding
  \ label_placement_offset
  \ label_position
  \ label_relative_mode
  \ label_screen_point
  \ label_shadow_mode
  \ label_size
  \ label_z_target
  \ legacy_mouse_zoom
  \ light
  \ light2
  \ light3
  \ light4
  \ light5
  \ light6
  \ light7
  \ light8
  \ light9
  \ light_count
  \ line_as_cylinders
  \ line_color
  \ line_radius
  \ line_smooth
  \ line_stick_helper
  \ line_use_shader
  \ line_width
  \ load_atom_props_default
  \ load_object_props_default
  \ log_box_selections
  \ log_conformations
  \ logging
  \ map_auto_expand_sym
  \ matrix_mode
  \ max_threads
  \ max_ups
  \ mesh_as_cylinders
  \ mesh_carve_cutoff
  \ mesh_carve_selection
  \ mesh_carve_state
  \ mesh_clear_cutoff
  \ mesh_clear_selection
  \ mesh_clear_state
  \ mesh_color
  \ mesh_cutoff
  \ mesh_grid_max
  \ mesh_lighting
  \ mesh_mode
  \ mesh_negative_color
  \ mesh_negative_visible
  \ mesh_normals
  \ mesh_quality
  \ mesh_radius
  \ mesh_skip
  \ mesh_solvent
  \ mesh_type
  \ mesh_use_shader
  \ mesh_width
  \ min_mesh_spacing
  \ moe_separate_chains
  \ motion_bias
  \ motion_hand
  \ motion_linear
  \ motion_power
  \ motion_simple
  \ mouse_grid
  \ mouse_limit
  \ mouse_restart_movie_delay
  \ mouse_scale
  \ mouse_selection_mode
  \ mouse_wheel_scale
  \ mouse_z_scale
  \ movie_animate_by_frame
  \ movie_auto_interpolate
  \ movie_auto_store
  \ movie_delay
  \ movie_fps
  \ movie_loop
  \ movie_panel
  \ movie_panel_row_height
  \ movie_quality
  \ movie_rock
  \ multiplex
  \ nb_spheres_quality
  \ nb_spheres_size
  \ nb_spheres_use_shader
  \ neighbor_cutoff
  \ no_idle
  \ nonbonded_as_cylinders
  \ nonbonded_size
  \ nonbonded_transparency
  \ nonbonded_use_shader
  \ normal_workaround
  \ normalize_ccp4_maps
  \ normalize_grd_maps
  \ normalize_o_maps
  \ nvidia_bugs
  \ opaque_background
  \ orthoscopic
  \ overlay
  \ overlay_lines
  \ pdb_conect_all
  \ pdb_conect_nodup
  \ pdb_discrete_chains
  \ pdb_echo_tags
  \ pdb_formal_charges
  \ pdb_hetatm_guess_valences
  \ pdb_hetatm_sort
  \ pdb_honor_model_number
  \ pdb_ignore_conect
  \ pdb_insertions_go_first
  \ pdb_insure_orthogonal
  \ pdb_literal_names
  \ pdb_no_end_record
  \ pdb_reformat_names_mode
  \ pdb_retain_ids
  \ pdb_standard_order
  \ pdb_truncate_residue_name
  \ pdb_unbond_cations
  \ pdb_use_ter_records
  \ pick32bit
  \ pick_labels
  \ pick_shading
  \ pick_surface
  \ pickable
  \ png_file_gamma
  \ png_screen_gamma
  \ polar_neighbor_cutoff
  \ power
  \ pqr_no_chain_id
  \ precomputed_lighting
  \ presentation
  \ presentation_auto_quit
  \ presentation_auto_start
  \ presentation_mode
  \ preserve_chempy_ids
  \ pse_binary_dump
  \ pse_export_version
  \ pymol_space_max_blue
  \ pymol_space_max_green
  \ pymol_space_max_red
  \ pymol_space_min_factor
  \ raise_exceptions
  \ ramp_blend_nearby_colors
  \ rank_assisted_sorts
  \ ray_blend_blue
  \ ray_blend_colors
  \ ray_blend_green
  \ ray_blend_red
  \ ray_clip_shadows
  \ ray_color_ramps
  \ ray_default_renderer
  \ ray_direct_shade
  \ ray_hint_camera
  \ ray_hint_shadow
  \ ray_improve_shadows
  \ ray_interior_color
  \ ray_interior_mode
  \ ray_interior_reflect
  \ ray_interior_shadows
  \ ray_interior_texture
  \ ray_label_connector_flat
  \ ray_label_specular
  \ ray_legacy_lighting
  \ ray_max_passes
  \ ray_opaque_background
  \ ray_orthoscopic
  \ ray_oversample_cutoff
  \ ray_pixel_scale
  \ ray_scatter
  \ ray_shadow
  \ ray_shadow_decay_factor
  \ ray_shadow_decay_range
  \ ray_shadow_fudge
  \ ray_spec_local
  \ ray_texture
  \ ray_texture_settings
  \ ray_trace_color
  \ ray_trace_depth_factor
  \ ray_trace_disco_factor
  \ ray_trace_fog
  \ ray_trace_fog_start
  \ ray_trace_frames
  \ ray_trace_gain
  \ ray_trace_mode
  \ ray_trace_persist_cutoff
  \ ray_trace_slope_factor
  \ ray_trace_trans_cutoff
  \ ray_transparency_contrast
  \ ray_transparency_oblique
  \ ray_transparency_oblique_power
  \ ray_transparency_shadows
  \ ray_transparency_spec_cut
  \ ray_transparency_specular
  \ ray_triangle_fudge
  \ ray_volume
  \ reflect
  \ reflect_power
  \ render_as_cylinders
  \ retain_order
  \ ribbon_as_cylinders
  \ ribbon_color
  \ ribbon_nucleic_acid_mode
  \ ribbon_power
  \ ribbon_power_b
  \ ribbon_radius
  \ ribbon_sampling
  \ ribbon_side_chain_helper
  \ ribbon_throw
  \ ribbon_trace_atoms
  \ ribbon_transparency
  \ ribbon_use_shader
  \ ribbon_width
  \ robust_logs
  \ rock_delay
  \ roving_byres
  \ roving_cartoon
  \ roving_delay
  \ roving_detail
  \ roving_isomesh
  \ roving_isosurface
  \ roving_labels
  \ roving_lines
  \ roving_map1_level
  \ roving_map1_name
  \ roving_map2_level
  \ roving_map2_name
  \ roving_map3_level
  \ roving_map3_name
  \ roving_nb_spheres
  \ roving_nonbonded
  \ roving_origin
  \ roving_origin_z
  \ roving_origin_z_cushion
  \ roving_polar_contacts
  \ roving_polar_cutoff
  \ roving_ribbon
  \ roving_selection
  \ roving_spheres
  \ roving_sticks
  \ scene_animation
  \ scene_animation_duration
  \ scene_buttons
  \ scene_current_name
  \ scene_frame_mode
  \ scene_loop
  \ scene_restart_movie_delay
  \ scenes_changed
  \ sculpt_angl_weight
  \ sculpt_auto_center
  \ sculpt_avd_excl
  \ sculpt_avd_gap
  \ sculpt_avd_range
  \ sculpt_avd_weight
  \ sculpt_bond_weight
  \ sculpt_field_mask
  \ sculpt_hb_overlap
  \ sculpt_hb_overlap_base
  \ sculpt_line_weight
  \ sculpt_max_max
  \ sculpt_max_min
  \ sculpt_max_scale
  \ sculpt_max_weight
  \ sculpt_memory
  \ sculpt_min_max
  \ sculpt_min_min
  \ sculpt_min_scale
  \ sculpt_min_weight
  \ sculpt_nb_interval
  \ sculpt_plan_weight
  \ sculpt_pyra_inv_weight
  \ sculpt_pyra_weight
  \ sculpt_tors_tolerance
  \ sculpt_tors_weight
  \ sculpt_tri_max
  \ sculpt_tri_min
  \ sculpt_tri_mode
  \ sculpt_tri_scale
  \ sculpt_tri_weight
  \ sculpt_vdw_scale
  \ sculpt_vdw_scale14
  \ sculpt_vdw_vis_max
  \ sculpt_vdw_vis_mid
  \ sculpt_vdw_vis_min
  \ sculpt_vdw_vis_mode
  \ sculpt_vdw_weight
  \ sculpt_vdw_weight14
  \ sculpting
  \ sculpting_cycles
  \ sdof_drag_scale
  \ secondary_structure
  \ security
  \ sel_counter
  \ selection_overlay
  \ selection_round_points
  \ selection_visible_only
  \ selection_width
  \ selection_width_max
  \ selection_width_scale
  \ seq_view
  \ seq_view_alignment
  \ seq_view_color
  \ seq_view_discrete_by_state
  \ seq_view_fill_char
  \ seq_view_fill_color
  \ seq_view_format
  \ seq_view_label_color
  \ seq_view_label_mode
  \ seq_view_label_spacing
  \ seq_view_label_start
  \ seq_view_location
  \ seq_view_overlay
  \ seq_view_unaligned_color
  \ seq_view_unaligned_mode
  \ session_cache_optimize
  \ session_changed
  \ session_compression
  \ session_embeds_data
  \ session_file
  \ session_migration
  \ session_version_check
  \ shaders_from_disk
  \ shininess
  \ show_alpha_checker
  \ show_frame_rate
  \ show_progress
  \ single_image
  \ slice_dynamic_grid
  \ slice_dynamic_grid_resolution
  \ slice_grid
  \ slice_height_map
  \ slice_height_scale
  \ slice_track_camera
  \ slow_idle
  \ smooth_color_triangle
  \ smooth_half_bonds
  \ solvent_radius
  \ spec_count
  \ spec_direct
  \ spec_direct_power
  \ spec_power
  \ spec_reflect
  \ specular
  \ specular_intensity
  \ sphere_color
  \ sphere_mode
  \ sphere_point_max_size
  \ sphere_point_size
  \ sphere_quality
  \ sphere_scale
  \ sphere_solvent
  \ sphere_transparency
  \ sphere_use_shader
  \ spheroid_fill
  \ spheroid_scale
  \ spheroid_smooth
  \ ss_helix_phi_exclude
  \ ss_helix_phi_include
  \ ss_helix_phi_target
  \ ss_helix_psi_exclude
  \ ss_helix_psi_include
  \ ss_helix_psi_target
  \ ss_strand_phi_exclude
  \ ss_strand_phi_include
  \ ss_strand_phi_target
  \ ss_strand_psi_exclude
  \ ss_strand_psi_include
  \ ss_strand_psi_target
  \ state
  \ state_counter_mode
  \ static_singletons
  \ stereo_angle
  \ stereo_double_pump_mono
  \ stereo_dynamic_strength
  \ stereo_mode
  \ stereo_shift
  \ stick_as_cylinders
  \ stick_ball
  \ stick_ball_color
  \ stick_ball_ratio
  \ stick_color
  \ stick_debug
  \ stick_fixed_radius
  \ stick_good_geometry
  \ stick_h_scale
  \ stick_nub
  \ stick_overlap
  \ stick_quality
  \ stick_radius
  \ stick_round_nub
  \ stick_transparency
  \ stick_use_shader
  \ stick_valence_scale
  \ stop_on_exceptions
  \ suppress_hidden
  \ surface_best
  \ surface_carve_cutoff
  \ surface_carve_normal_cutoff
  \ surface_carve_selection
  \ surface_carve_state
  \ surface_cavity_cutoff
  \ surface_cavity_mode
  \ surface_cavity_radius
  \ surface_circumscribe
  \ surface_clear_cutoff
  \ surface_clear_selection
  \ surface_clear_state
  \ surface_color
  \ surface_color_smoothing
  \ surface_color_smoothing_threshold
  \ surface_debug
  \ surface_miserable
  \ surface_mode
  \ surface_negative_color
  \ surface_negative_visible
  \ surface_normal
  \ surface_optimize_subsets
  \ surface_poor
  \ surface_proximity
  \ surface_quality
  \ surface_ramp_above_mode
  \ surface_residue_cutoff
  \ surface_smooth_edges
  \ surface_solvent
  \ surface_trim_cutoff
  \ surface_trim_factor
  \ surface_type
  \ surface_use_shader
  \ suspend_deferred
  \ suspend_undo
  \ suspend_undo_atom_count
  \ suspend_updates
  \ swap_dsn6_bytes
  \ sweep_angle
  \ sweep_mode
  \ sweep_phase
  \ sweep_speed
  \ test1
  \ test2
  \ text
  \ trace_atoms_mode
  \ transparency
  \ transparency_global_sort
  \ transparency_mode
  \ transparency_picking_mode
  \ triangle_max_passes
  \ trilines
  \ trim_dots
  \ two_sided_lighting
  \ use_geometry_shaders
  \ use_shaders
  \ valence_mode
  \ valence_size
  \ valence_zero_mode
  \ valence_zero_scale
  \ validate_object_names
  \ virtual_trackball
  \ volume_bit_depth
  \ volume_data_range
  \ volume_layers
  \ volume_mode
  \ wildcard
  \ wizard_prompt_mode
  \ wrap_output

syntax match   pymolOperator1   "[!|&,()?]"
syntax match   pymolOperator2   "([|aew].)|(b[rfmso].)|(nbr.)|([?][?][?])"
syntax keyword pymolOperatorK   and or not in gap around within of byres bymolecule byfragment bysegment byobject bycell neighbor extend
  \ first last like bychain bycalpha bound_to expand near_to beyond
syntax cluster pymolOperator    contains=pymolOperator1,pymolOperator2,pymolOperatorK
syntax keyword pymolSelector    resi resn name alt chain segi flag numeric_type text_type id index ss b q formal_charge partial_charge
  \ model rank elem rep color pepseq
  \ all enabled visible bonded protected masked
  \ organic inorganic solvent polymer guide hetatm hydrogens metals
  \ backbone sidechain donors acceptors
  \ center origin

syntax match   pymolComment     "^#.*$"
syntax match   pymolNumber      "*[0-9](.[0-9])?"
syntax match   pymolString1     "'[^']*'"
syntax match   pymolString2     '"[^"]*"'
syntax cluster pymolString      contains=pymolString1,pymolString2
syntax match   pymolIdentifier  "[A-Za-z_][A-Za-z_.0-9()]*"
syntax match   pymolPunctuation "[(),]"
syntax match   pymolRun         "^\(@\|run \) *[^;]\+"
syntax match   pymolKwArg       "\<\w\+="

syn include @python syntax/python.vim
unlet b:current_syntax

syn region     pymolSkip        matchgroup=pymolCommand start=+^skip$+ end=+^skip end$+
syn region     pymolPython      matchgroup=pymolCommand start=+^python$+ end=+^python end$+ contains=@python
syn match      pymolPython      "^/.*" contains=@python

hi def link    pymolCommand     Statement
hi def link    pymolIdentifier  Symbol
hi def link    pymolOperator    Operator
hi def link    pymolSkip        Comment
hi def link    pymolComment     Comment
hi def link    pymolString      String
hi def link    pymolSelector    Function
hi def link    pymolPunctuation SpecialChar
hi def link    pymolSetting     Identifier
hi def link    pymolRun         Include
hi def link    pymolKwArg       Operator

let b:current_syntax = "pymol"

" vi:nowrap:sw=2:expandtab
