/* 
 * Copyright (c) 2010 Craig Heffner
 *
 * This software is provided under the MIT license. For the full text of this license, please see
 * the COPYING file included with this code, or visit http://www.opensource.org/licenses/MIT.
 */

#ifndef SMARTSIG_H
#define SMARGSIG_H

/*
 * Order is important when defining these keywords in a signature. These keywords must be the
 * last strings to appear in the signature string. If multiple keywords are used, their order 
 * of appearance must be:
 *
 *	o ONE_OF_MANY
 *	o JUMP_TO_OFFSET
 */
#define ONE_OF_MANY	"one-of-many"
#define JUMP_TO_OFFSET	"jump-to-offset:"

int is_repeat_of_many(char *match);
int jump_to_offset(char *match);

#endif
