var bm = require("../shared-modules/bookmarks");

const TIMEOUT = 5000;

const LOCAL_TEST_FOLDER = collector.addHttpResource('../test-files/');
const LOCAL_TEST_PAGE = LOCAL_TEST_FOLDER + 'test.html';
const LOCAL_TEST_FEED = LOCAL_TEST_FOLDER + 'feed.atom';

var setupModule = function(module) {
    module.controller = mozmill.getBrowserController();
    module.jum = {};
    module.desktopcouch = {};
    module.sync = {};
    Cu.import("resource://mozmill/modules/jum.js", module.jum);
    Cu.import("resource://bindwood/desktopcouch.jsm", module.desktopcouch);
    Cu.import("resource://bindwood/sync.jsm", module.sync);
    bm.clearBookmarks();
    module.couch = null;
};


var setupTest = function(test) {
    var done = false;
    desktopcouch.connect_desktopcouch("test_bookmarks", function(db) {
            couch = db;
            done = true;
        }, function (message) {});
    controller.waitFor(
        function() { return done; }, "Could not connect to CouchDB", TIMEOUT);
    jum.assertNotEquals(couch, null);

    try {
        couch.createDb();
    } catch (e) {
        if (e.error != 'file_exists')
            throw(e);
    }
};


var teardownTest = function(test) {
    bm.clearBookmarks();
    couch.deleteDb();
};

var compareIds = function(doc1, doc2) {
    if (doc1._id < doc2._id)
        return -1;
    if (doc1._id > doc2._id)
        return 1;
    return 0;
}

var test_ensureViews = function() {
    var synchroniser = new sync.Synchroniser(couch, "profile_name");
    synchroniser.ensureCouchViews();

    var doc = couch.open("_design/bindwood");
    jum.assertNotEquals(doc, null);
    jum.assert(
        doc.views.bookmarks, "Design doc should have bookmarks view");
    jum.assert(
        doc.filters.by_profile, "Design doc should have by_profile filter");
};

var test_pullChanges = function() {
    var synchroniser = new sync.Synchroniser(couch, "profile_name");
    synchroniser.ensureCouchViews();

    var documents = [];
    synchroniser.processRecord = function(doc) {
        documents.push(doc);
    };

    couch.save({
            _id: 'guid-1',
            application_annotations: {
                Firefox: {
                    profile: 'profile_name',
                },
            },
        });
    couch.save({
            _id: 'guid-2',
            application_annotations: {
                Firefox: {
                    profile: 'some_other_profile',
                },
            },
        });
    couch.save({
            _id: 'guid-3',
            application_annotations: {
                Firefox: {
                    profile: 'profile_name',
                },
            },
        });
    synchroniser.pullChanges();
    jum.assertEquals(documents.length, 2);
    documents.sort(compareIds);
    jum.assertEquals(documents[0]._id, 'guid-1');
    jum.assertEquals(documents[1]._id, 'guid-3');

    // Delete one of the documents.
    couch.deleteDoc(couch.open('guid-1'));

    // Create a new document, and then modify it.
    couch.save({
            _id: 'guid-4',
            application_annotations: {
                Firefox: {
                    profile: 'profile_name',
                },
            },
        })
    doc = couch.open('guid-4');
    doc.attr = 'value';
    couch.save(doc);

    // Create another record belonging to a different profile:
    couch.save({
            _id: 'guid-5',
            application_annotations: {
                Firefox: {
                    profile: 'some_other_profile',
                },
            },
        });


    // Calling pullChanges() again gives us incremental changes.
    documents = []
    synchroniser.pullChanges();
    jum.assertEquals(documents.length, 2);
    documents.sort(compareIds);
    jum.assertEquals(documents[0]._id, 'guid-1');
    jum.assertEquals(documents[0]._deleted, true);
    jum.assertEquals(documents[1]._id, 'guid-4');
};
