const TIMEOUT = 5000;

var setupModule = function(module) {
  module.controller = mozmill.getBrowserController();
  module.desktopcouch = {};
  module.jum = {};
  Components.utils.import("resource://bindwood/desktopcouch.jsm", module.desktopcouch);
  Components.utils.import("resource://mozmill/modules/jum.js", module.jum);
};

var test_get_desktopcouch_environment = function() {
    var log_messages = [];
    var environment = null;
    var done = false;

    var callback = function(env) {
        environment = env;
        done = true;
    };
    var log = function(msg) {
        log_messages.push(msg);
    };
    desktopcouch._get_desktopcouch_environment(
        function(env) {
            environment = env;
            done = true;
        }, function(message) {
            log_messages.push(message);
        });
    controller.waitFor(
        function() { return done;}, "Environment loaded", TIMEOUT);
    jum.assertEquals(done, true);
    jum.assertNotEquals(environment, null);
    jum.assertEquals(log_messages.length, 1);
    jum.assertEquals(log_messages[0], "Got our environment, proceeding.");
};

var test_connect_desktopcouch = function() {
    var database = null;
    var done = false;

    desktopcouch.connect_desktopcouch(
        "test_bookmarks",
        function (db) {
            database = db;
            done = true;
        }, function (message) { });
    controller.waitFor(
        function() { return done;}, "Connected to CouchDB", TIMEOUT);
    jum.assertEquals(done, true);
    jum.assertNotEquals(database, null);

    // Ensure the database exists.
    try {
        database.createDb();
    } catch (e) {
        if (e.error != 'file_exists') {
            throw(e);
        }
    }

    var info = database.info();
    jum.assertEquals(info.db_name, "test_bookmarks");
};
