;*=====================================================================*/
;*    serrano/prgm/project/bigloo/api/web/src/Llib/css-parser.scm      */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Dec 20 07:52:58 2005                          */
;*    Last change :  Mon Jan 23 10:35:13 2006 (serrano)                */
;*    Copyright   :  2005-06 Manuel Serrano                            */
;*    -------------------------------------------------------------    */
;*    CSS parsing                                                      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __web_css-parser
   
   (option (set! *unsafe-type* #t)
	   (set! *unsafe-arity* #t))
   
   (export (css-parser make-klass::procedure
		       make-element-name::procedure
		       make-declaration::procedure)))

;*---------------------------------------------------------------------*/
;*    css-parser ...                                                   */
;*---------------------------------------------------------------------*/
(define (css-parser make-klass
		    make-element-name
		    make-declaration)
   (lalr-grammar
      
      (CDO CDC INCLUDES DASHMATCH STRING IDENT HASH
	   IMPORT_SYM PAGE_SYM MEDIA_SYM FONT_FACE_SYM CHARSET_SYM
	   ATKEYWORD IMPORTANT_SYM EMS EXS LENGTH ANGLE TIME FREQ DIMEN
	   PERCENTAGE NUMBREC URI FUNCTION UNICODERANGE RGB NUMBER
	   COLON SEMI-COLON COMMA
	   BRA-OPEN BRA-CLO ANGLE-OPEN ANGLE-CLO PAR-CLO
	   SLASH * + > - DOT = EXTENSION)
      
      (stylesheet
       ((charset? comment* import*)
	(list charset? comment* import* '()))
       ((charset? comment* import* rule+)
	(list charset? comment* import* rule+)))
      
      (charset?
       (() '())
       ((charset) charset))
      
      (charset
       ((CHARSET_SYM STRING SEMI-COLON)
	(list (car CHARSET_SYM) (car STRING) ";\n")))
      
      (comment*
       (() '())
       ((comment* comment) `(,@comment* ,comment)))
      
      (comment
       ((CDO) (car CDO))
       ((CDC) (car CDC)))
      
      (import*
       (() '())
       ((import* one-import) `(,@import* ,one-import)))
      
      (one-import
       ((import comment*) `(,import ,@comment*)))
      
      (import
       ((IMPORT_SYM STRING medium* SEMI-COLON)
	`(,(car IMPORT_SYM) ,(car STRING) ,medium* ";\n"))
       ((IMPORT_SYM URI medium* SEMI-COLON)
	`(,(car IMPORT_SYM) ,(car URI) ,medium* ";\n")))
      
      (rule+
       ((one-rule) (list one-rule))
       ((rule+ one-rule) `(,@rule+ ,one-rule)))
      
      (one-rule
       ((rule comment*) (list rule comment*)))
      
      (rule
       ((ruleset) ruleset)
       ((media) media)
       ((page) page)
       ((font_face) font_face))
      
      (media
       ((MEDIA_SYM medium+ BRA-OPEN ruleset* BRA-CLO)
	`(,(car MEDIA_SYM) ,medium+ " { " ,ruleset* " }\n")))
      
      (page
       ((PAGE_SYM ident? pseudo_page? BRA-OPEN declaration+ BRA-CLO)
	`(,(car PAGE_SYM) ,ident? ,pseudo_page? " { " declaration+ " }\n")))
      
      (font_face
       ((FONT_FACE_SYM BRA-OPEN declaration+ BRA-CLO)
	`(,(car FONT_FACE_SYM) " { " ,declaration+ " }\n")))
      
      (medium*
       (() '())
       ((medium* COMMA medium) `(,@medium* ", " ,medium)))
      
      (medium+
       ((medium) (list medium))
       ((medium+ COMMA medium) `(,@medium+ ", " ,medium)))
      
      (medium
       ((IDENT) (car IDENT))
       ((EXTENSION) (car EXTENSION)))
      
      (ident?
       (() '())
       ((IDENT) IDENT)
       ((EXTENSION) (car EXTENSION)))
      
      (pseudo_page?
       (() '())
       ((pseudo_page) pseudo_page))
      
      (pseudo_page
       ((COLON IDENT) (string-append ":" (car IDENT)))
       ((COLON EXTENSION) (list ":" (car EXTENSION))))
      
      (property
       ((IDENT) (car IDENT))
       ((EXTENSION) (car EXTENSION)))
      
      (ruleset*
       (() '())
       ((ruleset* ruleset) `(,@ruleset* ,ruleset)))
      
      (ruleset
       ((selector+ BRA-OPEN declaration+ BRA-CLO)
	(list selector+ " {\n" declaration+ "}\n")))
      
      (selector+
       ((selector) selector)
       ((selector+ COMMA selector) `(,@selector+ ", " ,selector)))
      
      (selector
       ((simple_selector compound_selector*)
	`(,simple_selector ,@compound_selector*))
       ((simple_selector_attr+ compound_selector*)
	`(,simple_selector_attr+ ,@compound_selector*)))
      
      (compound_selector*
       (()
	'())
       ((compound_selector* combinator simple_selector)
	`(,@compound_selector* ,combinator ,simple_selector)))
      
      (combinator
       ((+) "+")
       ((>) ">")
       (() " "))
      
      (simple_selector
       ((element_name)
	element_name)
       ((element_name simple_selector_attr+)
	`(,element_name ,@simple_selector_attr+)))
      
      (simple_selector_attr+
       ((simple_selector_attr)
	(list simple_selector_attr))
       ((simple_selector_attr+ simple_selector_attr)
	`(,@simple_selector_attr+ ,simple_selector_attr)))
      
      (simple_selector_attr
       ((HASH) (car HASH))
       ((klass) klass)
       ((attrib) attrib)
       ((pseudo) pseudo))
      
      (klass
       ((DOT IDENT) (make-klass (car IDENT)))
       ((DOT EXTENSION) (list "." (car EXTENSION))))
      
      (element_name
       ((IDENT) (make-element-name (car IDENT)))
       ((EXTENSION) (car EXTENSION))
       ((*) "*"))
      
      (attrib
       ((ANGLE-OPEN IDENT ANGLE-CLO)
	(list "[" (car IDENT) "]"))
       ((ANGLE-OPEN EXTENSION ANGLE-CLO)
	(list "[" (car EXTENSION) "]"))
       ((ANGLE-OPEN IDENT attrib-left attrib-right ANGLE-CLO)
	(list "[" (car IDENT) attrib-left attrib-right "]"))
       ((ANGLE-OPEN EXTENSION attrib-left attrib-right ANGLE-CLO)
	(list "[" (car EXTENSION) attrib-left attrib-right "]")))
      
      (attrib-left
       ((=) "=")
       ((INCLUDES) (car INCLUDES))
       ((DASHMATCH) (car DASHMATCH)))
      
      (attrib-right
       ((IDENT) (car IDENT))
       ((STRING) (car STRING))
       ((EXTENSION) (car EXTENSION)))
      
      (pseudo
       ((COLON IDENT)
	(list ":" (car IDENT)))
       ((COLON EXTENSION)
	(list ":" (car EXTENSION)))
       ((COLON FUNCTION IDENT PAR-CLO)
	(list ":" (car FUNCTION) (car IDENT) ")"))
       ((COLON FUNCTION EXTENSION PAR-CLO)
	(list ":" (car FUNCTION) (car EXTENSION) ")")))
      
      (declaration+
       ((declaration)
	declaration)
       ((declaration+ SEMI-COLON declaration)
	`(,@declaration+ ";\n" ,declaration)))
      
      (declaration
       (() '())
       ((property COLON expr) (make-declaration property expr ""))
       ((property COLON expr prio) (make-declaration property expr prio)))
      
      (prio
       ((IMPORTANT_SYM) (car IMPORTANT_SYM)))
      
      (expr
       ((term) (list term))
       ((expr term) `(,@expr " " ,term))
       ((expr operator term) `(,@expr ,operator ,term)))

      (operator
       ((SLASH) " / ")
       ((COMMA) ", "))
      
      (unary_operator
       (() " ")
       ((-) "-")
       ((+) "+"))
      
      (term
       ((unary_operator NUMBER) (list unary_operator (car NUMBER)))
       ((unary_operator PERCENTAGE) (list unary_operator (car PERCENTAGE)))
       ((unary_operator LENGTH) (list unary_operator (car LENGTH)))
       ((unary_operator EMS) (list unary_operator (car EMS)))
       ((unary_operator EXS) (list unary_operator (car EXS)))
       ((unary_operator ANGLE) (list unary_operator (car ANGLE)))
       ((unary_operator TIME) (list unary_operator (car TIME)))
       ((unary_operator FREQ) (list unary_operator (car FREQ)))
       ((unary_operator function) (list unary_operator function))
       ((unary_operator EXTENSION) (list unary_operator (car EXTENSION)))
       ((STRING) (car STRING))
       ((IDENT) (car IDENT))
       ((URI) (car URI))
       ((RGB) (car RGB))
       ((UNICODERANGE) (car UNICODERANGE))
       ((hexcolor) hexcolor))
      
      (function
       ((FUNCTION expr PAR-CLO) (list (car FUNCTION) expr ")")))
      
      (hexcolor
       ((HASH) (car HASH)))))

