/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime/Jlib/server_socket.java      */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Tue Dec  5 10:53:03 2000                          */
/*    Last change :  Fri Mar 18 11:26:46 2005 (serrano)                */
/*    Copyright   :  2000-05 Manuel Serrano                            */
/*    -------------------------------------------------------------    */
/*    The Server Socket implementation for the JVM back-end.           */
/*=====================================================================*/
package bigloo;

import java.io.*;
import java.net.*;

/*---------------------------------------------------------------------*/
/*    SOCKET ...                                                       */
/*---------------------------------------------------------------------*/
public final class server_socket extends socket
{
  /*--- private fields ---------------------------------------------------*/
  private ServerSocket server_socket;
  private Socket client_socket;
  private boolean blocking;

  /*--- constructors ----------------------------------------------------*/
  public server_socket( final int port )
  {
    super();

    try
    {
      server_socket= new ServerSocket( port );
    }
    catch (final IOException _)
    {
      socket_error( "make-server-socket",
                    "cannot create socket",
                    new bint( port ) );
    }
  }

  private server_socket( final server_socket  templ )
  {
    super();
    server_socket= templ.server_socket;
    client_socket= templ.client_socket;
    blocking= templ.blocking;
  }

  /*--- public methods --------------------------------------------------*/
  public Object HOSTNAME()
  {
    if (client_socket != null)
      return client_socket.getInetAddress().getHostName().getBytes();
    else
      return bigloo.foreign.BFALSE;
  }

  public Object HOSTIP()
  {
    if (client_socket != null)
      return client_socket.getInetAddress().getHostAddress().getBytes();
    else
      return bigloo.foreign.BFALSE;
  }

  public byte[] local_addr()
  {
    return server_socket.getInetAddress().getHostAddress().getBytes();
  }

  public client_socket accept( boolean  blocking,
                               boolean  errp )
    throws IOException, SecurityException
  {
    final Socket        accepted_socket= server_socket.accept();

    return new client_socket( accepted_socket,
                              blocking );
  }

  public Object shutdown( final boolean  close_socket )
    throws IOException
  {
    if (client_socket != null)
      try
      {
        client_socket.shutdownOutput();
        client_socket.shutdownInput();
      }
    catch (Exception _)
    {
    }

    if (close_socket)
      close();

    return bigloo.foreign.BUNSPEC;
  }

  public Object close()
    throws IOException
  {
    server_socket.close();
    down= true;
    return bigloo.foreign.BUNSPEC;
  }

  public int PORT()
  {
    return server_socket.getLocalPort();
  }

  public void write( final output_port  p )
  {
    p.write( "#<socket:localhost" + "." + PORT() + ">" );
  }
}
