;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Ieee/fixnum.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jan 20 10:06:37 1995                          */
;*    Last change :  Tue Oct 18 15:24:56 2005 (serrano)                */
;*    -------------------------------------------------------------    */
;*    6.5. Numbers (page 18, r4) The `fixnum' functions                */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __r4_numbers_6_5_fixnum
   
   (import  __error)
   
   (use     __type
	    __bigloo
	    __tvector
	    __r4_numbers_6_5_flonum
	    __r4_booleans_6_1
	    __r4_vectors_6_8
	    __r4_strings_6_7
	    __r4_characters_6_6
	    __r4_symbols_6_4
	    __r4_pairs_and_lists_6_3
	    
	    __evenv)

   (extern  (macro c-fixnum?::bool (::obj) "INTEGERP")
	    (macro c-elong?::bool (::obj) "ELONGP")
	    (macro c-llong?::bool (::obj) "LLONGP")
	    (infix macro c-=fx::bool (::long ::long) "==")
	    (infix macro c-=elong::bool (::elong ::elong) "==")
	    (infix macro c-=llong::bool (::llong ::llong) "==")
	    (infix macro c-<fx::bool (::long ::long) "<")
	    (infix macro c-<elong::bool (::elong ::elong) "<")
	    (infix macro c-<llong::bool (::llong ::llong) "<")
	    (infix macro c-<=fx::bool (::long ::long) "<=")
	    (infix macro c-<=elong::bool (::elong ::elong) "<=")
	    (infix macro c-<=llong::bool (::llong ::llong) "<=")
	    (infix macro c->fx::bool (::long ::long) ">")
	    (infix macro c->elong::bool (::elong ::elong) ">")
	    (infix macro c->llong::bool (::llong ::llong) ">")
	    (infix macro c->=fx::bool (::long ::long) ">=")
	    (infix macro c->=elong::bool (::elong ::elong) ">=")
	    (infix macro c->=llong::bool (::llong ::llong) ">=")
	    (macro c-even?::bool (::long) "EVENP_FX")
	    (macro c-odd?::bool (::long) "ODDP_FX")
	    (infix macro c-+fx::long (::long ::long) "+")
	    (infix macro c-+elong::elong (::elong ::elong) "+")
	    (infix macro c-+llong::llong (::llong ::llong) "+")
	    (infix macro c--fx::long (::long ::long) "-")
	    (infix macro c--elong::long (::elong ::elong) "-")
	    (infix macro c--llong::llong (::llong ::llong) "-")
	    (infix macro c-*fx::long (::long ::long) "*")
	    (infix macro c-*elong::elong (::elong ::elong) "*")
	    (infix macro c-*llong::llong (::llong ::llong) "*")
	    (infix macro c-/fx::long (::long ::long) "/")
	    (infix macro c-/elong::elong (::elong ::elong) "/")
	    (infix macro c-/llong::llong (::llong ::llong) "/")
	    (macro c-negfx::long (::long) "NEG")
	    (macro c-negelong::elong (::elong) "NEG")
	    (macro c-negllong::llong (::llong) "NEG")
	    (infix macro c-quotientfx::long (::long ::long) "/")
	    (infix macro c-quotientelong::elong (::elong ::elong) "/")
	    (infix macro c-quotientllong::llong (::llong ::llong) "/")
	    (infix macro c-remainderfx::long (::long ::long) "%")
	    (infix macro c-remainderelong::elong (::elong ::elong) "%")
	    (infix macro c-remainderllong::llong (::llong ::llong) "%")
	    (macro strtol::long (::string ::long ::long) "strtol")
	    (macro strtoel::elong (::string ::long ::long) "strtol")
	    (macro strtoll::llong (::string ::long ::long) "BGL_STRTOLL")
	    (c-int->string::bstring  (::long ::long) "integer_to_string")
	    (c-elong->string::bstring  (::elong ::long) "integer_to_string")
	    (c-llong->string::bstring  (::llong ::long) "llong_to_string")
	    (macro $rand::int () "rand")
	    (macro $seed-rand::void (::int) "srand"))
   
   (java    (class foreign
	       (method static c-fixnum?::bool (::obj)
		       "INTEGERP")
	       (method static c-elong?::bool (::obj)
		       "ELONGP")
	       (method static c-llong?::bool (::obj)
		       "LLONGP")
	       (method static c-=fx::bool (::long ::long)
		       "EQ_FX")
	       (method static c-=elong::bool (::elong ::elong)
		       "EQ_ELONG")
	       (method static c-=llong::bool (::llong ::llong)
		       "EQ_LLONG")
	       (method static c-=fx::bool (::long ::long)
		       "EQ_FX")
	       (method static c-=elong::bool (::elong ::elong)
		       "EQ_ELONG")
	       (method static c-=llong::bool (::llong ::llong)
		       "EQ_LLONG")	       
	       (method static c-<fx::bool (::long ::long)
		       "LT_FX")
	       (method static c-<elong::bool (::elong ::elong)
		       "LT_ELONG")
	       (method static c-<llong::bool (::llong ::llong)
		       "LT_LLONG")
	       (method static c-<=fx::bool (::long ::long)
		       "LE_FX")
	       (method static c-<=elong::bool (::elong ::elong)
		       "LE_ELONG")
	       (method static c-<=llong::bool (::llong ::llong)
		       "LE_LLONG")
	       (method static c->fx::bool (::long ::long)
		       "GT_FX")
	       (method static c->elong::bool (::elong ::elong)
		       "GT_ELONG")
	       (method static c->llong::bool (::llong ::llong)
		       "GT_LLONG")
	       (method static c->=fx::bool (::long ::long)
		       "GE_FX")
	       (method static c->=elong::bool (::elong ::elong)
		       "GE_ELONG")
	       (method static c->=llong::bool (::llong ::llong)
		       "GE_LLONG")
	       (method static c-even?::bool (::long)
		       "EVENP_FX")
	       (method static c-odd?::bool (::long)
		       "ODDP_FX")
	       (method static c-+fx::long (::long ::long)
		       "PLUS_FX")
	       (method static c-+elong::elong (::elong ::elong)
		       "PLUS_ELONG")
	       (method static c-+llong::llong (::llong ::llong)
		       "PLUS_LLONG")
	       (method static c--fx::long (::long ::long)
		       "MINUS_FX")
	       (method static c--elong::elong (::elong ::elong)
		       "MINUS_ELONG")
	       (method static c--llong::llong (::llong ::llong)
		       "MINUS_LLONG")
	       (method static c-*fx::long (::long ::long)
		       "MUL_FX")
	       (method static c-*elong::elong (::elong ::elong)
		       "MUL_ELONG")
	       (method static c-*llong::llong (::llong ::llong)
		       "MUL_LLONG")
	       (method static c-/fx::long (::long ::long)
		       "DIV_FX")
	       (method static c-/elong::elong (::elong ::elong)
		       "DIV_ELONG")
	       (method static c-/llong::llong (::llong ::llong)
		       "DIV_LLONG")
	       (method static c-negfx::long (::long)
		       "NEG_FX")
	       (method static c-negelong::elong (::elong)
		       "NEG_ELONG")
	       (method static c-negllong::llong (::llong)
		       "NEG_LLONG")
	       (method static c-quotientfx::long (::long ::long)
		       "QUOTIENT_FX")
	       (method static c-quotientelong::elong (::elong ::elong)
		       "QUOTIENT_ELONG")
	       (method static c-quotientllong::llong (::llong ::llong)
		       "QUOTIENT_LLONG")
	       (method static c-remainderfx::long (::long ::long)
		       "REMAINDER_FX")
	       (method static c-remainderelong::elong (::elong ::elong)
		       "REMAINDER_ELONG")
	       (method static c-remainderllong::llong (::llong ::llong)
		       "REMAINDER_LLONG")
	       (method static strtol::long (::string ::long ::long)
		       "strtol")
	       (method static strtoel::elong (::string ::long ::long)
		       "strtoll")
	       (method static strtoll::llong (::string ::long ::long)
		       "strtoll")
	       (method static c-int->string::bstring (::long ::long)
		       "integer_to_string")
	       (method static c-elong->string::bstring (::elong ::long)
		       "elong_to_string")
	       (method static c-llong->string::bstring (::llong ::long)
		       "llong_to_string")
	       (method static $rand::int ()
		       "rand")
	       (method static $seed-rand::void (::int)
		       "srand")))
   
   (export  (inline integer?::bool ::obj)
	    (inline fixnum?::bool ::obj)
	    (inline elong?::bool ::obj)
	    (inline llong?::bool ::obj)
	    (inline make-elong::belong ::long)
	    (inline make-llong::bllong ::long)
	    (inline =fx::bool ::long ::long)
	    (inline =elong::bool ::belong ::belong)
	    (inline =llong::bool ::bllong ::bllong)
	    (inline >fx::bool ::long ::long)
	    (inline >elong::bool ::elong ::elong)
	    (inline >llong::bool ::llong ::llong)
	    (inline >=fx::bool ::long ::long)
	    (inline >=elong::bool ::elong ::elong)
	    (inline >=llong::bool ::llong ::llong)
	    (inline <fx::bool ::long ::long)
	    (inline <elong::bool ::elong ::elong)
	    (inline <llong::bool ::llong ::llong)
	    (inline <=fx::bool ::long ::long)
	    (inline <=elong::bool ::elong ::elong)
	    (inline <=llong::bool ::llong ::llong)
	    (inline zerofx?::bool ::long)
	    (inline zeroelong?::bool ::elong)
	    (inline zerollong?::bool ::llong)
	    (inline positivefx?::bool ::long)
	    (inline positiveelong?::bool ::elong)
	    (inline positivellong?::bool ::llong)
	    (inline negativefx?::bool ::long)
	    (inline negativeelong?::bool ::elong)
	    (inline negativellong?::bool ::llong)
	    (inline odd?::bool ::long)
	    (inline oddelong?::bool ::elong)
	    (inline oddllong?::bool ::llong)
	    (inline even?::bool ::long)
	    (inline evenelong?::bool ::elong)
	    (inline evenllong?::bool ::llong)
	    (maxfx::long ::long . pair)
	    (minfx::long ::long . pair)
	    (inline +fx::long ::long ::long)
	    (inline +elong::elong ::elong ::elong)
	    (inline +llong::llong ::llong ::llong)
	    (inline -fx::long ::long ::long)
	    (inline -elong::elong ::elong ::elong)
	    (inline -llong::llong ::llong ::llong)
	    (inline *fx::long ::long ::long)
	    (inline *elong::elong ::elong ::elong)
	    (inline *llong::llong ::llong ::llong)
	    (inline /fx::long ::long ::long)
	    (inline /elong::elong ::elong ::elong)
	    (inline /llong::llong ::llong ::llong)
	    (inline negfx::long ::long)
	    (inline negelong::elong ::elong)
	    (inline negllong::llong ::llong)
	    (inline absfx::long ::long)
	    (inline abselong::elong ::elong)
	    (inline absllong::llong ::llong)
	    (inline remainder::long ::long ::long)
	    (inline remainderelong::elong ::elong ::elong)
	    (inline remainderllong::llong ::llong ::llong)
	    (inline quotient::long ::long ::long)
	    (inline quotientelong::elong ::elong ::elong)
	    (inline quotientllong::llong ::llong ::llong)
	    (modulo::long ::long ::long)
	    (gcd::long . pair)
	    (lcm::long . pair)
	    (integer->string::bstring ::long . pair)
	    (string->integer::long ::bstring . pair)
	    (elong->string::bstring ::belong . pair)
	    (string->elong::belong ::bstring . pair)
	    (llong->string::bstring ::bllong . pair)
	    (string->llong::bllong ::bstring . pair)
	    (inline random::int ::int)
	    (seed-random! ::int))
   
   (pragma  (fixnum? (predicate-of bint) no-cfa-top nesting)
	    (c-fixnum? side-effect-free (predicate-of bint) no-cfa-top nesting args-safe (effect))
	    (c-elong? side-effect-free (predicate-of belong) no-cfa-top nesting (effect))
	    (c-llong? side-effect-free (predicate-of bllong) no-cfa-top nesting (effect))
	    (integer? side-effect-free no-cfa-top nesting (effect))
	    (=fx side-effect-free no-cfa-top nesting (effect))
	    (=elong side-effect-free no-cfa-top nesting (effect))
	    (=llong side-effect-free no-cfa-top nesting (effect))
	    (=fx side-effect-free no-cfa-top nesting (effect))
	    (=elong side-effect-free no-cfa-top nesting (effect))
	    (=llong side-effect-free no-cfa-top nesting (effect))
	    (>fx side-effect-free no-cfa-top nesting (effect))
	    (>elong side-effect-free no-cfa-top nesting (effect))
	    (>llong side-effect-free no-cfa-top nesting (effect))
	    (>=fx side-effect-free no-cfa-top nesting (effect))
	    (>=elong side-effect-free no-cfa-top nesting (effect))
	    (>=llong side-effect-free no-cfa-top nesting (effect))
	    (<fx side-effect-free no-cfa-top nesting (effect))
	    (<elong side-effect-free no-cfa-top nesting (effect))
	    (<llong side-effect-free no-cfa-top nesting (effect))
	    (<=fx side-effect-free no-cfa-top nesting (effect))
	    (<=elong side-effect-free no-cfa-top nesting (effect))
	    (<=llong side-effect-free no-cfa-top nesting (effect))
	    (odd? side-effect-free no-cfa-top nesting (effect))
	    (even? side-effect-free no-cfa-top nesting (effect))
	    (+fx side-effect-free no-cfa-top nesting (effect))
	    (+elong side-effect-free no-cfa-top nesting (effect))
	    (+llong side-effect-free no-cfa-top nesting (effect))
	    (-fx side-effect-free no-cfa-top nesting (effect))
	    (-elong side-effect-free no-cfa-top nesting (effect))
	    (-llong side-effect-free no-cfa-top nesting (effect))
	    (*fx side-effect-free no-cfa-top nesting (effect))
	    (*elong side-effect-free no-cfa-top nesting (effect))
	    (*llong side-effect-free no-cfa-top nesting (effect))
	    (/fx side-effect-free no-cfa-top nesting (effect))
	    (/elong side-effect-free no-cfa-top nesting (effect))
	    (/llong side-effect-free no-cfa-top nesting (effect))
	    (remainder side-effect-free no-cfa-top nesting (effect))
	    (remainderelong side-effect-free no-cfa-top nesting (effect))
	    (remainderllong side-effect-free no-cfa-top nesting (effect))
	    (integer->string side-effect-free no-cfa-top nesting (effect))
	    (string->integer side-effect-free no-cfa-top nesting (effect))
	    (modulo side-effect-free no-cfa-top nesting (effect))
	    (gcd side-effect-free no-cfa-top nesting (effect))
	    (lcm side-effect-free no-cfa-top nesting (effect))
	    (quotient side-effect-free no-cfa-top nesting (effect))
	    (positivefx? side-effect-free no-cfa-top nesting (effect))
	    (positiveelong? side-effect-free no-cfa-top nesting (effect))
	    (positivellong? side-effect-free no-cfa-top nesting (effect))
	    (negativefx? side-effect-free no-cfa-top nesting (effect))
	    (negativeelong? side-effect-free no-cfa-top nesting (effect))
	    (negativellong? side-effect-free no-cfa-top nesting (effect))
	    (zerofx? side-effect-free no-cfa-top nesting (effect))
	    (zeroelong? side-effect-free no-cfa-top nesting (effect))
	    (zerollong? side-effect-free no-cfa-top nesting (effect))
	    (negfx side-effect-free no-cfa-top nesting (effect))
	    (negelong side-effect-free no-cfa-top nesting (effect))
	    (negllong side-effect-free no-cfa-top nesting (effect))
	    (c-=fx side-effect-free no-cfa-top nesting args-safe (effect))
	    (c-=elong side-effect-free no-cfa-top nesting args-safe (effect))
	    (c-=llong side-effect-free no-cfa-top nesting args-safe (effect))
	    (c->fx side-effect-free no-cfa-top nesting args-safe (effect))
	    (c->elong side-effect-free no-cfa-top nesting args-safe (effect))
	    (c->llong side-effect-free no-cfa-top nesting args-safe (effect))
	    (c->=fx side-effect-free no-cfa-top nesting args-safe (effect))
	    (c->=elong side-effect-free no-cfa-top nesting args-safe (effect))
	    (c->=llong side-effect-free no-cfa-top nesting args-safe (effect))
	    (c-<fx side-effect-free no-cfa-top nesting args-safe (effect))
	    (c-<elong side-effect-free no-cfa-top nesting args-safe (effect))
	    (c-<llong side-effect-free no-cfa-top nesting args-safe (effect))
	    (c-<=fx side-effect-free no-cfa-top nesting args-safe (effect))
	    (c-<=elong side-effect-free no-cfa-top nesting args-safe (effect))
	    (c-<=llong side-effect-free no-cfa-top nesting args-safe (effect))
	    (c-odd? side-effect-free no-cfa-top nesting args-safe (effect))
	    (c-even? side-effect-free no-cfa-top nesting args-safe (effect))
	    (c-+fx side-effect-free no-cfa-top nesting args-safe (effect))
	    (c-+elong side-effect-free no-cfa-top nesting args-safe (effect))
	    (c-+llong side-effect-free no-cfa-top nesting args-safe (effect))
	    (c--fx side-effect-free no-cfa-top nesting args-safe (effect))
	    (c--elong side-effect-free no-cfa-top nesting args-safe (effect))
	    (c--llong side-effect-free no-cfa-top nesting args-safe (effect))
	    (c-*fx side-effect-free no-cfa-top nesting args-safe (effect))
	    (c-*elong side-effect-free no-cfa-top nesting args-safe (effect))
	    (c-*llong side-effect-free no-cfa-top nesting args-safe (effect))
	    (c-/fx side-effect-free no-cfa-top nesting args-safe (effect))
	    (c-negfx side-effect-free no-cfa-top nesting args-safe (effect))
	    (c-negelong side-effect-free no-cfa-top nesting args-safe (effect))
	    (c-negllong side-effect-free no-cfa-top nesting args-safe (effect))
	    (random side-effect-free no-cfa-top nesting (effect))))

;*---------------------------------------------------------------------*/
;*    integer? ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (integer? obj)
   (if (c-fixnum? obj)
       #t
       (if (c-flonum? obj)
	   (=fl obj (roundfl obj))
	   #f)))

;*---------------------------------------------------------------------*/
;*    fixnum? ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (fixnum? obj)
   (c-fixnum? obj))

;*---------------------------------------------------------------------*/
;*    elong? ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (elong? obj)
   (c-elong? obj))

;*---------------------------------------------------------------------*/
;*    llong? ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (llong? obj)
   (c-llong? obj))

;*---------------------------------------------------------------------*/
;*    make-elong ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (make-elong long)
   (long->belong long))

;*---------------------------------------------------------------------*/
;*    make-llong ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (make-llong long)
   (long->bllong long))

;*---------------------------------------------------------------------*/
;*    =fx ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (=fx n1 n2)
   (c-=fx n1 n2))

;*---------------------------------------------------------------------*/
;*    =elong ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (=elong n1 n2)
   (c-=elong (belong->elong n1) (belong->elong n2)))

;*---------------------------------------------------------------------*/
;*    =llong ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (=llong n1 n2)
   (c-=llong (bllong->llong n1) (bllong->llong n2)))

;*---------------------------------------------------------------------*/
;*    <fx ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (<fx n1 n2)
   (c-<fx n1 n2))

;*---------------------------------------------------------------------*/
;*    <elong ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (<elong n1 n2)
   (c-<elong n1 n2))

;*---------------------------------------------------------------------*/
;*    <llong ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (<llong n1 n2)
   (c-<llong n1 n2))

;*---------------------------------------------------------------------*/
;*    >fx ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (>fx n1 n2)
   (c->fx n1 n2))

;*---------------------------------------------------------------------*/
;*    >elong ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (>elong n1 n2)
   (c->elong n1 n2))

;*---------------------------------------------------------------------*/
;*    >llong ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (>llong n1 n2)
   (c->llong n1 n2))

;*---------------------------------------------------------------------*/
;*    <=fx ...                                                         */
;*---------------------------------------------------------------------*/
(define-inline (<=fx n1 n2)
   (c-<=fx n1 n2))

;*---------------------------------------------------------------------*/
;*    <=elong ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (<=elong n1 n2)
   (c-<=elong n1 n2))

;*---------------------------------------------------------------------*/
;*    <=llong ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (<=llong n1 n2)
   (c-<=llong n1 n2))

;*---------------------------------------------------------------------*/
;*    >=fx ...                                                         */
;*---------------------------------------------------------------------*/
(define-inline (>=fx n1 n2)
   (c->=fx n1 n2))

;*---------------------------------------------------------------------*/
;*    >=elong ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (>=elong n1 n2)
   (c->=elong n1 n2))

;*---------------------------------------------------------------------*/
;*    >=llong ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (>=llong n1 n2)
   (c->=llong n1 n2))

;*---------------------------------------------------------------------*/
;*    zerofx? ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (zerofx? n)
   (=fx n 0))

;*---------------------------------------------------------------------*/
;*    zeroelong? ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (zeroelong? n)
   (=elong n #e0))

;*---------------------------------------------------------------------*/
;*    zerollong? ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (zerollong? n)
   (=llong n #l0))

;*---------------------------------------------------------------------*/
;*    positivefx?  ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (positivefx? n)
   (>fx n 0))

;*---------------------------------------------------------------------*/
;*    positiveelong?  ...                                              */
;*---------------------------------------------------------------------*/
(define-inline (positiveelong? n)
   (>elong n #e0))

;*---------------------------------------------------------------------*/
;*    positivellong?  ...                                              */
;*---------------------------------------------------------------------*/
(define-inline (positivellong? n)
   (>llong n #l0))

;*---------------------------------------------------------------------*/
;*    negativefx? ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (negativefx? n)
   (<fx n 0))

;*---------------------------------------------------------------------*/
;*    negativeelong? ...                                               */
;*---------------------------------------------------------------------*/
(define-inline (negativeelong? n)
   (<elong n #e0))

;*---------------------------------------------------------------------*/
;*    negativellong? ...                                               */
;*---------------------------------------------------------------------*/
(define-inline (negativellong? n)
   (<llong n #l0))

;*---------------------------------------------------------------------*/
;*    odd? ...                                                         */
;*---------------------------------------------------------------------*/
(define-inline (odd? x)
   (c-odd? x))

;*---------------------------------------------------------------------*/
;*    oddelong? ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (oddelong? x)
   (zeroelong? (remainderelong x #e2)))

;*---------------------------------------------------------------------*/
;*    oddllong? ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (oddllong? x)
   (zerollong? (remainderllong x #l2)))

;*---------------------------------------------------------------------*/
;*    even? ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (even? x)
   (c-even? x))

;*---------------------------------------------------------------------*/
;*    evenelong? ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (evenelong? x)
   (if (oddelong? x) #f #t))

;*---------------------------------------------------------------------*/
;*    evenllong? ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (evenllong? x)
   (if (oddllong? x) #f #t))

;*---------------------------------------------------------------------*/
;*    maxfx ...                                                        */
;*---------------------------------------------------------------------*/
(define (maxfx n1 . nn)
   (let loop ((max n1)
	      (nn  nn))
      (if (null? nn)
	  max
	  (if (>fx (car nn) max)
	      (loop (car nn) (cdr nn))
	      (loop max (cdr nn))))))

;*---------------------------------------------------------------------*/
;*    minfx ...                                                        */
;*---------------------------------------------------------------------*/
(define (minfx n1 . nn)
   (let loop ((min n1)
	      (nn  nn))
      (if (null? nn)
	  min
	  (if (<fx (car nn) min)
	      (loop (car nn) (cdr nn))
	      (loop min (cdr nn))))))

;*---------------------------------------------------------------------*/
;*    +fx ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (+fx z1 z2)
   (c-+fx z1 z2))

;*---------------------------------------------------------------------*/
;*    +elong ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (+elong z1 z2)
   (c-+elong z1 z2))

;*---------------------------------------------------------------------*/
;*    +llong ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (+llong z1 z2)
   (c-+llong z1 z2))

;*---------------------------------------------------------------------*/
;*    -fx ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (-fx z1 z2)
   (c--fx z1 z2))

;*---------------------------------------------------------------------*/
;*    -elong ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (-elong z1 z2)
   (c--elong z1 z2))

;*---------------------------------------------------------------------*/
;*    -llong ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (-llong z1 z2)
   (c--llong z1 z2))

;*---------------------------------------------------------------------*/
;*    *fx ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (*fx z1 z2)
   (c-*fx z1 z2))

;*---------------------------------------------------------------------*/
;*    *elong ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (*elong z1 z2)
   (c-*elong z1 z2))

;*---------------------------------------------------------------------*/
;*    *llong ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (*llong z1 z2)
   (c-*llong z1 z2))

;*---------------------------------------------------------------------*/
;*    /fx ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (/fx z1 z2)
   (c-/fx z1 z2))

;*---------------------------------------------------------------------*/
;*    /elong ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (/elong z1 z2)
   (c-/elong z1 z2))

;*---------------------------------------------------------------------*/
;*    /llong ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (/llong z1 z2)
   (c-/llong z1 z2))

;*---------------------------------------------------------------------*/
;*    negfx ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (negfx n1)
   (c-negfx n1))

;*---------------------------------------------------------------------*/
;*    negelong ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (negelong n1)
   (c-negelong n1))

;*---------------------------------------------------------------------*/
;*    negllong ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (negllong n1)
   (c-negllong n1))

;*---------------------------------------------------------------------*/
;*    absfx ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (absfx n)
   (if (<fx n 0)
       (negfx n)
       n))

;*---------------------------------------------------------------------*/
;*    abselong ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (abselong n)
   (if (<elong n #e0)
       (negelong n)
       n))

;*---------------------------------------------------------------------*/
;*    absllong ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (absllong n)
   (if (<llong n #l0)
       (negllong n)
       n))

;*---------------------------------------------------------------------*/
;*    quotient ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (quotient n1 n2)
   (c-quotientfx n1 n2))

;*---------------------------------------------------------------------*/
;*    quotientelong ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (quotientelong n1 n2)
   (c-quotientelong n1 n2))

;*---------------------------------------------------------------------*/
;*    quotientllong ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (quotientllong n1 n2)
   (c-quotientllong n1 n2))

;*---------------------------------------------------------------------*/
;*    remainder ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (remainder n1 n2)
   (c-remainderfx n1 n2))

;*---------------------------------------------------------------------*/
;*    remainderelong ...                                               */
;*---------------------------------------------------------------------*/
(define-inline (remainderelong n1 n2)
   (c-remainderelong n1 n2))

;*---------------------------------------------------------------------*/
;*    remainderllong ...                                               */
;*---------------------------------------------------------------------*/
(define-inline (remainderllong n1 n2)
   (c-remainderllong n1 n2))

;*---------------------------------------------------------------------*/
;*    modulo ...                                                       */
;*---------------------------------------------------------------------*/
(define (modulo x y)
   (let ((r (remainder x y)))
      (if (zerofx? r)
	  r
	  (if (positivefx? y)
	      (if (positivefx? r) r (+fx y r))
	      (if (negativefx? r) r (+fx y r))))))

;*---------------------------------------------------------------------*/
;*    gcd ...                                                          */
;*---------------------------------------------------------------------*/
(define (gcd . x)
    (define (gcd2 m n)
       (if (zerofx? n)
	   m
	   (let ((r (remainder m n)))
	      (if (=fx r 0)
		  n
		  (gcd2 n r)))))
    (case (length x)
       ((0) 0)
       ((1) (absfx (car x)))
       (else
	(let loop ((result (gcd2 (absfx (car x)) (absfx (cadr x))))
			(left (cddr x)))
		(if (pair? left)
		    (loop (gcd2 result (absfx (car left))) (cdr left))
		    result)))))

;*---------------------------------------------------------------------*/
;*    lcm ...                                                          */
;*---------------------------------------------------------------------*/
(define (lcm . x)
   (define (lcm2 m n)
      (let ((m (absfx m)) (n (absfx n)))
	 (cond ((=fx m n) m)
	       ((=fx (remainder m n) 0) m)
	       ((=fx (remainder n m) 0) n)
	       (else (*fx (/fx m (gcd m n)) n)))))
   (case (length x)
      ((0) 1)
      ((1) (absfx (car x)))
      (else (let loop ((result (lcm2 (car x) (cadr x))) (left (cddr x)))
	       (if (pair? left)
		   (loop (lcm2 result (car left)) (cdr left))
		   result)))))

;*---------------------------------------------------------------------*/
;*    integer->string ...                                              */
;*---------------------------------------------------------------------*/
(define (integer->string x . radix)
   (let ((r (if (null? radix) 10 (car radix))))
      (case r
	 ((2 8 10 16)
	  (c-int->string x r))
	 (else
	  (error "integer->string" "Illegal radix" r)))))

;*---------------------------------------------------------------------*/
;*    elong->string ...                                                */
;*---------------------------------------------------------------------*/
(define (elong->string x . radix)
   (let ((r (if (null? radix) 10 (car radix))))
      (case r
	 ((2 8 10 16)
	  (c-elong->string (belong->elong x) r))
	 (else
	  (error "elong->string" "Illegal radix" r)))))

;*---------------------------------------------------------------------*/
;*    llong->string ...                                                */
;*---------------------------------------------------------------------*/
(define (llong->string x . radix)
   (let ((r (if (null? radix) 10 (car radix))))
      (case r
	 ((2 8 10 16)
	  (c-llong->string (bllong->llong x) r))
	 (else
	  (error "llong->string" "Illegal radix" r)))))

;*---------------------------------------------------------------------*/
;*    string->integer ...                                              */
;*---------------------------------------------------------------------*/
(define (string->integer string . radix)
   (let ((r (if (null? radix) 10 (car radix))))
      (case r
	 ((2 8 10 16)
	  (strtol string 0 r))
	 (else
	  (error "string->integer" "Illegal radix" r)))))

;*---------------------------------------------------------------------*/
;*    string->elong ...                                                */
;*---------------------------------------------------------------------*/
(define (string->elong string . radix)
   (let ((r (if (null? radix) 10 (car radix))))
      (case r
	 ((2 8 10 16)
	  (strtoel string 0 r))
	 (else
	  (error "string->elong" "Illegal radix" r)))))

;*---------------------------------------------------------------------*/
;*    string->llong ...                                                */
;*---------------------------------------------------------------------*/
(define (string->llong string . radix)
   (let ((r (if (null? radix) 10 (car radix))))
      (case r
	 ((2 8 10 16)
	  (strtoll string 0 r))
	 (else
	  (error "string->llong" "Illegal radix" r)))))

;*---------------------------------------------------------------------*/
;*    random ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (random max::int)
   (modulo ($rand) max))

;*---------------------------------------------------------------------*/
;*    seed-random! ...                                                 */
;*---------------------------------------------------------------------*/
(define (seed-random! seed)
   ($seed-rand seed)
   seed)
