/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime/Jlib/socket.java             */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Tue Dec  5 10:53:03 2000                          */
/*    Last change :  Fri Mar 18 11:34:04 2005 (serrano)                */
/*    Copyright   :  2000-05 Manuel Serrano                            */
/*    -------------------------------------------------------------    */
/*    The Socket implementation for the JVM back-end.                  */
/*=====================================================================*/
package bigloo;

import java.io.*;
import java.net.*;

/*---------------------------------------------------------------------*/
/*    SOCKET ...                                                       */
/*---------------------------------------------------------------------*/
public abstract class socket extends obj {
   /*--- public fields ------------------------------------------------*/
   public obj input;
   public obj output;

   /*--- protected fields ---------------------------------------------*/
   protected boolean down= false;
   protected boolean closed= false;

   /*--- constructors -------------------------------------------------*/
   protected socket() {
      input= bigloo.foreign.BFALSE;
      output= bigloo.foreign.BFALSE;
   }

   /*--- protected methods --------------------------------------------*/
   protected void socket_error( String s1, String s2, Object o ) {
      foreign.fail( s1, s2, o );
   }

   protected void set_socket_io_ports( Socket client_socket, boolean blocking )
      throws IOException {
      input= new input_socket_port( client_socket.getInputStream(), blocking );
      // CARE must be buffered !?
      output= new output_port( client_socket.getOutputStream() );
   }

   /*--- public methods -----------------------------------------------*/
   public boolean DOWNP() {
      return down;
   }

   public Object close()
      throws IOException {
      if (!closed) {
	 closed= true;
	 if (input instanceof input_port)
	    ((input_port)input).close();
	 if (output instanceof output_port)
	    ((output_port)output).close();
      }
      return bigloo.foreign.BUNSPEC;
   }

   /*--- public abstract methods --------------------------------------*/
   public abstract Object HOSTNAME();
   public abstract Object HOSTIP();
   public abstract Object shutdown( boolean  close_socket ) throws IOException;
   public abstract int PORT();
   public abstract byte[] local_addr();
}
