;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Ieee/number.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Mar 24 09:59:43 1995                          */
;*    Last change :  Wed Jan 26 12:06:26 2005 (serrano)                */
;*    -------------------------------------------------------------    */
;*    6.5. Numbers (page 18, r4)                                       */
;*    -------------------------------------------------------------    */
;*    Source documentation:                                            */
;*       @path ../../manuals/body.texi@                                */
;*       @node Numbers@                                                */
;*=====================================================================*/
 
;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __r4_numbers_6_5
   
   (import  __error)

   (use     __type
	    __bigloo
	    __tvector
	    __r4_equivalence_6_2
	    __r4_numbers_6_5_fixnum
	    __r4_booleans_6_1
	    __r4_characters_6_6
	    __r4_pairs_and_lists_6_3
	    __r4_vectors_6_8
	    __r4_numbers_6_5_flonum
	    __r4_symbols_6_4
	    __r4_strings_6_7

	    __evenv)
   
   (extern  (macro c-fixnum->flonum::double (::long)   "(double)")
	    (macro c-flonum->fixnum::long   (::double) "(long)")
	    
	    (macro c-elong->fixnum::long (::elong)     "(long)")
	    (macro c-fixnum->elong::elong (::long)     "(long)")
	    (macro c-llong->fixnum::long (::llong)     "(long)")
	    (macro c-fixnum->llong::llong (::long)     "(BGL_LONGLONG_T)")
	    
	    (macro c-elong->flonum::double  (::elong)  "(double)")
	    (macro c-flonum->elong::long    (::double) "(long)")
	    (macro c-llong->flonum::double  (::llong)  "(double)")
	    (macro c-flonum->llong::llong   (::double) "DOUBLE_TO_LLONG")
	    
	    (export exact->inexact "bgl_exact_to_inexact")
	    (export inexact->exact "bgl_inexact_to_exact"))
   
   (java    (class foreign
	       (method static c-fixnum->flonum::double (::long)
		       "FIXNUM_TO_FLONUM")
	       (method static c-flonum->fixnum::long   (::double)
		       "FLONUM_TO_FIXNUM")
	       
	       (method static c-elong->fixnum::long (::elong)
		       "ELONG_TO_LONG")
	       (method static c-fixnum->elong::elong (::long)
		       "LONG_TO_ELONG")
	       (method static c-llong->fixnum::long (::llong)
		       "LLONG_TO_LONG")
	       (method static c-fixnum->llong::llong (::long)
		       "LONG_TO_LLONG")
	       
	       (method static c-elong->flonum::double (::elong)
		       "ELONG_TO_FLONUM")
	       (method static c-flonum->elong::elong   (::double)
		       "FLONUM_TO_ELONG")
	       (method static c-llong->flonum::double (::llong)
		       "LLONG_TO_FLONUM")
	       (method static c-flonum->llong::llong   (::double)
		       "FLONUM_TO_LLONG")))
   
   (export  (inline number?::bool           obj)
	    (inline exact?::bool            z)
	    (inline inexact?::bool          z)
	    (complex?::bool                 x)
	    (rational?::bool                x)
	    (inline flonum->fixnum::long    ::double)
	    (inline fixnum->flonum::double  ::long)
	    (inline fixnum->elong::elong    ::long)
	    (inline elong->fixnum::long     ::elong)
	    (inline fixnum->llong::llong    ::long)
	    (inline llong->fixnum::long     ::llong)
	    (inline flonum->elong::elong    ::double)
	    (inline elong->flonum::double   ::elong)
	    (inline flonum->llong::llong    ::double)
	    (inline llong->flonum::double   ::llong)
	    (2=::bool                       x y)
	    (=::bool                        x y . z)
	    (2<::bool                       x y) 
	    (<::bool                        x y . z)
	    (2>::bool                       x y)
	    (>::bool                        x y . z)
	    (2<=::bool                      x y)
	    (<=::bool                       x y . z)
	    (2>=::bool                      x y)
	    (>=::bool                       x y . z)
	    (zero?::bool                    x)
	    (positive?::bool                x)
	    (negative?::bool                x)
	    (max                            x . y)
	    (min                            x . y)
	    (2+                             x y)
	    (+                              . x)
	    (2*                             x y)
	    (*                              . x)
	    (2-                             x y)
	    (-                              x . y)
	    (2/                             x y)
	    (/                              x . y)
	    (abs                            x)
	    (floor                          x)
	    (ceiling                        x)
	    (truncate                       x)
	    (round                          x)
	    (exp::double                    x) 
	    (log::double                    x) 
	    (sin::double                    x) 
	    (cos::double                    x) 
	    (tan::double                    x) 
	    (asin::double                   x) 
	    (acos::double                   x) 
	    (atan::double                   x . y) 
	    (sqrt::double                   x) 
	    (expt                           x y)
	    (inline exact->inexact          z)
	    (inline inexact->exact          z)
	    (number->string::string         x . radix)
	    (string->number                 x . radix))

   (pragma  (c-fixnum->flonum side-effect-free args-safe (effect))
	    (c-flonum->fixnum side-effect-free args-safe (effect))
	    (c-elong->fixnum side-effect-free args-safe (effect))
	    (c-fixnum->elong side-effect-free args-safe (effect))
	    (c-llong->fixnum side-effect-free args-safe (effect))
	    (c-fixnum->llong side-effect-free args-safe (effect))
	    (c-elong->flonum side-effect-free args-safe (effect))
	    (c-flonum->elong side-effect-free args-safe (effect))
	    (c-llong->flonum side-effect-free args-safe (effect))
	    (c-flonum->llong side-effect-free args-safe (effect))
	    (2= side-effect-free (effect))
	    (= side-effect-free (effect))
	    (2< side-effect-free (effect))
	    (< side-effect-free (effect))
	    (2> side-effect-free (effect))
	    (> side-effect-free (effect))
	    (2<= side-effect-free (effect))
	    (<= side-effect-free (effect))
	    (2>= side-effect-free (effect))
	    (>= side-effect-free (effect))
	    (zero? side-effect-free (effect))
	    (positive? side-effect-free (effect))
	    (negative? side-effect-free (effect))
	    (max side-effect-free (effect))
	    (min side-effect-free (effect))
	    (2+ side-effect-free (effect))
	    (+ side-effect-free (effect))
	    (2* side-effect-free (effect))
	    (* side-effect-free (effect))
	    (2/ side-effect-free (effect))
	    (/ side-effect-free (effect))
	    (2- side-effect-free (effect))
	    (- side-effect-free (effect))
	    (abs side-effect-free (effect))
	    (floor side-effect-free (effect))
	    (ceiling side-effect-free (effect))
	    (truncate side-effect-free (effect))
	    (round side-effect-free (effect))
	    (exp side-effect-free (effect))
	    (log side-effect-free (effect))
	    (sin side-effect-free (effect))
	    (cos side-effect-free (effect))
	    (tan side-effect-free (effect))
	    (asin side-effect-free (effect))
	    (acos side-effect-free (effect))
	    (atan side-effect-free (effect))
	    (sqrt side-effect-free (effect))
	    (expt side-effect-free (effect))
	    (exact->inexact side-effect-free args-safe (effect))
	    (inexact->exact side-effect-free args-safe (effect))
	    (number->string side-effect-free (effect))
	    (string->number side-effect-free (effect))))

;*---------------------------------------------------------------------*/
;*    number? ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (number? obj)
   (if (fixnum? obj)
       #t
       (if (flonum? obj)
	   #t
	   (if (elong? obj)
	       #t
	       (llong? obj)))))

;*---------------------------------------------------------------------*/
;*    exact? ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (exact? z)
   (if (fixnum? z)
       #t
       (if (elong? z)
	   #t
	   (llong? z))))

;*---------------------------------------------------------------------*/
;*    inexact? ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (inexact? z)
   (flonum? z))

;*---------------------------------------------------------------------*/
;*    complex? ...                                                     */
;*---------------------------------------------------------------------*/
(define (complex? x)
   (number? x))

;*---------------------------------------------------------------------*/
;*    rational? ...                                                    */
;*---------------------------------------------------------------------*/
(define (rational? x)
   (real? x))

;*---------------------------------------------------------------------*/
;*    flonum->fixnum ...                                               */
;*---------------------------------------------------------------------*/
(define-inline (flonum->fixnum x)
   (c-flonum->fixnum x))

;*---------------------------------------------------------------------*/
;*    fixnum->flonum ...                                               */
;*---------------------------------------------------------------------*/
(define-inline (fixnum->flonum x)
   (c-fixnum->flonum x))
		       
;*---------------------------------------------------------------------*/
;*    fixnum->elong ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (fixnum->elong x)
   (c-fixnum->elong x))

;*---------------------------------------------------------------------*/
;*    elong->fixnum ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (elong->fixnum x)
   (c-elong->fixnum x))
		       
;*---------------------------------------------------------------------*/
;*    fixnum->llong ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (fixnum->llong x)
   (c-fixnum->llong x))

;*---------------------------------------------------------------------*/
;*    llong->fixnum ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (llong->fixnum x)
   (c-llong->fixnum x))
		       
;*---------------------------------------------------------------------*/
;*    flonum->elong ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (flonum->elong x)
   (c-flonum->elong x))

;*---------------------------------------------------------------------*/
;*    elong->flonum ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (elong->flonum x)
   (c-elong->flonum x))
		       
;*---------------------------------------------------------------------*/
;*    flonum->llong ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (flonum->llong x)
   (c-flonum->llong x))

;*---------------------------------------------------------------------*/
;*    llong->flonum ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (llong->flonum x)
   (c-llong->flonum x))

;*---------------------------------------------------------------------*/
;*    2op :: ...                                                       */
;*---------------------------------------------------------------------*/
(define-macro (2op op x y)
   (let ((opfx (symbol-append op 'fx))
	 (opfl (symbol-append op 'fl))
	 (opelong (symbol-append op 'elong))
	 (opllong (symbol-append op 'llong)))
      `(cond
	  ((fixnum? ,x)
	   (cond
	      ((fixnum? ,y)
	       (,opfx ,x ,y))
	      ((flonum? ,y)
	       (,opfl (fixnum->flonum ,x) ,y))
	      ((elong? ,y)
	       (,opelong (fixnum->elong ,x) ,y))
	      ((llong? y)
	       (,opllong (fixnum->llong ,x) ,y))
	      (else
	       (error ,op "not a number" ,y))))
	  ((flonum? ,x)
	   (cond
	      ((flonum? ,y)
	       (,opfl ,x ,y))
	      ((fixnum? ,y)
	       (,opfl ,x (fixnum->flonum ,y)))
	      ((elong? y)
	       (,opfl ,x (elong->flonum ,y)))
	      ((llong? y)
	       (,opfl ,x (llong->flonum ,y)))
	      (else
	       (error ,op "not a number" ,y))))
	  ((elong? ,x)
	   (cond
	      ((fixnum? ,y)
	       (,opelong ,x (fixnum->elong ,y)))
	      ((flonum? ,y)
	       (,opfl (elong->flonum ,x) ,y))
	      ((elong? ,y)
	       (,opelong ,x ,y))
	      ((llong? ,y)
	       (,opllong (flonum->llong (elong->flonum ,x)) ,y))
	      (else
	       (error ,op "not a number" ,y))))
	  ((llong? ,x)
	   (cond
	      ((fixnum? ,y)
	       (,opllong ,x (fixnum->llong ,y)))
	      ((flonum? y)
	       (,opfl (llong->flonum ,x) ,y))
	      ((elong? ,y)
	       (,opllong ,x (flonum->llong (elong->flonum ,y))))
	      ((llong? ,y)
	       (,opllong ,x ,y))
	      (else
	       (error ,op "not a number" ,y))))
	  (else
	   (error ,op "not a number" ,x)))))

;*---------------------------------------------------------------------*/
;*    2= ...                                                           */
;*---------------------------------------------------------------------*/
(define (2= x y)
   (2op = x y))

;*---------------------------------------------------------------------*/
;*    = ...                                                            */
;*---------------------------------------------------------------------*/
(define (= x y . z)
   (define (=-list x z)
	    (cond
	       ((null? z) #t)
	       ((2= x (car z))
		(=-list x (cdr z)))
	       (else #f)))
   (and (2= x y)
	(=-list y z)))

;*---------------------------------------------------------------------*/
;*    2< ...                                                           */
;*---------------------------------------------------------------------*/
(define (2< x y)
   (2op < x y))

;*---------------------------------------------------------------------*/
;*    < ...                                                            */
;*---------------------------------------------------------------------*/
(define (< x y . z)
   (define (<-list x z)
	    (cond
	       ((null? z) #t)
	       ((2< x (car z))
		(<-list (car z) (cdr z)))
	       (else #f)))
   (and (2< x y)
	(<-list y z)))

   
;*---------------------------------------------------------------------*/
;*    2> ...                                                           */
;*---------------------------------------------------------------------*/
(define (2> x y)
   (2op > x y))

;*---------------------------------------------------------------------*/
;*    > ...                                                            */
;*---------------------------------------------------------------------*/
(define (> x y . z)
   (define (>-list x z)
	    (cond
	       ((null? z) #t)
	       ((2> x (car z))
		(>-list (car z) (cdr z)))
	       (else #f)))
   (and (2> x y)
	(>-list y z)))
 
;*---------------------------------------------------------------------*/
;*    2<= ...                                                          */
;*---------------------------------------------------------------------*/
(define (2<= x y)
   (2op <= x y))

;*---------------------------------------------------------------------*/
;*    <= ...                                                           */
;*---------------------------------------------------------------------*/
(define (<= x y . z)
   (define (<=-list x z)
      (cond
	 ((null? z) #t)
	 ((2<= x (car z))
	  (<=-list (car z) (cdr z)))
	 (else #f)))
   (and (2<= x y)
	(<=-list y z)))

;*---------------------------------------------------------------------*/
;*    2>= ...                                                          */
;*---------------------------------------------------------------------*/
(define (2>= x y)
   (2op >= x y))

;*---------------------------------------------------------------------*/
;*    >= ...                                                           */
;*---------------------------------------------------------------------*/
(define (>= x y . z)
   (define (>=-list x z)
	    (cond
	       ((null? z) #t)
	       ((2>= x (car z))
		(>=-list (car z) (cdr z)))
	       (else #f)))
   (and (2>= x y)
	(>=-list y z)))

;*---------------------------------------------------------------------*/
;*    zero? ...                                                        */
;*---------------------------------------------------------------------*/
(define (zero? x)
   (cond
      ((fixnum? x)
       (zerofx? x))
      ((flonum? x)
       (zerofl? x))
      ((elong? x)
       (=elong x #e0))
      ((llong? x)
       (=llong x #l0))
      (else
       (error "zero" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    positive? ...                                                    */
;*---------------------------------------------------------------------*/
(define (positive? x)
   (cond
      ((fixnum? x)
       (positivefx? x))
      ((flonum? x)
       (positivefl? x))
      ((elong? x)
       (>elong x #e0))
      ((llong? x)
       (>llong x #l0))
      (else
       (error "positive" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    negative? ...                                                    */
;*---------------------------------------------------------------------*/
(define (negative? x)
   (cond
      ((fixnum? x)
       (negativefx? x))
      ((flonum? x)
       (negativefl? x))
      ((elong? x)
       (<elong x #e0))
      ((llong? x)
       (<llong x #l0))
      (else
       (error "negative" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    max ...                                                          */
;*---------------------------------------------------------------------*/
(define (max x . y)
   (let loop ((x x)
	      (y y))
      (if (pair? y)
	  (loop (if (2> x (car y))
		    x
		    (car y))
		(cdr y))
	  x)))

;*---------------------------------------------------------------------*/
;*    min ...                                                          */
;*---------------------------------------------------------------------*/
(define (min x . y)
   (let loop ((x x)
	      (y y))
      (if (pair? y)
	  (loop (if (2< x (car y))
		    x
		    (car y))
		(cdr y))
	  x)))

;*---------------------------------------------------------------------*/
;*    2+ ...                                                           */
;*---------------------------------------------------------------------*/
(define (2+ x y)
   (2op + x y))

;*---------------------------------------------------------------------*/
;*    + ...                                                            */
;*---------------------------------------------------------------------*/
(define (+  . x)
   (let loop ((sum 0)
	      (x x))
      (if (pair? x)
	  (loop (2+ sum (car x))
		(cdr x))
	  sum)))

;*---------------------------------------------------------------------*/
;*    2* ...                                                           */
;*---------------------------------------------------------------------*/
(define (2* x y)
   (2op * x y))

;*---------------------------------------------------------------------*/
;*    * ...                                                            */
;*---------------------------------------------------------------------*/
(define (*  . x)
   (let loop ((product 1)
	      (x x))
      (if (pair? x)
	  (loop (2* product (car x)) (cdr x))
	  product)))

;*---------------------------------------------------------------------*/
;*    2- ...                                                           */
;*---------------------------------------------------------------------*/
(define (2- x y)
   (2op - x y))

;*---------------------------------------------------------------------*/
;*    - ...                                                            */
;*---------------------------------------------------------------------*/
(define (- x . y)
    (if (pair? y)
	(let loop ((result (2- x (car y)))
		   (args (cdr y)))
	   (if (pair? args)
	       (loop (2- result (car args)) (cdr args))
	       result))
	(2- 0 x)))

;*---------------------------------------------------------------------*/
;*    2/ ...                                                           */
;*---------------------------------------------------------------------*/
(define (2/ x y)
   (cond
      ((fixnum? x)
       (cond
	  ((fixnum? y)
	   (if (=fx (remainder x y) 0)
	       (/fx x y)
	       (/fl (fixnum->flonum x) (fixnum->flonum y))))
	  ((flonum? y)
	   (/fl (fixnum->flonum x) y))
	  ((elong? y)
	   (let ((ex (fixnum->elong x)))
	      (if (=elong (remainderelong ex y) #e0)
		  (/elong ex y)
		  (/fl (fixnum->flonum x) (elong->flonum y)))))
	  ((llong? y)
	   (let ((lx (fixnum->llong x)))
	      (if (=llong (remainderllong lx y) #l0)
		  (/llong lx y)
		  (/fl (fixnum->flonum x) (llong->flonum y)))))
	  (else
	   (error '/ "not a number" y))))
      ((flonum? x)
       (cond
	  ((flonum? y)
	   (/fl x y))
	  ((fixnum? y)
	   (/fl x (fixnum->flonum y)))
	  ((elong? y)
	   (/fl x (elong->flonum y)))
	  ((llong? y)
	   (/fl x (llong->flonum y)))
	  (else
	   (error '/ "not a number" y))))
      ((elong? x)
       (cond
	  ((fixnum? y)
	   (let ((ey (fixnum->elong y)))
	      (if (=elong (remainderelong x y) #e0)
		  (/elong x y)
		  (/fl (elong->flonum x) (fixnum->flonum y)))))
	  ((flonum? y)
	   (/fl (elong->flonum x) y))
	  ((elong? y)
	   (if (=elong (remainderelong x y) #e0)
	       (/elong x y)
	       (/fl (elong->flonum x) (elong->flonum y))))
	  ((llong? y)
	   (let* ((fx (elong->flonum x))
		  (lx (flonum->llong fx)))
	      (if (=llong (remainderllong lx y) #l0)
		  (/llong lx y)
		  (/fl fx (llong->flonum y)))))
	  (else
	   (error '/ "not a number" y))))
      ((llong? x)
       (cond
	  ((fixnum? y)
	   (let ((ly (fixnum->llong y)))
	      (if (=llong (remainderllong x y) #l0)
		  (/llong x y)
		  (/fl (llong->flonum x) (fixnum->flonum y)))))
	  ((flonum? y)
	   (/fl (llong->flonum x) y))
	  ((elong? y)
	   (let* ((fy (elong->flonum y))
		  (ly (flonum->llong fy)))
	      (if (=llong (remainderllong x ly) #l0)
		  (/llong x y)
		  (/fl (llong->flonum x) fy))))
	  ((llong? y)
	   (if (=llong (remainderllong x y) #l0)
	       (/llong x y)
	       (/fl (llong->flonum x) (llong->flonum y))))
	  (else
	   (error '/ "not a number" y))))
      (else
       (error / "not a number" x))))

;*---------------------------------------------------------------------*/
;*    / ...                                                            */
;*---------------------------------------------------------------------*/
(define (/ x . y)
    (if (pair? y)
	(let loop ((result (2/ x (car y)))
		   (z (cdr y)))
	     (if (pair? z)
		 (loop (2/ result (car z))
		       (cdr z))
		 result))
	(2/ 1 x)))

;*---------------------------------------------------------------------*/
;*    abs ...                                                          */
;*---------------------------------------------------------------------*/
(define (abs x)
   (cond
      ((fixnum? x)
       (absfx x))
      ((flonum? x)
       (absfl x))
      ((elong? x)
       (if (<elong x #e0)
	   (negelong x)
	   x))
      ((llong? x)
       (if (<llong x #l0)
	   (negllong x)
	   x))
      (else
       (error "abs" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    floor ...                                                        */
;*---------------------------------------------------------------------*/
(define (floor x)
   (cond
      ((fixnum? x)
       x)
      ((flonum? x)
       (floorfl x))
      ((elong? x)
       x)
      ((llong? x)
       x)
      (else
       (error "floor" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    ceiling ...                                                      */
;*---------------------------------------------------------------------*/
(define (ceiling x)
   (cond
      ((fixnum? x)
       x)
      ((flonum? x)
       (ceilingfl x))
      ((elong? x)
       x)
      ((llong? x)
       x)
      (else
       (error "ceiling" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    truncate ...                                                     */
;*---------------------------------------------------------------------*/
(define (truncate x)
   (cond
      ((fixnum? x)
       x)
      ((flonum? x)
       (truncatefl x))
      ((elong? x)
       x)
      ((llong? x)
       x)
      (else
       (error "truncate" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    round ...                                                        */
;*---------------------------------------------------------------------*/
(define (round x)
   (cond
      ((fixnum? x)
       x)
      ((flonum? x)
       (roundfl x))
      ((elong? x)
       x)
      ((llong? x)
       x)
      (else
       (error "round" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    exp ...                                                          */
;*---------------------------------------------------------------------*/
(define (exp x)
   (cond
      ((flonum? x)
       (expfl x))
      ((fixnum? x)
       (expfl (fixnum->flonum x)))
      ((elong? x)
       (expfl (elong->flonum x)))
      ((llong? x)
       (expfl (llong->flonum x)))
      (else
       (error "exp" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    log ...                                                          */
;*---------------------------------------------------------------------*/
(define (log x)
   (cond
      ((flonum? x)
       (logfl x))
      ((fixnum? x)
       (logfl (fixnum->flonum x)))
      ((elong? x)
       (logfl (elong->flonum x)))
      ((llong? x)
       (logfl (llong->flonum x)))
      (else
       (error "log" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    sin ...                                                          */
;*---------------------------------------------------------------------*/
(define (sin x)
   (cond
      ((flonum? x)
       (sinfl x))
      ((fixnum? x)
       (sinfl (fixnum->flonum x)))
      ((elong? x)
       (sin (elong->flonum x)))
      ((llong? x)
       (sin (llong->flonum x)))
      (else
       (error "sin" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    cos ...                                                          */
;*---------------------------------------------------------------------*/
(define (cos x)
   (cond
      ((flonum? x)
       (cosfl x))
      ((fixnum? x)
       (cosfl (fixnum->flonum x)))
      ((elong? x)
       (cos (elong->flonum x)))
      ((llong? x)
       (cos (llong->flonum x)))
      (else
       (error "cos" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    tan ...                                                          */
;*---------------------------------------------------------------------*/
(define (tan x)
   (cond
      ((flonum? x)
       (tanfl x))
      ((fixnum? x)
       (tanfl (fixnum->flonum x)))
      ((elong? x)
       (tan (elong->flonum x)))
      ((llong? x)
       (tan (llong->flonum x)))
      (else
       (error "tan" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    asin ...                                                         */
;*---------------------------------------------------------------------*/
(define (asin x)
   (cond
      ((flonum? x)
       (asinfl x))
      ((fixnum? x)
       (asinfl (fixnum->flonum x)))
      ((elong? x)
       (asin (elong->flonum x)))
      ((llong? x)
       (asin (llong->flonum x)))
      (else
       (error "asin" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    acos ...                                                         */
;*---------------------------------------------------------------------*/
(define (acos x)
   (cond
      ((flonum? x)
       (acosfl x))
      ((fixnum? x)
       (acosfl (fixnum->flonum x)))
      ((elong? x)
       (acos (elong->flonum x)))
      ((llong? x)
       (acos (llong->flonum x)))
      (else
       (error "acos" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    atan ...                                                         */
;*---------------------------------------------------------------------*/
(define (atan x . y)
   (let ((y (if (pair? y)
		(let ((y (car y)))
		   (cond
		      ((fixnum? y)
		       (fixnum->flonum y))
		      ((flonum? y)
		       y)
		      (else
		       (error "atan" "not a number" y))))
		#f)))
      (define (do-atanfl x) 
	 (if (number? y)
	     (atanfl x y)
	     (atanfl x)))
      (cond
	 ((flonum? x)
	  (do-atanfl x))
	 ((fixnum? x)
	  (do-atanfl (fixnum->flonum x)))
	 ((elong? x)
	  (do-atanfl (elong->flonum x)))
	 ((llong? x)
	  (do-atanfl (llong->flonum x)))
	 (else
	  (error "atan" "not a number" x)))))

;*---------------------------------------------------------------------*/
;*    sqrt ...                                                         */
;*---------------------------------------------------------------------*/
(define (sqrt x)
   (cond
      ((fixnum? x)
       (sqrtfl (fixnum->flonum x)))
      ((flonum? x)
       (sqrtfl x))
      ((elong? x)
       (sqrtfl (elong->flonum x)))
      ((llong? x)
       (sqrtfl (llong->flonum x)))
      (else
       (error "sqrt" "not a number" x))))

;*---------------------------------------------------------------------*/
;*    expt ...                                                         */
;*---------------------------------------------------------------------*/
(define (expt x y)
   (cond
      ((and (flonum? x) (flonum? y) (=fl x 0.0) (=fl y 0.0))
       1.0)
      ((and (fixnum? x) (fixnum? y))
       (flonum->fixnum (exptfl (fixnum->flonum x) (fixnum->flonum y))))
      (else
       (let ((x1 (cond
		    ((flonum? x)
		     x)
		    ((fixnum? x)
		     (fixnum->flonum x))
		    ((elong? x)
		     (elong->flonum x))
		    ((llong? x)
		     (llong->flonum x))
		    (else
		     (error 'expr "not a number" x))))
	     (y1 (cond
		    ((flonum? y)
		     y)
		    ((fixnum? y)
		     (fixnum->flonum y))
		    ((elong? y)
		     (elong->flonum y))
		    ((llong? y)
		     (llong->flonum y))
		    (else
		     (error 'expr "not a number" y)))))
	  (exptfl x1 y1)))))

;*---------------------------------------------------------------------*/
;*    exact->inexact ...                                               */
;*---------------------------------------------------------------------*/
(define-inline (exact->inexact z)
   (cond
      ((fixnum? z)
       (fixnum->flonum z))
      ((flonum? z)
       z)
      ((elong? z)
       (elong->flonum z))
      ((llong? z)
       (llong->flonum z))
      (else
       z)))

;*---------------------------------------------------------------------*/
;*    inexact->exact ...                                               */
;*---------------------------------------------------------------------*/
(define-inline (inexact->exact z)
   (if (inexact? z)
       (flonum->fixnum z)
       z))
 
;*---------------------------------------------------------------------*/
;*    number->string ...                                               */
;*---------------------------------------------------------------------*/
(define (number->string x . radix)
   (if (null? radix)
       (set! radix 10)
       (set! radix (car radix)))
   (cond
      ((fixnum? x)
       (integer->string x radix))
      ((flonum? x)
       (real->string x))
      ((elong? x)
       (elong->string x radix))
      ((llong? x)
       (llong->string x radix))
      (else
       (error "number->string" "Argument not a number" x))))

;*---------------------------------------------------------------------*/
;*    @deffn string->number@ ...                                       */
;*---------------------------------------------------------------------*/
(define (string->number x . radix)
   (define (integer-string? x r)
      (let loop ((i (-fx (string-length x) 1)))
	 (cond ((=fx -1 i)
		#t)
	       ((and (char>=? (string-ref x i) #\0)
		     (char<=? (string-ref x i) #\1)
		     (>=fx r 2))
		(loop (-fx i 1)))
	       ((and (char>=? (string-ref x i) #\2)
		     (char<=? (string-ref x i) #\7)
		     (>=fx r 8))
		(loop (-fx i 1)))
	       ((and (char>=? (string-ref x i) #\8)
		     (char<=? (string-ref x i) #\9)
		     (>=fx r 10))
		(loop (-fx i 1)))
	       ((and (char>=? (string-ref x i) #\a)
		     (char<=? (string-ref x i) #\f)
		     (=fx r 16))
		(loop (-fx i 1)))
	       ((and (char>=? (string-ref x i) #\A)
		     (char<=? (string-ref x i) #\F)
		     (=fx r 16))
		(loop (-fx i 1)))
	       ((or (char=? (string-ref x i) #\-)
		    (char=? (string-ref x i) #\+))
		(=fx i 0))
	       (else #f))))
   (define (real-string? x)
      (let ((len (string-length x)))
	 (let loop ((i 0)
		    (e #f)
		    (p 0)
		    (d #f))
	    (cond ((=fx i len)
		   d)
		  ((and (char>=? (string-ref x i) #\0)
			(char<=? (string-ref x i) #\9))
		   (loop (+fx i 1)
			 e
			 0
			 #t))
		  ((char=? (string-ref x i) #\.)
		   (loop (+fx i 1)
			 e
			 0
			 d))
		  ((or (char=? (string-ref x i) #\e)
		       (char=? (string-ref x i) #\E))
		   (if e
		       #f
		       (loop (+fx i 1)
			     #t
			     (+fx i 1)
			     d)))
		  ((or (char=? (string-ref x i) #\-)
		       (char=? (string-ref x i) #\+))
		   (and (or (=fx i 0) (=fx i p))
			(loop (+fx i 1)
			      e
			      0
			      d)))
		  (else #f)))))
   (let ((rx (match-case radix
		(() 10)
		((?val)
		 (case val
		    ((2 8 10 16) val)
		    (else (error "string->number"
				 "Illegal radix"
				 val))))
		(else (error "string->number"
			     "Illegal number of optional arguments"
			     radix)))))
      (cond
	 ((=fx (string-length x) 0)
	  #f)
	 ((integer-string? x rx)
	  (string->integer x rx))
	 ((real-string? x)
	  (if (=fx rx 10)
	      (string->real x)
	      (error "string->number"
		     "Only radix `10' is legal for floating point number"
		     rx)))
	 (else
	  #f))))
