;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Tools/location.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri May 31 10:00:44 1996                          */
;*    Last change :  Fri Jul  4 14:59:37 2003 (serrano)                */
;*    Copyright   :  1996-2003 Manuel Serrano, see LICENSE file        */
;*    -------------------------------------------------------------    */
;*    The location managment                                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module ...                                                   */
;*---------------------------------------------------------------------*/
(module tools_location
   (include "Tools/location.sch")
   (import  engine_param)
   (export  (find-location                <s-exp>)
	    (find-location/loc            <s-exp> ::obj)
	    (location-full-fname::bstring ::obj)
	    (location-shape               ::obj ::obj)
	    (dump-location                ::obj ::obj)))

;*---------------------------------------------------------------------*/
;*    find-location ...                                                */
;*---------------------------------------------------------------------*/
(define (find-location exp)
   (define (parse-location loc)
      (if (location? loc)
	  loc
	  (match-case loc
	     ((at ?fname ?pos)
	      (warning "find-location" "obsolete `at' format -- " loc))
	     ((at ?fname ?pos ?lnum)
	      (location fname pos lnum))
	     (else
	      #f))))
   (cond
      ((epair? exp)
       ;; easy the location has been directly produced by the reader.
       (parse-location (cer exp)))
      (else
       #f)))

;*---------------------------------------------------------------------*/
;*    find-location/loc ...                                            */
;*---------------------------------------------------------------------*/
(define (find-location/loc exp loc)
   (let ((new-loc (find-location exp)))
      (if (location? new-loc)
	  new-loc
	  loc)))

;*---------------------------------------------------------------------*/
;*    location-full-fname ...                                          */
;*---------------------------------------------------------------------*/
(define (location-full-fname loc)
   (let* ((file-name (location-fname loc))
	  (full-name (make-file-name (pwd) file-name)))
      (if (file-exists? full-name)
	  full-name
	  (let ((lib-name (make-file-name *lib-src-dir* file-name)))
	     (if (file-exists? lib-name)
		 lib-name
		 file-name)))))

;*---------------------------------------------------------------------*/
;*    location-shape ...                                               */
;*---------------------------------------------------------------------*/
(define (location-shape loc l)
   (if (and *location-shape?* (location? loc))
       (cons (vector (string->symbol (location-fname loc))
		     ;; we use string->symbol just to avoid the #"..." printing
		     (location-pos loc)
		     (location-lnum loc))
	     l)
       l))
       
;*---------------------------------------------------------------------*/
;*    dump-location ...                                                */
;*---------------------------------------------------------------------*/
(define (dump-location from expr)
   (print "~~ " from ": " expr " " (find-location expr))
   (let loop ((expr expr))
      (if (pair? expr)
	  (begin
	     (print "____ " from ": " expr
		    " " (find-location expr))
	     (loop (cdr expr))))))
