/*
 * Bickley - a meta data management framework.
 * Copyright © 2008, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef __BKL_ITEM_IMAGE_H__
#define __BKL_ITEM_IMAGE_H__

#include <bickley/bkl-item-extended.h>


G_BEGIN_DECLS

#define BKL_TYPE_ITEM_IMAGE                                             \
   (bkl_item_image_get_type())
#define BKL_ITEM_IMAGE(obj)                                             \
   (G_TYPE_CHECK_INSTANCE_CAST ((obj),                                  \
                                BKL_TYPE_ITEM_IMAGE,                    \
                                BklItemImage))
#define BKL_ITEM_IMAGE_CLASS(klass)                                     \
   (G_TYPE_CHECK_CLASS_CAST ((klass),                                   \
                             BKL_TYPE_ITEM_IMAGE,                       \
                             BklItemImageClass))
#define IS_BKL_ITEM_IMAGE(obj)                                          \
   (G_TYPE_CHECK_INSTANCE_TYPE ((obj),                                  \
                                BKL_TYPE_ITEM_IMAGE))
#define IS_BKL_ITEM_IMAGE_CLASS(klass)                                  \
   (G_TYPE_CHECK_CLASS_TYPE ((klass),                                   \
                             BKL_TYPE_ITEM_IMAGE))
#define BKL_ITEM_IMAGE_GET_CLASS(obj)                                   \
   (G_TYPE_INSTANCE_GET_CLASS ((obj),                                   \
                               BKL_TYPE_ITEM_IMAGE,                     \
                               BklItemImageClass))

typedef struct _BklItemImagePrivate BklItemImagePrivate;
typedef struct _BklItemImage      BklItemImage;
typedef struct _BklItemImageClass BklItemImageClass;

struct _BklItemImage
{
    BklItemExtended parent;

    BklItemImagePrivate *priv;
};

struct _BklItemImageClass
{
    BklItemExtendedClass parent_class;
};

GType bkl_item_image_get_type (void) G_GNUC_CONST;

BklItemImage *bkl_item_image_new (void);
BklItemImage *bkl_item_image_new_from_field (KozoField *field);

GSList *bkl_item_image_get_fields (BklItemImage *item);

void bkl_item_image_set_title (BklItemImage *image,
                               const char   *title);
const char *bkl_item_image_get_title (BklItemImage *image);

void bkl_item_image_set_camera_make (BklItemImage *image,
                                     const char   *make);
const char *bkl_item_image_get_camera_make (BklItemImage *image);

void bkl_item_image_set_camera_model (BklItemImage *image,
                                      const char   *model);
const char *bkl_item_image_get_camera_model (BklItemImage *image);

void bkl_item_image_set_time (BklItemImage *image,
                              const char   *date);
const char *bkl_item_image_get_time (BklItemImage *image);

void bkl_item_image_set_time_original (BklItemImage *image,
                                       const char   *time_original);
const char *bkl_item_image_get_time_original (BklItemImage *image);

void bkl_item_image_set_time_digitized (BklItemImage *image,
                                        const char   *time_digitized);
const char *bkl_item_image_get_time_digitized (BklItemImage *image);

void bkl_item_image_set_orientation (BklItemImage *image,
                                     const char   *orientation);
const char *bkl_item_image_get_orientation (BklItemImage *image);

void bkl_item_image_set_exposure (BklItemImage *image,
                                  const char   *exposure);
const char *bkl_item_image_get_exposure (BklItemImage *image);

void bkl_item_image_set_aperture (BklItemImage *image,
                                  const char   *aperture);
const char *bkl_item_image_get_aperture (BklItemImage *image);

void bkl_item_image_set_metering_mode (BklItemImage *image,
                                       const char   *metering_mode);
const char *bkl_item_image_get_metering_mode (BklItemImage *image);

void bkl_item_image_set_flash (BklItemImage *image,
                               const char   *flash);
const char *bkl_item_image_get_flash (BklItemImage *image);

void bkl_item_image_set_iso (BklItemImage *image,
                             const char   *iso);
const char *bkl_item_image_get_iso (BklItemImage *image);

void bkl_item_image_set_software (BklItemImage *image,
                                  const char   *software);
const char *bkl_item_image_get_software (BklItemImage *image);

void bkl_item_image_set_author (BklItemImage *image,
                                const char   *author);
const char *bkl_item_image_get_author (BklItemImage *image);

void bkl_item_image_set_copyright (BklItemImage *image,
                                   const char   *copyright);
const char *bkl_item_image_get_copyright (BklItemImage *image);

void bkl_item_image_set_comment (BklItemImage *image,
                                 const char   *comment);
const char *bkl_item_image_get_comment (BklItemImage *image);

void bkl_item_image_set_user_comment (BklItemImage *image,
                                      const char   *user_comment);
const char *bkl_item_image_get_user_comment (BklItemImage *image);

void bkl_item_image_set_keywords (BklItemImage *image,
                                  const char   *keywords);
const char *bkl_item_image_get_keywords (BklItemImage *image);

void bkl_item_image_set_subject (BklItemImage *image,
                                 const char   *subject);
const char *bkl_item_image_get_subject (BklItemImage *image);

void bkl_item_image_set_focal_length (BklItemImage *image,
                                      const char   *focal_length);
const char *bkl_item_image_get_focal_length (BklItemImage *image);

void bkl_item_image_set_shutter_speed (BklItemImage *image,
                                       const char   *shutter_speed);
const char *bkl_item_image_get_shutter_speed (BklItemImage *image);

void bkl_item_image_set_width (BklItemImage *image,
                               guint         width);
guint bkl_item_image_get_width (BklItemImage *image);

void bkl_item_image_set_height (BklItemImage *image,
                                guint         height);
guint bkl_item_image_get_height (BklItemImage *image);

char *bkl_item_image_to_string (BklItemImage *image);

G_END_DECLS

#endif /* __BKL_ITEM_IMAGE_H__ */
