/*
 * Bickley - a meta data management framework.
 * Copyright © 2008, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef __BKL_ORBITER_H__
#define __BKL_ORBITER_H__

#include <glib.h>
#include <gio/gio.h>

#include "bkl-source.h"

G_BEGIN_DECLS

typedef struct _BklOrbiter BklOrbiter;

typedef struct _InvestigateUri {
    GFile *file;
    GTimeVal mtime;
} InvestigateUri;

guint bkl_orbiter_investigate_files (BklSource *source,
                                     GPtrArray *files);
void bkl_orbiter_start_worker (void);
GList *bkl_orbiter_get_sources (void);

void bkl_orbiter_shutdown (void);

G_END_DECLS

#endif
