# Copyright 2004,2005 Pierre Martineau <pmartino@users.sourceforge.net>
# This file is part of Bibus, a bibliographic database that can
# work together with OpenOffice.org to generate bibliographic indexes.
#
# Bibus is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Bibus is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Bibus; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA.
#
# generated by wxGlade 0.2 on Mon Apr 28 20:53:43 2003
# then edited by hand
# do not edit again with wxGlade !!

import wx
import BIB, urlparse, os, ShortcutEd

#class RefEditor(wx.Dialog):
class RefEditor(wx.Frame):
	def __init__(self, ref, db, selectedkey, editable, *args, **kwds):	# ref=reference to edit or () if new
		kwds["style"] = wx.DEFAULT_FRAME_STYLE | wx.TAB_TRAVERSAL
		wx.Frame.__init__(self, *args, **kwds)
		self.db = db	# database
		self.bibframe = args[0]
		self.selectedkey = selectedkey
		self.selectedText = None	# last select TextCtrl. Where to paste data.
		self.key,user,id = self.bibframe.keytree.GetPyData(selectedkey)	# category where a new ref must be added
		self.editable = editable		# True if the ref is editable
		if not ref:
			self.ref_id = [None,u'']
		else:
			self.ref_id = list(ref[0:2]) # Id, Identifier of the record
		self.__set_menu()
		self.notebook_1 = wx.Notebook(self, -1, style = wx.TAB_TRAVERSAL)
		self.__set_control(ref)
		self.__set_control2()
		self.__do_layout(BIB.REF_Ed_X, BIB.REF_Ed_Y, BIB.REF_Ed_WIDTH)
		self.__set_event()
		self.__set_properties(ref)
		if not self.editable: self.setReadOnly()
		#self.CenterOnParent()

# ------------------------ menu ------------------------------------------------
	def __set_menu(self):
		self.menubar = wx.MenuBar()
		self.SetMenuBar(self.menubar)
		# No shortcuts
		if not BIB.SHORTCUTS:
			tmp_menu = wx.Menu()
			self.menubar.Append(tmp_menu, _("You must first edit Pref/Shortcuts to use this menu"))
			return
		# shortcuts
		self.menutopitem={}	# we keep the index of the name of the topLabel for each Capture/Edit menu
		index = 0
		for shortname in BIB.SHORTCUTS:
			if not BIB.SHORT.has_key( shortname ):	# not read already
				BIB.CONFIG.readShortcut( shortname )
			tmp_menu = wx.Menu()
			# we first insert a 'Capture'/'Edit' menu
			tmp_menu = wx.Menu()
			#
			tmp_menuId = wx.NewId()
			tmp_menu.Append(tmp_menuId, _('Capture selection'))
			wx.EVT_MENU(self,tmp_menuId,self.capture)
			self.menutopitem[tmp_menuId] = index
			#
			tmp_menuId = wx.NewId()
			tmp_menu.Append(tmp_menuId, _('Edit shortcuts ...'))
			self.menutopitem[tmp_menuId] = index
			wx.EVT_MENU(self,tmp_menuId,self.editSortcuts)
			#
			tmp_menu.AppendSeparator()
			# now the shortcuts
			for shortcut in BIB.SHORT[ shortname ]:
				tmp_menuId = wx.NewId()
				tmp_menu.Append(tmp_menuId, shortcut)
				wx.EVT_MENU(self,tmp_menuId,self.menu)
			self.menubar.Append(tmp_menu, shortname )
			index = index + 1

	def menu(self,evt):
		try:
			 #self.FindFocus().WriteText(self.menubar.FindItemById( evt.GetId() ).GetLabel())	# FindFocus() does not work in wx.2.4
			 self.selectedText.WriteText(self.menubar.FindItemById( evt.GetId() ).GetLabel())
		except AttributeError:
			return

	def capture(self,evt):
		try:
			index = self.menutopitem[ evt.GetId() ]
			#capturedstr = self.FindFocus().GetStringSelection()	# FindFocus() does not work in wx.2.4
			capturedstr = self.selectedText.GetStringSelection()
			if capturedstr and capturedstr not in BIB.SHORT[ BIB.SHORTCUTS[index] ]:	# capture only if not already there and not ''
				BIB.SHORT[ BIB.SHORTCUTS[index] ].append(capturedstr)
				# add the string to the end of menu
				tmp_menuId = wx.NewId()
				self.menubar.GetMenu(index).Append(tmp_menuId, capturedstr)
				wx.EVT_MENU(self,tmp_menuId,self.menu)
		except AttributeError:
			return

	def editSortcuts(self,evt):
		index = self.menutopitem[ evt.GetId() ]
		short = BIB.SHORT[ BIB.SHORTCUTS[index] ]	#[:]	# we make a copy
		shEd = ShortcutEd.ShortcutEd(BIB.SHORTCUTS[index],short,self.db,self,-1,'')
		if shEd.ShowModal() == wx.ID_OK:
			# clear self.menutopitem for index
			for id,ind in self.menutopitem.items():
				if ind == index: del self.menutopitem[id]
			# we update the menu
			tmp_menu = wx.Menu()
			# we first insert a 'Capture'/'Edit' menu
			tmp_menu = wx.Menu()
			#
			tmp_menuId = wx.NewId()
			tmp_menu.Append(tmp_menuId, _('Capture selection'))
			self.menutopitem[tmp_menuId] = index
			wx.EVT_MENU(self,tmp_menuId,self.capture)
			#
			tmp_menuId = wx.NewId()
			tmp_menu.Append(tmp_menuId, _('Edit shortcuts ...'))
			self.menutopitem[tmp_menuId] = index
			wx.EVT_MENU(self,tmp_menuId,self.editSortcuts)
			#
			tmp_menu.AppendSeparator()
			# now the shortcuts
			for shortcut in BIB.SHORT[ BIB.SHORTCUTS[index] ]:
				tmp_menuId = wx.NewId()
				tmp_menu.Append(tmp_menuId, shortcut)
				wx.EVT_MENU(self,tmp_menuId,self.menu)
			# now we insert it at the place of the old one
			oldmenu = self.menubar.GetMenu(index)	# previous menu
			self.menubar.Replace(index,tmp_menu,BIB.SHORTCUTS[index] )
			oldmenu.Destroy()			# destroy the old menu. Not needed for wx.2.4 ?
		shEd.Destroy()
# ----------------------------- End menu ---------------------------------------

	def setReadOnly(self):
		"""disable panels because the ref is not editable"""
		for key in self.value:
			try:
				self.value[key].SetEditable(False)	# TextCtrl not editable
			except AttributeError:
				self.value[key].Disable()
		self.label['Identifier'].Disable()
		self.button_OK.Disable()	# disable OK button button we cannot save a modification
		self.button_Cancel.SetDefault()	# set Cancel to Default

	def __set_control(self,ref):
		#self.notebook_1_pane_3 = wx.Panel(self.notebook_1, -1)
		self.notebook_1_pane_3 = wx.ScrolledWindow(self.notebook_1, style = wx.TAB_TRAVERSAL)
		self.notebook_1_pane_3.SetScrollRate(10,10)
		#self.notebook_1_pane_2 = wx.Panel(self.notebook_1, -1)
		self.notebook_1_pane_2 = wx.ScrolledWindow(self.notebook_1, style = wx.TAB_TRAVERSAL)
		self.notebook_1_pane_2.SetScrollRate(10,10)
		#self.notebook_1_pane_1 = wx.Panel(self.notebook_1, -1)
		self.notebook_1_pane_1 = wx.ScrolledWindow(self.notebook_1, style = wx.TAB_TRAVERSAL)
		self.notebook_1_pane_1.SetScrollRate(10,10)
		try:
			self.bib_type = int(ref[BIB.BIBLIOGRAPHIC_FIELDS['BibliographicType']])
		except IndexError:
			self.bib_type = 0
		self.label = {}
		self.value = {}
		# pane_1 = required fields
		self.label['BibliographicType'] = wx.StaticText(self.notebook_1_pane_1, -1, BIB.NAME_FIELD["BibliographicType"])
		self.value['BibliographicType'] = wx.Choice(self.notebook_1_pane_1, -1, choices=[BIB.NAME_TYPE[typ] for typ in BIB.BIB_TYPE])
		self.label['Identifier'] = wx.CheckBox(self.notebook_1_pane_1,-1,_("Edit Identifier"))	# if checked => editable Identifier
		self.value['Identifier'] = wx.TextCtrl(self.notebook_1_pane_1, -1,style=BIB.EDIT_STYLE['Identifier'])
		#self.value['Identifier'].SetBackgroundColour(wx.LIGHT_GREY)
		#
		for item in BIB.EDIT[BIB.BIB_TYPE[self.bib_type]][0] + ('Abstract',):
			self.label[item] = wx.StaticText(self.notebook_1_pane_1, -1, BIB.NAME_FIELD[item])
			self.value[item] = wx.TextCtrl(self.notebook_1_pane_1, -1,style=BIB.EDIT_STYLE[item])
		# pane_2 = supplementary fields
		for item in BIB.EDIT[BIB.BIB_TYPE[self.bib_type]][1]:
			self.label[item] = wx.StaticText(self.notebook_1_pane_2, -1, BIB.NAME_FIELD[item])
			self.value[item] = wx.TextCtrl(self.notebook_1_pane_2, -1,style=BIB.EDIT_STYLE[item])
		# pane_3 = other fields
		for item in BIB.BIB_FIELDS:
			if item not in BIB.EDIT[BIB.BIB_TYPE[self.bib_type]][0]+BIB.EDIT[BIB.BIB_TYPE[self.bib_type]][1]+('Id','Identifier','BibliographicType','Abstract'):
				self.label[item] = wx.StaticText(self.notebook_1_pane_3, -1, BIB.NAME_FIELD[item])
				self.value[item] = wx.TextCtrl(self.notebook_1_pane_3, -1, style=BIB.EDIT_STYLE[item])
		# replace label 'URL' with a button
		self.label['URL'].Destroy()
		if 'URL' in BIB.EDIT[BIB.BIB_TYPE[self.bib_type]][0]:
			tmpnb = self.notebook_1_pane_1
		elif 'URL' in BIB.EDIT[BIB.BIB_TYPE[self.bib_type]][1]:
			tmpnb = self.notebook_1_pane_2
		else:
			tmpnb = self.notebook_1_pane_3
		self.label['URL'] = wx.Button(tmpnb,-1,_('URL/File...'),style=wx.BU_LEFT)
		# set event
		for item in ('Identifier',) + BIB.BIB_FIELDS[3:-1]:
			wx.EVT_SET_FOCUS(self.value[item],self.onFocus)	# we save the current focus. Needed under w2.4 because FindFocus() does not work

	def onFocus(self,evt):
		self.selectedText = evt.GetEventObject()
		evt.Skip()

	def __set_control2(self):
		self.button_Cancel = wx.Button(self, wx.ID_CANCEL, _("Cancel"))
		self.button_OK = wx.Button(self, wx.ID_OK, _("OK"))

	def __set_event(self):
		wx.EVT_BUTTON(self,wx.ID_OK,self.__OnOK)
		wx.EVT_BUTTON(self,wx.ID_CANCEL,self.OnCloseWindow)
		wx.EVT_CLOSE(self, self.OnCloseWindow)
		wx.EVT_CHOICE(self,self.value['BibliographicType'].GetId(),self.onBibTypeChoice)
		wx.EVT_CHECKBOX(self,self.label['Identifier'].GetId(),lambda evt: self.value['Identifier'].Enable(evt.IsChecked()) )
		wx.EVT_BUTTON(self,self.label['URL'].GetId(),self.getURL)

	def onBibTypeChoice(self,event):
		ref = self.ref_id[0:1]	# we make a copy to avoid modification
		ref.append( self.value['Identifier'].GetValue())
		ref.append( BIB.BIBLIOGRAPHIC_TYPE[BIB.TYPE_NAME[event.GetString()]] )
		for item in BIB.BIB_FIELDS[3:]:
			ref.append(self.value[item].GetValue())
		editable = self.label['Identifier'].GetValue()	# we save the state of the identifier: editable or not ?
		self.__clear_control()
		self.__set_control(ref)
		self.__do_layout(self.GetPositionTuple()[0],self.GetPositionTuple()[1],self.GetSize().GetWidth())
		self.__set_fields_values(ref)
		# we restore the identifier state
		self.label['Identifier'].SetValue(editable)
		if editable: self.value['Identifier'].Enable(True)
		else: self.value['Identifier'].Enable(False)
		#
		self.__set_event()

	def __clear_control(self):
		self.notebook_1.DeleteAllPages()

	def getURL(self,event):
		"""Select a file containing the reference"""
		filename = wx.FileSelector(_("Please select the file"),BIB.FILES,wildcard=\
		"%s (*.pdf)|*.pdf|%s (*.sxw)|*.sxw|%s (*.doc)|*.doc|%s (*.*)|*.*"\
		%(_("Acrobat file"),\
		_("OpenOffice.org Text Document"),\
		_("Microsoft Word Document"),\
		_("All files")), parent=self )
		if filename:
			if BIB.FILES:
				if not BIB.FILES.endswith(os.sep): BIB.FILES = BIB.FILES + os.sep	# we add / at the end
				if filename.startswith(BIB.FILES):	# We replace the default directory with $FILES
					filename = filename.replace(BIB.FILES,'',1)
					filename = os.path.join('$FILES',filename)
			self.value['URL'].SetValue( urlparse.urlunparse(('file','', filename, '', '', '')) )

	def OnCloseWindow(self,event):
		#Saving position and width
		BIB.REF_Ed_WIDTH = self.GetSizeTuple()[0]				# saving width
		BIB.REF_Ed_X, BIB.REF_Ed_Y = self.GetPositionTuple()	# and position
		self.Destroy()
		
	def __checkAuthors(self,authors):
		"""Check consistency of author list"""
		for author in authors.split(BIB.SEP):
			if author.count(',') != 1:
				ret = wx.MessageBox(\
_("""Author "%(author)s" contains %(nb_comma)s comma.\n\
The correct format for authors is:\n\n\
"Name, FirstName MiddleName"\n\
or\n\
"Name, FM"\n\n\
Would you like to re-edit the reference?"""%{"nb_comma":author.count(','),"author":author}),\
							_("Error in authors?"),\
							style = wx.YES_NO, parent = self )
				if ret == wx.YES: return False
			elif author.find(".") != -1:
				ret = wx.MessageBox(\
_("""Author "%(author)s" contains a period.\n\
The correct format for authors is:\n\n\
"Name, FirstName MiddleName"\n\
or\n\
"Name, FM"\n\n\
Would you like to re-edit the reference?"""%{"nb_comma":author.count(','),"author":author}),\
							_("Error in authors?"),\
							style = wx.YES_NO, parent = self )
				if ret == wx.YES: return False			
			elif len(author) > BIB.AUTHORTOLONG:
				ret = wx.MessageBox(\
_("""Author "%(author)s" is very long.\n\
The correct format for authors is:\n\n\
"Name1, FirstName1 MiddleName1; Name2, FirstName2 MiddleName2"\n\
or\n\
"Name1, FM; Name2, FM"\n\n\
Would you like to re-edit the reference?"""%{"author":author}),\
							_("Error in authors?"),\
							style = wx.YES_NO, parent = self )
				if ret == wx.YES: return False
		return True

	def __OnOK(self,event):
		#if self.Validate() and self.TransferDataFromWindow():	# no needed since no validator (crash on W98)
		# self.SetReturnCode(wx.ID_OK)	# not a dialog anymore (because we added a menu bar)
		if self.__checkAuthors( self.value['Author'].GetValue() ):
			ref=self.ref_id[0:1]
			ref.append( self.value['Identifier'].GetValue() )
			ref.append( BIB.BIBLIOGRAPHIC_TYPE[BIB.TYPE_NAME[self.value['BibliographicType'].GetStringSelection()]] )
			for item in BIB.BIB_FIELDS[3:]:
				ref.append( self.value[item].GetValue() )
			#print ref
			if ref[0] != None:
				ref_id = ref[0]
				self.db.modifyRef(BIB.BIB_FIELDS[1:],tuple(ref[1:]),ref[0])
				newIdentifier = self.db.getRef(ref[0],('Identifier',))[0][0]
				if ref[1] and newIdentifier != ref[1]:	# the Identifier has been changed
					wx.MessageBox(_("The reference or the identifier was not unique. The reference identifier has been changed to %s")%newIdentifier)
			else:
				ref_id = self.db.writeRef(ref)
				if ref_id != None:
					self.db.writeLink((self.key,ref_id))
					newIdentifier = self.db.getRef(ref_id,('Identifier',))[0][0]
					if ref[1] and newIdentifier != ref[1]:	# the Identifier has been changed
						wx.MessageBox(_("The reference or the identifier was not unique. The reference identifier has been changed %s")%newIdentifier)
			self.bibframe.keytree.SelectItem(self.selectedkey)
			self.bibframe.keytree.KeySelect(self.selectedkey)		# update the list
			item = self.bibframe.reflist.FindItemData(-1, ref_id)
			self.bibframe.reflist.Select(item,True)
			self.bibframe.reflist.Focus(item)
			self.bibframe.reflist.EnsureVisible(item)
			self.Close(True)

	def __set_properties(self,ref):
		self.SetTitle(_("Reference Editor"))
		#self.SetSize((600, -1))
		self.button_OK.SetDefault()
		self.value['BibliographicType'].SetSelection(0)		# select ARTICLE type by default
		self.__set_fields_values(ref)
		if ref:
			self.label['Identifier'].SetValue(False)		# if Identifier exists => not editable by default
			self.value['Identifier'].Disable()
		else:
			self.label['Identifier'].SetValue(True)		# if 'New Ref' => Identifier Editable by default
			self.value['Identifier'].Enable(True)

	def __set_fields_values(self,ref):
		# set fields values
		if ref:
			self.value['BibliographicType'].SetStringSelection(BIB.NAME_TYPE[BIB.BIB_TYPE[self.bib_type]])
			for item in BIB.BIB_FIELDS[3:]: self.value[item].SetValue( ref[BIB.BIBLIOGRAPHIC_FIELDS[item]] )
			if type(ref[BIB.BIBLIOGRAPHIC_FIELDS['Identifier']]) in (str,unicode):
				self.value['Identifier'].SetValue( ref[BIB.BIBLIOGRAPHIC_FIELDS['Identifier']] )

	def __do_layout(self,x,y,width):
		"""width = width of the dialog"""
		sizer_10 = wx.BoxSizer(wx.VERTICAL)
		sizer_3 = wx.BoxSizer(wx.HORIZONTAL)
		grid_sizer_1 = wx.FlexGridSizer(3+len(BIB.EDIT[BIB.BIB_TYPE[self.bib_type]][0]), 2, 0, 0)
		grid_sizer_2 = wx.FlexGridSizer(len(BIB.EDIT[BIB.BIB_TYPE[self.bib_type]][1]), 2, 0, 0)
		grid_sizer_3 = wx.FlexGridSizer(len(BIB.BIB_FIELDS)-4-len(BIB.EDIT[BIB.BIB_TYPE[self.bib_type]][0])-len(BIB.EDIT[BIB.BIB_TYPE[self.bib_type]][1]), 2, 0, 0)
		# pane_1
		#grid_sizer_1.Add(self.label['BibliographicType'], 0, 0, 0)
		#grid_sizer_1.Add(self.value['BibliographicType'], 0, 0, 0)
		grid_sizer_1.AddGrowableRow(len(BIB.EDIT[BIB.BIB_TYPE[self.bib_type]][0])+2)
		grid_sizer_1.AddGrowableCol(1)
		for item in ('BibliographicType','Identifier',)+BIB.EDIT[BIB.BIB_TYPE[self.bib_type]][0]:
			grid_sizer_1.Add(self.label[item], 0, wx.ALL, 3)
			grid_sizer_1.Add(self.value[item], 0, wx.EXPAND, 0)
		grid_sizer_1.Add(self.label['Abstract'], 0, wx.ALL,3)
		grid_sizer_1.Add(self.value['Abstract'], 1, wx.EXPAND, 0)
		self.notebook_1_pane_1.SetAutoLayout(1)
		self.notebook_1_pane_1.SetSizer(grid_sizer_1)
		#grid_sizer_1.Fit(self.notebook_1_pane_1)
		grid_sizer_1.SetSizeHints(self.notebook_1_pane_1)
		# pane_2
		for item in BIB.EDIT[BIB.BIB_TYPE[self.bib_type]][1]:
			grid_sizer_2.Add(self.label[item], 0, wx.ALL, 3)
			grid_sizer_2.Add(self.value[item], 1, wx.EXPAND, 0)
		grid_sizer_2.AddGrowableCol(1)
		self.notebook_1_pane_2.SetAutoLayout(1)
		self.notebook_1_pane_2.SetSizer(grid_sizer_2)
		#grid_sizer_2.Fit(self.notebook_1_pane_2)
		grid_sizer_2.SetSizeHints(self.notebook_1_pane_2)
		# pane_3
		for item in BIB.BIB_FIELDS:
			if item not in BIB.EDIT[BIB.BIB_TYPE[self.bib_type]][0]+BIB.EDIT[BIB.BIB_TYPE[self.bib_type]][1]+('Id','Identifier','BibliographicType','Abstract'):
				grid_sizer_3.Add(self.label[item], 0, wx.ALL, 3)
				grid_sizer_3.Add(self.value[item], 1, wx.EXPAND, 0)
		grid_sizer_3.AddGrowableCol(1)
		self.notebook_1_pane_3.SetAutoLayout(1)
		self.notebook_1_pane_3.SetSizer(grid_sizer_3)
		#grid_sizer_3.Fit(self.notebook_1_pane_3)
		grid_sizer_3.SetSizeHints(self.notebook_1_pane_3)
		#
		self.notebook_1.AddPage(self.notebook_1_pane_1, _("Main Fields"))
		self.notebook_1.AddPage(self.notebook_1_pane_2, _("Supplementary Fields"))
		self.notebook_1.AddPage(self.notebook_1_pane_3, _("Other Fields"))
		if wx.VERSION[:2] >= (2,6):	# wx.NotebookSizer no more needed with wx.Python2.6
			sizer_10.Add(self.notebook_1, 1, wx.EXPAND, 0)
		else:
			sizer_10.Add(wx.NotebookSizer(self.notebook_1), 1, wx.EXPAND, 0)
		sizer_3.Add(self.button_Cancel, 0, wx.ALL, 10)
		sizer_3.Add(self.button_OK, 0, wx.ALL, 10)
		sizer_10.Add(sizer_3, 0, wx.ALIGN_CENTER_HORIZONTAL, 0)
		#
		self.SetAutoLayout(1)
		self.SetSizer(sizer_10)
		sizer_10.Fit(self)
		#sizer_10.SetSizeHints(self)
		self.SetDimensions(x, y, width, -1)
		self.Layout()

# end of class RefEditor

