#!/usr/bin/env python
# -*- coding: ISO-8859-1 -*-
# generated by wxGlade 0.4.1 on Sun Nov  5 21:18:09 2006

import wx, os.path, shutil, tempfile
import BIB

class Wizard_SQLite(wx.Panel):
	def __init__(self, *args, **kwds):
		# begin wxGlade: Wizard_SQLite.__init__
		kwds["style"] = wx.TAB_TRAVERSAL
		wx.Panel.__init__(self, *args, **kwds)
		self.label_8 = wx.StaticText(self, -1, _("SQLite file"))
		self.label_1 = wx.StaticText(self, -1, _("Bibus uses a file to store the bibliographic database.\n\nPlease enter in the box below the path to \nthe bibliographic database you want to use.\n\n- If the file EXIST, Bibus will \n	- not modify it\n	- assume it to be a correct Bibus database.\n\n- If the file DOES NOT EXIST, Bibus will \n	- create it\n	- use it as your bibliographic database."))
		self.db_file = wx.Button(self, -1, _("Database file ..."))
		self.filen = wx.TextCtrl(self, -1, "")
		self.static_line_1 = wx.StaticLine(self, -1)
		self.label_9 = wx.StaticText(self, -1, _("Username"))
		self.label_2 = wx.StaticText(self, -1, _("Bibus needs a USERNAME to identify yourself.\nPlease enter a name in the box below.\nYour login name might be a good idea"))
		self.user = wx.TextCtrl(self, -1, "")

		self.__set_properties()
		self.__do_layout()

		self.Bind(wx.EVT_BUTTON, self.onFileChoice, self.db_file)
		# end wxGlade

	def __set_properties(self):
		# begin wxGlade: Wizard_SQLite.__set_properties
		self.label_8.SetFont(wx.Font(12, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))
		self.label_9.SetFont(wx.Font(12, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))
		# end wxGlade
		if BIB.SQLiteFile:
			self.filen.SetValue(BIB.SQLiteFile)
		else:
			f = tempfile.NamedTemporaryFile('w+b',-1,'.sqlite','DB_', os.path.join( wx.StandardPaths.Get().GetUserDataDir(), "Databases") )
			self.filen.SetValue(f.name)
			f.close()
		#
		if not BIB.CONFIG.userDefined('sqlite'):
			try:
				import getpass
				BIB.SQLiteUSER = getpass.getuser()	# We try to get a default value if not already defined.
			except:
				BIB.SQLiteUSER = ''
		self.user.SetValue(BIB.SQLiteUSER)

	def __do_layout(self):
		# begin wxGlade: Wizard_SQLite.__do_layout
		sizer_1 = wx.BoxSizer(wx.VERTICAL)
		sizer_2 = wx.BoxSizer(wx.HORIZONTAL)
		sizer_1.Add(self.label_8, 0, wx.BOTTOM|wx.ADJUST_MINSIZE, 5)
		sizer_1.Add(self.label_1, 1, wx.ADJUST_MINSIZE, 0)
		sizer_2.Add(self.db_file, 0, wx.ADJUST_MINSIZE, 0)
		sizer_2.Add(self.filen, 1, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
		sizer_1.Add(sizer_2, 0, wx.TOP|wx.EXPAND, 5)
		sizer_1.Add((20, 20), 0, wx.ADJUST_MINSIZE, 0)
		sizer_1.Add(self.static_line_1, 0, wx.EXPAND, 0)
		sizer_1.Add(self.label_9, 0, wx.BOTTOM|wx.ADJUST_MINSIZE, 5)
		sizer_1.Add(self.label_2, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 20)
		sizer_1.Add(self.user, 0, wx.TOP|wx.EXPAND|wx.ADJUST_MINSIZE, 5)
		self.SetAutoLayout(True)
		self.SetSizer(sizer_1)
		sizer_1.Fit(self)
		sizer_1.SetSizeHints(self)
		# end wxGlade

	def onFileChoice(self,event): # wxGlade: Wizard_SQLite.<event_handler>
		if BIB.SQLiteFile:
			default = BIB.SQLiteFile
		else:
			default = 'biblioDB.sqlite'
		filename = wx.FileSelector(_('SQlite database file'),default_filename = default, flags = 2 ) # wx.FD_SAVE = 2 is missing in some version of wxPython
		self.filen.SetValue(filename)
		
	def check(self):
		try:
			try:
				from sqlite3 import version_info				# python >= 2.5
			except ImportError:
				try:
					from pysqlite2.dbapi2 import version_info
				except ImportError:
					from sqlite import version_info
			if version_info < (1,1,0):
				self.sqliteversion = '1_0'
			elif version_info < (2,0,0):
				self.sqliteversion = '1_1'
			else:
				self.sqliteversion = '2'
		except ImportError:
			wx.MessageBox(_("Sorry but the SQLite python extension is not available.\nRead installation.txt"),_('Error'),wx.ICON_ERROR|wx.OK)

	def createSQLiteDB(self):
		"""create a sqlite database"""
		if not os.path.exists(BIB.SQLiteFile):
			shutil.copyfile( os.path.join(BIB.SOURCEDIR,'db_models','biblio.pysqlite%s'%self.sqliteversion), BIB.SQLiteFile )
		elif self.sqliteversion in ('1_1','2'):	# new database format and we use a previous file => warn the user
			fileDB = open(BIB.SQLiteFile,'r')
			if fileDB.read(15) != 'SQLite format 3':
				wx.MessageBox(_("It seems that your database is not compatible with your PySQLite version.\nIf it does not work,\nsee the SQLite site about database format change in SQLite3 http://www.sqlite.org/version3.html"),_('Error'),wx.ICON_ERROR|wx.OK)
			fileDB.close()
			self.convertDB()
		elif self.sqliteversion == '1_0':
			fileDB = open(BIB.SQLiteFile,'r')
			if fileDB.read(47) != '** This file contains an SQLite 2.1 database **':
				wx.MessageBox(_("It seems that your database is not compatible with your PySQLite version.\nIf it does not work,\nsee the SQLite site about database format change in SQLite3 http://www.sqlite.org/version3.html"),_('Error'),wx.ICON_ERROR|wx.OK)
			fileDB.close()
			self.convertDB()
		else:
			print "What are we doing here ? line 108 in Wizard_SQLite.py"
			
	def getValues(self):
		return self.user.GetValue(),self.filen.GetValue()

	def convertDB(self):
		""" We convert db from bibus 1.3 to 1.4 by adding the table table_modif """
		try:
			import dbBibSQLite
		except ImportError:
			wxLogError(_("""Sorry, but I was not able to find the python module for the %s database.\nPlease check your installation""")%'SQLite')
			return
		#			
		db_old = dbBibSQLite.dbBib()
		db_old.selectTable()
		if (BIB.DB_TABLE_MODIF,) not in db_old.getTables():
			savedFile = BIB.SQLiteFile
			# we create the database in the default location
			f = tempfile.NamedTemporaryFile('w+b',-1,'.sqlite','DB_', os.path.join( wx.StandardPaths.Get().GetUserDataDir(), "Databases") )
			BIB.SQLiteFile = f.name
			f.close()
			#
			db = dbBibSQLite.dbBib()
			db.createDatabase(BIB.SQLiteFile,BIB.DB_TABLE_REF,BIB.DB_TABLE_KEY,BIB.DB_TABLE_LINK,BIB.DB_TABLE_QUERY,BIB.DB_TABLE_MODIF)
			#
			refsId=[]
			tmprefs = db_old.getAllDatabase(collist=())
			refsId = [x[0] for x in tmprefs]
			# writing records
			for refId in refsId:
				db.writeRef( db_old.getRef(refId,BIB.BIB_FIELDS)[0] )
			# we copy the rest of the database only if we export everything
			# now we copy the keys
			for key in db_old.getAllKeys():
				db.dumpKey( key )
			# now the Links
			for link in db_old.getAllLinks():
				db.writeLink( link )
			# then the queries
			for query in db_old.getAllQueries():
				db.dumpQuery( query )
			# if default database is set in config DB_STARTUP=1, the new db won't be used at the next startup
			# we simply revert to the default setting, ie we open the last db.
			DB_STARTUP = 0
			#	
			wx.MessageBox(_('You database has been converted to the new format.\nThe database is now located at\n"%s"')%f.name,_("Database conversion"),wx.OK)

# end of class Wizard_SQLite


