/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include "Book.h"


Book::Book()
: originator(this),
  author(_("Unknown")),
  title(_("New Book")),
  category(_("Undefined")),
  rating(-1)
{
  memset(&readdate, 0, sizeof(tm));
}


Book::~Book()
{
}


bool Book::operator ==(Book book)
{
  return originator == book.originator;
}


void Book::set_author(string pauthor)
{
  author = pauthor;
}


string Book::get_author(void)
{
  return author;
}


void Book::set_title(string ptitle)
{
  title = ptitle;
}


string Book::get_title(void)
{
  return title;
}


void Book::set_isbn(string pisbn)
{
  isbn = pisbn;
}


string Book::get_isbn(void)
{
  return isbn;
}


void Book::set_category(string pcategory)
{
  category = pcategory;
}


string Book::get_category(void)
{
  return category;
}


void Book::set_summary(string psummary)
{
  summary = psummary;
}


string Book::get_summary(void)
{
  return summary;
}


static string replace(string s, char from, char to)
{
  int i;
  for (i = 0; s[i]; i++)
    if (s[i] == from)
      s[i] = to;
  return s;
}


string Book::get_summary(unsigned int len)
{
  if (summary.length() <= len)
    return replace(summary, '\n', ' ');
  string summary_cut = summary.substr(0, len) + "...";
  return replace(summary_cut, '\n', ' ');
}


void Book::set_review(string preview)
{
  review = preview;
}


string Book::get_review(void)
{
  return review;
}


void Book::set_rating(int prating)
{
  if (rating < -1 || rating > 10)
    rating = -1;
  else
    rating = prating;
}


int Book::get_rating(void)
{
  return rating;
}


void Book::set_readdate(unsigned int year, unsigned int month, unsigned int day)
{
  readdate.tm_year = year - 1900;
  readdate.tm_mon  = month;
  readdate.tm_mday = day;
}


void Book::set_readdate_string(string date)
{
  if (!strptime(date.c_str(), "%x", &readdate))
    memset(&readdate, 0, sizeof(tm));
}


tm Book::get_readdate(void)
{
  return readdate;
}


string Book::get_readdate_string(void)
{
  struct tm undefined;
  memset(&undefined, 0, sizeof(tm));
  if (memcmp(&readdate, &undefined, sizeof(tm)) == 0)
    return _("Not yet read");
  char str[256];
  strftime(str, 255, "%x", &readdate);
  return str;
}


void Book::set_filename(string pfilename)
{
  filename = pfilename;
}


string Book::get_filename(void)
{
  return filename;
}


Book* Book::get_originator(void)
{
  return originator;
}
