/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "libraries.h"
#include "utilities.h"
#include <libgen.h>
#include <glib.h>
#include <config.h>
#include "xslformatter.h"
#include "gwrappers.h"
#include "gtkwrappers.h"
#include "unixwrappers.h"


/*
As FOP sometimes fails to properly format a Scripture, the commercially 
available proprietary XSLFormatter is supported too.
*/


ustring run_sh_command (Configuration * configuration)
{
  // Return the command to run script run.sh, if found.
  ustring run_sh;
  // XSLFormatter not used now. 
  // run_sh = gw_build_filename (configuration->xslformatter_home, "run.sh");
  if (!unix_which (run_sh))
    run_sh.clear();
  return run_sh;
}


bool xslformatter_present (GtkWidget * window, Configuration * configuration)
// Returns whether the script to run xslformatter can be found.
// Gives message if not found.
{
  bool present = false;
  if (!run_sh_command(configuration).empty())
    present = true;
  
  if (!present) {
    ustring message;
    message = "XSLFormatter was not found.\n";
    message.append ("XSLFormatter is set as your formatter of choice.\n");
    message.append ("It is required for printing.\n");
    message.append ("Install XSLFormatter first.\n");
    message.append ("For more information see menu Preferences->Formatter.");
    gtkw_dialog_info (window, message);
  }
  return present;
}


ustring xslformatter_convert_to_pdf (Configuration * configuration, const ustring& xslfo, const ustring& pdf, const ustring& logfile)
// Converts file "xslfo" to file "pdf", and returns the result.
{
  ustring command;
  command = run_sh_command(configuration);
  ustring returnvalue = command;
  command.append (" -d '");
  command.append (xslfo);
  command.append ("' -o '");
  command.append (pdf);
  command.append ("' -extlevel 4 > ");
  command.append (logfile);
  command.append (" 2>&1 &");
  if (system (command.c_str()) < 0)
    returnvalue.clear();
  return returnvalue;
}
