/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/

#ifndef INCLUDED_XSLFO_FOOTNOTE_H
#define INCLUDED_XSLFO_FOOTNOTE_H


#include "libraries.h"
#include "usfm.h"
#include "xmlfo-utils.h"
#include "configuration.h"
#include "notecaller.h"
#include "xslfofootnoteparagraph.h"


class XslFoFootnote
{
public:
  XslFoFootnote (const Usfm& usfm, Configuration * configuration, bool show);
  ~XslFoFootnote ();
  void new_book ();
  void new_chapter ();
  void transform (XmlFoBlock * xmlfoblock, ustring& line);
  NoteCaller * footnotecaller;
private:
  Configuration * myconfiguration;
  bool myshow;
  NoteNumberingRestartType note_numbering_restart;
  ustring opening_marker;
  ustring closing_marker;
  double anchor_fontpercentage;
  ustring anchor_italic;
  ustring anchor_bold;
  ustring anchor_underline;
  ustring anchor_smallcaps;
  bool anchor_superscript;
  bool anchor_apocrypha;
  vector<ustring> content_marker;
  vector <bool> content_apocrypha;
  set<ustring> footnote_markers;
  XslFoFootnoteParagraph * standardparagraph;
  XslFoFootnoteParagraph * extraparagraph;
  ustring transform_main_parts (XmlFoBlock * xmlfoblock, const ustring& line);
  ustring handle_nesting (const ustring& line);
};


#endif
