/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#ifndef INCLUDED_UTILITIES_H
#define INCLUDED_UTILITIES_H


#include "libraries.h"
#include <glib.h>
#include <gtk/gtk.h>


ustring trim (const ustring & s);
ustring number_in_string (const ustring & str);
ustring upperCase (const ustring & s);
ustring lowerCase (const ustring & s);
ustring remove_spaces (const ustring & s);
void create_directory (const ustring & dir);
void remove_directory (const ustring & dir);
void write_lines (const ustring & file, vector < ustring > &lines);
unsigned int convert_to_int (const ustring & str);
ustring convert_to_string (int i);
ustring convert_to_string (unsigned int i);
ustring convert_to_string (bool b);
ustring convert_to_string (double d);
ustring convert_to_string (long unsigned int i);
bool convert_to_bool (const ustring & s);
double convert_to_double (const ustring & s);
ustring temporary_file (const ustring & filename);
bool string_in_file (const ustring & filename, const ustring & line);
ustring string_reverse (const ustring & s);
ustring double_apostrophy (const ustring & line);
unsigned int file_get_modification_time (const ustring & filename);
void textbuffer_get_lines (GtkTextBuffer * buffer, vector<ustring>& lines);
bool replace_text (ustring& line, const ustring& look_for, const ustring& replace_with);
void quick_sort (vector<unsigned int>& one, vector<ustring>& two, unsigned int beg, unsigned int end);
void quick_sort (vector<ustring>& one, vector<unsigned int>& two, unsigned int beg, unsigned int end);
void quick_sort (vector<unsigned int>& one, vector<unsigned int>& two, unsigned int beg, unsigned int end);


class ReadDirectories
{
public:
  ReadDirectories (const ustring & path, const ustring & prefix, const ustring & suffix);
  ~ReadDirectories ();
  vector <ustring> directories;
private:
};

class ReadFiles
{
public:
  ReadFiles (const ustring & path, const ustring & prefix, const ustring & suffix);
  ~ReadFiles ();
  vector <ustring> files;
private:
};

class ReadText
{
public:
  ReadText (const ustring & file, bool silent = false, bool trimming = true);
  ~ReadText ();
  vector < ustring > lines;
private:
};

class WriteText
{
public:
  WriteText (const ustring & file);
  ~WriteText ();
  void text (const ustring& text);
private:
  int fd;
};

class Parse
{
public:
  Parse (const ustring & line, bool remove_punctuation = true);
  ~Parse ();
  vector < ustring > words;
private:
};

class ParseLine
{
public:
  ParseLine (const ustring & text);
  ~ParseLine ();
  vector <ustring> lines;
private:
};

#endif
