/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/

#ifndef INCLUDED_SESSION_H
#define INCLUDED_SESSION_H


#include "libraries.h"
#include <gtk/gtk.h>
#include "constants.h"


enum SearchResultsType {sstLoad, sstAdd, sstSubtract, sstShare};
enum SearchBibleTimeType {sbttDefaultBible, sbttOpenModules, sbttBible, sbttCommentary};
enum CheckMarkerCountType {cmctNoSort, cmctSortUsfm, cmctSortCount};
enum CheckCharactersCountType {chctNoSort, chctSortUsfm, chctSortCount};
enum AreaType {atRaw, atAll, atSelection};


class Session
{
  // Stores settings valid during a session. If the program stops, this
  // information is lost - and that is what is wanted.
public:
  Session (int dummy);
  ~Session ();
  // Search / Replace
  ustring searchword;
  ustring replaceword;
  bool search_case_sensitive;
  bool search_current_book;
  bool search_globbing;
  bool search_start_word_match;
  bool search_end_word_match;
  SearchResultsType searchresultstype;
  int search_page;
  SearchBibleTimeType searchbibletimetype;
  ustring search_bibletime_bible;
  ustring search_bibletime_commentary;
  // Book selection.
  set<ustring> selected_books;
  // References highlighting.
  void highlights_clear ();
  void highlights_add (const ustring& word, bool casesensitive, bool globbing, bool matchbegin, bool matchend);
  vector<ustring> highlight_words;
  vector<bool> highlight_casesensitives;
  vector<bool> highlight_globbings;
  vector<bool> highlight_matchbegins;
  vector<bool> highlight_matchends;
  // Import.
  vector <ustring> import_references_searchwords;
  // Entry completion.
  vector<ustring> completion_search;
  vector<ustring> completion_replace;
  vector<ustring> completion_goto;
  // Checks.
  CheckMarkerCountType checkmarkercounttype;
  CheckCharactersCountType checkcharacterscounttype;
  // Area selection.
  AreaType area_type;
  bool area_id;
  bool area_intro;
  bool area_heading;
  bool area_chapter;
  bool area_study;
  bool area_notes;
  bool area_xref;
  bool area_verse;
private:
};


#endif
