/*
 ** Copyright (C) 2003-2006 Teus Benschop.
 **  
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation; either version 2 of the License, or
 ** (at your option) any later version.
 **  
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **  
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software
 ** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 **  
 */


#include "libraries.h"
#include "utilities.h"
#include <libgen.h>
#include <glib.h>
#include <config.h>
#include "constants.h"
#include "projectutils.h"
#include "project.h"
#include "directories.h"
#include "gwrappers.h"
#include "indexer.h"
#include "shell.h"


void projectutils_new (Configuration * configuration)
{
  /*
     This makes a new project.
     It is named "New Project".
     This project can later be tuned to the user's wishes.
   */
  // Make the new directory.
  ustring directory = gw_build_filename (directories_get_projects (), NEW_PROJECT);
  create_directory (directory);
  // Produce the default settings.
  Project ps (configuration);
}


ustring projectutils_scripture_filename (const ustring & project, const ustring & book)
{
  return gw_build_filename (directories_get_projects (), project, book, "current-version");
}


void projectutils_copy_project (const ustring& project, const ustring& newproject)
// Copies "project" to "newproject.
{
  ustring olddirectory;
  olddirectory = gw_build_filename (directories_get_projects (), project);
  ustring newdirectory;
  newdirectory = gw_build_filename (directories_get_projects (), newproject);
  ustring command;
  command = "cp -r";
  command.append (shell_quote_space (olddirectory));
  command.append (shell_quote_space (newdirectory));
  system (command.c_str());
}


void projectutils_delete_project (const ustring& project)
// Deletes a project.
{
  ustring directory = gw_build_filename (directories_get_projects (), project);
  remove_directory (directory);
  // Also delete associated index.
  Indexer worddatabase (0);
  unlink (worddatabase.dbfilename (project).c_str());
}
