/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/

#ifndef INCLUDED_PROJECT_H
#define INCLUDED_PROJECT_H


#include "libraries.h"
#include "configuration.h"


class Project
/*
Manages project settings.
*/
{
public:
  Project (Configuration * configuration);
  Project (const ustring& project);
  ~Project ();
  ustring editor_font;
  ustring get_stylesheet ();
  void set_stylesheet (const ustring& stylesheet);
  ustring versification;
  vector<ustring> printing_fonts;
  ustring sword_name;
  ustring sword_description;
  ustring sword_about;
  ustring sword_lcsh;
  ustring sword_license;
  ustring sword_version;
  ustring sword_language;
  void reordering_read ();
  void reordering_write ();
  bool reordering_in_order ();
  bool reordering_portions_all ();
  vector<ustring> reordered_books;
  vector<bool> reordered_includes;
  vector<ustring> reordered_portions;
private:
  ustring projectname;
  ustring filename;
  ustring mystylesheet;
  ustring printing_fonts_filename ();
  ustring books_reordering_filename ();
  Configuration * myconfiguration;
  void project_load ();
};


#endif
