/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/

#ifndef INCLUDED_NAVIGATION_H
#define INCLUDED_NAVIGATION_H


#include "libraries.h"
#include <glib.h>
#include <gtk/gtk.h>
#include "scripture.h"
#include "configuration.h"
#include "bookmetrics.h"


class Navigation
{
public:
  Navigation (GtkWidget * bookcombo, GtkWidget * chaptercombo, GtkWidget * versecombo,
              Scripture * scripture, bool * settingcombos, Configuration * configuration);
  ~Navigation ();
  void nextbook ();
  void previousbook ();
  void nextchapter ();
  void previouschapter ();
  void nextverse ();
  void previousverse ();
  void gotobook ();
  void gotochapter ();
  void gotoverse ();
  void gotoversenumber (const ustring& versenumber);
  void gotoreference (const ustring& bookname, const ustring& chapternumber, const ustring& versenumber);
  bool changed;
  ustring book, chapter, verse;
private:
  void store_variables ();
  GtkWidget * mybookcombo;
  GtkWidget * mychaptercombo;
  GtkWidget * myversecombo;
  Scripture * myscripture;
  Configuration * myconfiguration;
  bool * mysettingcombos;
  bool anotherbook;
  bool anotherchapter;
  void crossboundariesverse (bool forward);
  void crossboundarieschapter (bool forward);
  void set_combos ();
  void store_in_configuration ();
  void polish_up_verse (BookMetrics & bookmetrics);
};



#endif
