/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#ifndef INCLUDED_LAYOUT_H
#define INCLUDED_LAYOUT_H


#include "libraries.h"
#include <gtk/gtk.h>
#include "configuration.h"


void screen_layout_tools_area_set (bool current_pos, Configuration * configuration, 
                                   GtkWidget * parentleft, GtkWidget * parentright, 
                                   GtkWidget * childleft, GtkWidget * childright);
void screen_layout_vertical_pane_mirror (bool current_pos, Configuration * configuration, GtkWidget * pane);
void screen_layout_window_size_save (Configuration * configuration, GtkWidget * window);
void screen_layout_window_size_load (Configuration * configuration, GtkWidget * window);
void screen_layout_panes_position_save (Configuration * configuration, 
     GtkWidget * hpane, GtkWidget * editor, GtkWidget * footnotes, GtkWidget * references);
void screen_layout_panes_position_load (Configuration * configuration, 
     GtkWidget * hpane, GtkWidget * editor, GtkWidget * footnotes, GtkWidget * references);
     

#endif
