/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#ifndef INCLUDED_EDITOR_H
#define INCLUDED_EDITOR_H


#include "libraries.h"
#include <glib.h>
#include <gtk/gtk.h>
#include "configuration.h"
#include "book.h"
#include "editorobject.h"
#include "indexer.h"


class Editor
{
public:
  Editor (int dummy); 
  ~Editor ();
  void textview_text_set (GtkWidget * textview);
  void textview_notes_set (GtkWidget * textview);
  void chapter_load (Configuration * configuration, Book * book, unsigned int number, vector<ustring> * lines);
  void chapter_save (Configuration * configuration, Book * book, Indexer * indexer);
  void footnote_body_scroll_to ();
  void footnote_caller_scroll_to ();
  bool footnote_caller_remove (Configuration * configuration, bool backspace);
  ustring text_get_selection ();
  ustring text_get_all ();
  void format (Configuration * configuration);
  GtkWidget * textview_text;
  GtkTextBuffer * textbuffer_text;
  GtkTextTag * text_line_tag;
  GtkWidget * textview_notes;
  GtkTextBuffer * textbuffer_notes;
  GtkTextTag * notes_line_tag;
  vector<EditorObject> editorobjects;
private:
  void load_text (vector<ustring> & lines);
  void format_notes (Configuration * configuration);
  ustring text_get (GtkTextIter * startiter, GtkTextIter * enditer);
  ustring text_note_get (gint id);
  map <int, ustring> text_note_get_all ();
};


#endif
