/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#ifndef INCLUDED_DIALOGSTYLESHEET_H
#define INCLUDED_DIALOGSTYLESHEET_H


#include <gtk/gtk.h>
#include "configuration.h"
#include "style.h"


class StylesheetDialog
{
public:
  StylesheetDialog (const ustring& stylesheet, const ustring& style);
  virtual ~ StylesheetDialog ();
  virtual int run ();
  ustring name;
protected:
  ustring mystylesheet;
  ustring mystyle;
private:
  GtkWidget *stylesheetdialog;
  GtkWidget *dialog_vbox1;
  GtkWidget *vbox1;
  GtkWidget *vbox2;
  GtkWidget *hbox1;
  GtkWidget *label6;
  GtkWidget *labelstyle;
  GtkWidget *label37;
  GtkWidget *entryname;
  GtkWidget *label36;
  GtkWidget *scrolledwindow1;
  GtkWidget *textview1;
  GtkWidget *hseparator1;
  GtkWidget *hbox8;
  GtkWidget *vbox5;
  GtkWidget *label21;
  GtkWidget *vbox3;
  GtkWidget *radiobutton_id;
  GtkWidget *radiobutton_comment;
  GtkWidget *radiobutton_runningheader;
  GtkWidget *radiobutton_paragraph;
  GtkWidget *radiobutton_inline;
  GtkWidget *radiobutton_chapter;
  GtkWidget *radiobutton_verse;
  GtkWidget *radiobutton_footendnote;
  GtkWidget *radiobutton_crossreference;
  GtkWidget *vseparator1;
  GtkWidget *notebook_subtype;
  GtkWidget *empty_notebook_page;
  GtkWidget *label47;
  GtkWidget *vbox8;
  GtkWidget *label50;
  GtkWidget *radiobutton_footnote;
  GtkWidget *radiobutton_endnote;
  GtkWidget *radiobutton_note_content_standard;
  GtkWidget *radiobutton_note_content;
  GtkWidget *radiobutton_note_content_endmarker;
  GtkWidget *radiobutton_note_paragraph;
  GtkWidget *label48;
  GtkWidget *vbox9;
  GtkWidget *label51;
  GtkWidget *radiobutton_xref;
  GtkWidget *radiobutton_xref_content_standard;
  GtkWidget *radiobutton_xref_content;
  GtkWidget *radiobutton_xref_content_endmarker;
  GtkWidget *label49;
  GtkWidget *vbox13;
  GtkWidget *label55;
  GtkWidget *radiobutton_paragraph_type_main_title;
  GtkWidget *radiobutton_paragraph_type_subtitle;
  GtkWidget *radiobutton_paragraph_type_section_heading;
  GtkWidget *radiobutton_paragraph_type_text;
  GtkWidget *label54;
  GtkWidget *vseparator2;
  GtkWidget *vbox6;

  // Fontsize in points.
  GtkWidget *hbox2;
  GtkWidget *label8;
  GtkObject *spinbuttonfontsize_adj;
  GtkWidget *spinbuttonfontsize;
  GtkWidget *label9;
  virtual void fontsize_points_create ();
  double fontsize_points;

  // Fontsize in percentages.
  GtkWidget *hbox6;
  GtkWidget *label31;
  GtkObject *spinbuttonfontpercentage_adj;
  GtkWidget *spinbuttonfontpercentage;
  GtkWidget *label32;
  virtual void fontsize_percentage_create ();
  int fontsize_percentage;

  // Italic
  ustring italic;
  GtkWidget *checkbutton_italic;
  virtual void italic_simple_create ();
  
  // Bold
  ustring bold;
  GtkWidget *checkbutton_bold;
  virtual void bold_simple_create ();
  
  // Underline
  ustring underline;
  GtkWidget *checkbutton_underline;
  virtual void underline_simple_create ();
  
  // Small caps
  ustring smallcaps;
  GtkWidget *checkbutton_small_caps;
  virtual void smallcaps_simple_create ();

  // Italic, bold, underline, small caps - extended.
  GtkWidget *table2;
  GtkWidget *label40;
  GtkWidget *label41;
  GtkWidget *label42;
  GtkWidget *radiobutton_italics_on;
  GtkWidget *radiobutton_bold_on;
  GtkWidget *radiobutton_underline_on;
  GtkWidget *radiobutton_italics_toggle;
  GtkWidget *radiobutton_bold_toggle;
  GtkWidget *radiobutton_underline_toggle;
  GtkWidget *radiobutton_italics_inherit;
  GtkWidget *radiobutton_bold_inherit;
  GtkWidget *radiobutton_underline_inherit;
  GtkWidget *radiobutton_italics_off;
  GtkWidget *radiobutton_bold_off;
  GtkWidget *radiobutton_underline_off;
  GtkWidget *label_small_caps;
  GtkWidget *radiobutton_small_caps_off;
  GtkWidget *radiobutton_small_caps_on;
  GtkWidget *radiobutton_small_caps_inherit;
  GtkWidget *radiobutton_small_caps_toggle;
  virtual void italic_bold_underline_smallcaps_extended_create ();

  // Superscript
  GtkWidget *checkbutton_superscript;
  bool superscript;
  virtual void superscript_create ();

  // Paragraph
  GtkWidget *vbox4;
  GtkWidget *hbox4;
  GtkWidget *label10;
  GtkWidget *radiobutton_left;
  GtkWidget *radiobutton_center;
  GtkWidget *radiobutton_right;
  GtkWidget *radiobutton_full;
  GtkWidget *table1;
  GtkWidget *label11;
  GtkWidget *label12;
  GtkWidget *label13;
  GtkWidget *label14;
  GtkWidget *label15;
  GtkWidget *label16;
  GtkWidget *label17;
  GtkWidget *label18;
  GtkWidget *label19;
  GtkWidget *label20;
  GtkObject *spinbutton_first_adj;
  GtkWidget *spinbutton_first;
  GtkObject *spinbutton_before_adj;
  GtkWidget *spinbutton_before;
  GtkObject *spinbutton_after_adj;
  GtkWidget *spinbutton_after;
  GtkObject *spinbutton_left_adj;
  GtkWidget *spinbutton_left;
  GtkObject *spinbutton_right_adj;
  GtkWidget *spinbutton_right;
  ustring justification;
  double spacebefore;
  double spaceafter;
  double leftmargin;
  double rightmargin;
  double firstlineindent;
  virtual void paragraph_create ();

  // Span columns.
  GtkWidget *checkbutton_span;
  bool spancolumns;
  virtual void span_columns_create ();
  
  // Apocrypha
  GtkWidget *checkbutton_apocrypha;
  virtual void apocrypha_create ();

  // Note numbering type.
  GtkWidget *vbox10;
  GtkWidget *hbox9;
  GtkWidget *label52;
  GtkWidget *vbox11;
  GtkWidget *radiobutton_note_numbering_1;
  GtkWidget *radiobutton_note_numbering_a;
  GtkWidget *radiobutton_note_numbering_user;
  GtkWidget *entry_note_numbering;
  virtual void note_numbering_type_create ();
  
  // Note numbering restart.
  GtkWidget *hbox10;
  GtkWidget *label53;
  GtkWidget *vbox12;
  GtkWidget *radiobutton_note_numbering_restart_never;
  GtkWidget *radiobutton_note_numbering_restart_book;
  GtkWidget *radiobutton_note_numbering_restart_chapter;
  GtkWidget *radiobutton_note_numbering_restart_page;
  virtual void note_numering_restart_create ();
  
  // Double space for note caller.
  GtkWidget *checkbutton_notecaller_spacious;
  virtual void note_caller_spacious_create ();

  // Action area.
  GtkWidget *dialog_action_area1;
  GtkWidget *cancelbutton1;
  GtkWidget *okbutton;
  
  // User variables.
  bool userbool1, userbool2, userbool3;
  int userint1, userint2, userint3;
  ustring userstring1, userstring2, userstring3;
  
  static void on_okbutton_clicked (GtkButton *button, gpointer user_data);
  virtual void on_ok();
  static void on_style_type_toggled (GtkToggleButton *togglebutton, gpointer user_data);
  virtual void on_style_type (GtkToggleButton *togglebutton);
  static void on_alignment_toggled (GtkToggleButton *togglebutton, gpointer user_data);
  virtual void on_alignment (GtkToggleButton *togglebutton);
  virtual void set_gui ();
  virtual void save_style ();
  virtual void set_justification (const ustring& justification);
  virtual ustring get_justification ();
  virtual void set_italic ();
  virtual ustring get_italic ();
  virtual void set_bold ();
  virtual ustring get_bold ();
  virtual void set_underline ();
  virtual ustring get_underline ();
  virtual void set_small_caps ();
  virtual ustring get_small_caps ();
  virtual StyleType get_styletype ();
  static void on_radiobutton_italic_toggled (GtkToggleButton *togglebutton, gpointer user_data);
  virtual void on_radiobutton_italic (GtkWidget *togglebutton);
  static void on_radiobutton_bold_toggled (GtkToggleButton *togglebutton, gpointer user_data);
  virtual void on_radiobutton_bold (GtkWidget *togglebutton);
  static void on_radiobutton_underline_toggled (GtkToggleButton *togglebutton, gpointer user_data);
  virtual void on_radiobutton_underline (GtkWidget *togglebutton);
  static void on_radiobutton_small_caps_toggled (GtkToggleButton *togglebutton, gpointer user_data);
  virtual void on_radiobutton_small_caps (GtkWidget *togglebutton);
  virtual void set_subtype (StyleType maintype, int subtype);
  virtual int get_subtype ();
  static void on_radiobutton_note_toggled (GtkToggleButton *togglebutton, gpointer user_data);
  virtual void on_radiobutton_note ();
  static void on_radiobutton_xref_toggled (GtkToggleButton *togglebutton, gpointer user_data);
  virtual void on_radiobutton_xref ();
  virtual void destroy_optional_widgets ();
  static void on_radiobutton_note_numbering_toggled (GtkToggleButton *togglebutton, gpointer user_data);
  virtual void on_radiobutton_note_numbering ();
};


#endif
