/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#ifndef INCLUDED_CONFIGURATION_H
#define INCLUDED_CONFIGURATION_H


#include "libraries.h"
#include <gtk/gtk.h>
#include "constants.h"


enum ShowNotesSelector {snsCurrentVerse, snsToday, snsAll, snsCategory, snsDateRange};


class Configuration
{
  // Manages stored program settings.
public:
  Configuration (GtkWindow *window);
  virtual ~Configuration ();
  vector<ustring> printing_fonts_get ();
  void printing_fonts_set (vector<ustring>& fonts);
  vector<ustring> parallel_bible_projects_get ();
  void parallel_bible_projects_set (vector<ustring>& projects);
  ustring edit_note_standard_text_one;
  ustring edit_note_standard_text_two;
  ustring edit_note_standard_text_three;
  int window_width;
  int window_height;
  int window_x_position;
  int window_y_position;
  int hpane_position;
  int vpane_editor_position;
  int vpane_footnotes_position;
  int vpane_references_position;
  bool tools_area_left;
  ustring book_opened;
  ustring chapter_opened;
  ustring verse_opened;
  ustring edit_note_standard_text_four;
  ustring references_file;
  ustring export_to_bibleworks_filename;
  ustring export_to_sword_module_path;
  ustring export_to_sword_install_path;
  ustring editor_font_name;
  ustring project;
  ustring paper_format;
  double paper_width;
  double paper_height;
  double paper_left_margin;
  double paper_right_margin;
  double paper_top_margin;
  double paper_bottom_margin;
  ustring java_binary;
  bool printcoverpage;
  bool printdate;
  bool print_changes_only;
  ustring project_to_compare_with;
  bool show_notes_for_current_project_only;
  bool notes_show_project;
  ustring xep_home;
  ShowNotesSelector show_notes_selector;
  ustring show_notes_category;
  int show_notes_date_range_from;
  int show_notes_date_range_to;
  ustring bibleworks_executable;
  bool reference_exchange_send_to_bibleworks;
  bool reference_exchange_receive_from_bibleworks;
  bool reference_exchange_send_to_bibletime;
  bool reference_exchange_receive_from_bibletime;
  bool reference_exchange_send_to_santafefocus;
  bool reference_exchange_receive_from_santafefocus;
  ustring check_markers_compare_project;
  bool check_markers_compare_all_markers;
  string check_markers_compare_include_only;
  string check_markers_compare_ignore;
  bool check_markers_compare_ignore_verse_zero;
  ustring check_capitalization_punctuation;
  ustring check_capitalization_ignore;
  bool check_capitalization_allow_any_prefixes;
  bool check_repetition_ignore_case;
  bool check_repetition_show_only_these;
  bool check_repetition_ignore_these;
  ustring check_matching_pairs_ignore;
  unsigned int tools_area_page_number;
  ustring stylesheet;
  bool category_expanded_0;
  bool category_expanded_1;
  bool category_expanded_2a;
  bool category_expanded_3;
  bool category_expanded_4;
  bool category_expanded_5;
  bool category_expanded_6;
  bool category_expanded_7;
  bool category_expanded_8;
  bool category_expanded_9;
  bool category_expanded_10;
  bool category_expanded_11;
  bool category_expanded_12;
  bool category_expanded_13;
  bool print_high_quality;
  bool category_expanded_2b;
  bool category_expanded_2c;
  bool notes_print_full_page_width;
  ustring insert_footnote_template;
  ustring insert_endnote_template;
  ustring insert_xref_template;
  bool parallel_bible_keep_verses_together;
  ustring parallel_bible_chapters_verses;
  bool parallel_bible_include_verse_zero;
private:
  ustring bibleditrc ();
  ustring fontfilename ();
  ustring parallel_bible_projects_filename ();
  ustring configurationfilename ();
  int screen_width;
  int screen_height;
  bool screen_resolution_changed;
  ustring current_element;
  ustring current_value;
  static void start_element_handler  (GMarkupParseContext *context,
                                      const gchar         *element_name,
                                      const gchar        **attribute_names,
                                      const gchar        **attribute_values,
                                      gpointer             user_data,
                                      GError             **error);
  virtual void start_element_handler (const ustring& element_name);
  static void end_element_handler    (GMarkupParseContext *context,
                                      const gchar         *element_name,
                                      gpointer             user_data,
                                      GError             **error);
  virtual void end_element_handler   (const ustring& element_name);
  static void text_handler           (GMarkupParseContext *context,
                                      const gchar         *text,
                                      gsize                text_len,
                                      gpointer             user_data,
                                      GError             **error);
  virtual void text_handler          (const ustring& text);
  static void passthrough_handler    (GMarkupParseContext *context,
                                      const gchar         *passthrough_text,
                                      gsize                text_len,
                                      gpointer             user_data,
                                      GError             **error);
  static void error_handler          (GMarkupParseContext *context,
                                      GError              *error,
                                      gpointer             user_data);
};


#endif
