/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "libraries.h"
#include "utilities.h"
#include "backup.h"
#include <time.h>


Backup::Backup(int dummy)
//: today (10000)
{
  clear();
}


Backup::~Backup()
{
}


void Backup::clear()
{
//  backup_directory.clear ();
//  backups.clear ();
//  today.clear ();
}


/*
void Backup::load (const ustring & directory, vector <ustring> &filenames)
{ */
  /*
     This function sets the backups that are produced by another object.
   */
  // Clear any data.
/*
  clear ();
  // Store the directory
  backup_directory = directory;
  // Define some types for later use.
  typedef list < ustring > list;
  typedef list::iterator iter;
  // Put all the names in the list (this list is needed to sort them).
  list names;
  for (unsigned int i = 0; i < filenames.size (); i++)
    {
      names.push_back (filenames[i]);
    }
  // Sort them (it'll be done in ascending order)
  names.sort ();
  // Put the names in the vector, and at the same time invert their order.
  // Youngest backup first, oldest last.
  for (iter i = names.end (); i != names.begin ();)
    {
      i--;
      backups.push_back (*i);
    }
  // Get the current date
  FILE *stream;
  char buf[1024];
  stream = popen ("date +%b%t%d%t%G", "r");
  fgets (buf, sizeof (buf), stream);
  ustring current_date = buf;
  current_date = trim (current_date);
  pclose (stream);
  today.set_parse (current_date);
}


unsigned int Backup::size ()
{
  return backups.size ();
}


ustring Backup::get_full_name (const ustring & friendly_name)
{
  for (unsigned int i = 0; i < backups.size (); i++)
    if (friendly_name == get_friendly_name (i))
      return Gxlib::build_filename (backup_directory, backups[i]);
  return "";
}

ustring Backup::get_friendly_name (unsigned int index)
{
  // Get the filename and extract the date from it.
  ustring s = backups[index];
  Gxlib::Date backupdate (10000);
  backupdate.set_dmy (extract_day (s), extract_month (s), extract_year (s));
  ustring returnvalue;
  // Transform the date in a friendly form.
  int daysbetween = backupdate.days_between (today);
  switch (daysbetween)
    {
    case 0:
      {
        returnvalue = "Today at " + s.substr (11, 5);
        break;
      };
    case 1:
      {
        returnvalue = "Yesterday at " + s.substr (11, 5);
        break;
      }
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
      {
        returnvalue =
          convert_weekday (backupdate.get_weekday ()) + " at " + s.substr (11,
                                                                           5);
        break;
      }
    default:
      {
        returnvalue = s.substr (8, 2) + "-" + s.substr (5, 2);
        if (today.get_year () != backupdate.get_year ())
          returnvalue = returnvalue + " " + s.substr (0, 4);
        returnvalue = returnvalue + " at " + s.substr (11, 5);
        break;
      }
    }
  return returnvalue;
}


ustring Backup::convert_weekday (Gxlib::Date::Weekday weekday)
{
  switch (weekday)
    {
    case Gxlib::Date::BAD_WEEKDAY:
      return "Unknown day";
    case Gxlib::Date::MONDAY:
      return "Monday";
    case Gxlib::Date::TUESDAY:
      return "Tuesday";
    case Gxlib::Date::WEDNESDAY:
      return "Wednesday";
    case Gxlib::Date::THURSDAY:
      return "Thursday";
    case Gxlib::Date::FRIDAY:
      return "Friday";
    case Gxlib::Date::SATURDAY:
      return "Saturday";
    case Gxlib::Date::SUNDAY:
      return "Sunday";
    }
  return "";
}


void Backup::sort_out_old_backups ()
{ */
  /*
     This function sorts out the old backups.
     It deletes backups that are no longer relevant,
     and keeps the rest.
   */
/*
  // Make space to sort the names depending on their age.
  typedef vector < ustring > storage;
  storage names1;
  storage names2;
  storage names3;
  storage names4;
  storage names5;
  storage names6;
  storage names7;
  storage names8;
  storage names9;
  storage names10;
  storage names11;
  // Sort the filenames out, depending on their dates, and put them in the right groups.
  for (unsigned int i = 0; i < backups.size (); i++)
    {
      ustring s = backups[i];
      Gxlib::Date backupdate (10000);
      backupdate.set_dmy (extract_day (s), extract_month (s),
                          extract_year (s));
      int daysbetween = backupdate.days_between (today);
      if (daysbetween == 8)
        {
          names1.push_back (s);
        }
      else if (daysbetween == 9)
        {
          names2.push_back (s);
        }
      else if (daysbetween == 10)
        {
          names3.push_back (s);
        }
      else if (daysbetween == 11)
        {
          names4.push_back (s);
        }
      else if (daysbetween == 12)
        {
          names5.push_back (s);
        }
      else if (daysbetween == 13)
        {
          names6.push_back (s);
        }
      else if (daysbetween == 14)
        {
          names7.push_back (s);
        }
      else if ((daysbetween >= 15) && (daysbetween <= 30))
        {
          names8.push_back (s);
        }
      else if ((daysbetween >= 31) && (daysbetween <= 60))
        {
          names9.push_back (s);
        }
      else if ((daysbetween >= 61) && (daysbetween <= 100))
        {
          names10.push_back (s);
        }
      else if ((daysbetween >= 101) && (daysbetween <= 200))
        {
          names11.push_back (s);
        }
    }
  // Go through all the groups, and remove any filename, except the first and the last.
  for (unsigned int i = 1; i < names1.size () - 1; i++)
    unlink (Gxlib::build_filename (backup_directory, names1[i]).c_str ());
  for (unsigned int i = 1; i < names1.size () - 1; i++)
    unlink (Gxlib::build_filename (backup_directory, names1[i]).c_str ());
  for (unsigned int i = 1; i < names2.size () - 1; i++)
    unlink (Gxlib::build_filename (backup_directory, names2[i]).c_str ());
  for (unsigned int i = 1; i < names3.size () - 1; i++)
    unlink (Gxlib::build_filename (backup_directory, names3[i]).c_str ());
  for (unsigned int i = 1; i < names4.size () - 1; i++)
    unlink (Gxlib::build_filename (backup_directory, names4[i]).c_str ());
  for (unsigned int i = 1; i < names5.size () - 1; i++)
    unlink (Gxlib::build_filename (backup_directory, names5[i]).c_str ());
  for (unsigned int i = 1; i < names6.size () - 1; i++)
    unlink (Gxlib::build_filename (backup_directory, names6[i]).c_str ());
  for (unsigned int i = 1; i < names7.size () - 1; i++)
    unlink (Gxlib::build_filename (backup_directory, names7[i]).c_str ());
  for (unsigned int i = 1; i < names8.size () - 1; i++)
    unlink (Gxlib::build_filename (backup_directory, names8[i]).c_str ());
  for (unsigned int i = 1; i < names9.size () - 1; i++)
    unlink (Gxlib::build_filename (backup_directory, names9[i]).c_str ());
  for (unsigned int i = 1; i < names10.size () - 1; i++)
    unlink (Gxlib::build_filename (backup_directory, names10[i]).c_str ());
  for (unsigned int i = 1; i < names11.size () - 1; i++)
    unlink (Gxlib::build_filename (backup_directory, names11[i]).c_str ());
}


Gxlib::Date::Year Backup::extract_year (const ustring & filename)
{
  return convert_to_int (number_in_string (filename));
}


Gxlib::Date::Month Backup::extract_month (const ustring & filename)
{
  Gxlib::Date::Month returnvalue = Gxlib::Date::BAD_MONTH;
  if (filename.length () >= 7)
    {
      ustring s = filename.substr (5, 2);
      int i = convert_to_int (s);
      returnvalue = Gxlib::Date::Month (i);
    }
  return returnvalue;
}


Gxlib::Date::Day Backup::extract_day (const ustring & filename)
{
  Gxlib::Date::Day returnvalue = Gxlib::Date::BAD_WEEKDAY;
  if (filename.length () >= 10)
    {
      ustring s = filename.substr (8, 2);
      int i = convert_to_int (s);
      returnvalue = Gxlib::Date::Day (i);
    }
  return returnvalue;
}

*/
