/* Anti-Web HTTPD */
/* Hardcore Software */
/*
This software is Copyright (C) 2001-2004 By Hardcore Software and
others. The software is distributed under the terms of the GNU General
Public License. See the file 'COPYING' for more details.
*/


#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "aw3.h"




void nada() { }


void die() {
  exit(0);
}


void stripcrlf(char *p) {

  while (p && *p) {
    if (*p=='\n' || *p=='\r') {
      *p='\0';
      return;
    }
    p++;
  }

}


int iscgi(char *fn) {

  struct cgiextstruct *tp;
  int fnlen, extlen;

  fnlen = strlen(fn);
  tp = cgiexts;

  while (tp != NULL) {
    extlen = strlen(tp->ext);

    if (strcasecmp(fn+(fnlen-extlen), tp->ext) == 0)
      return 1;

    tp = tp->next;
  }

  return 0;

}



int split(char *tp, char *sp[], int maxwords, char sc) {

  int i=0;

  while(1) {
    /* Skip leading whitespace */
    while(*tp == sc) tp++;

    if (*tp == '\0') {
      sp[i] = NULL;
      break;
    }
    if (i==maxwords-2) {
      sp[maxwords-1] = NULL;
      break;
    }

    sp[i] = tp;

    while(*tp != sc && *tp != '\0') tp++;
    if (*tp == sc) *tp++ = '\0';
    i++;

  }

  return i;

}



int confsplit(char *tp, char *sp[], int maxwords) {

  int i;

  // Skip comments
  i=0;
  while (tp[i] != '\0' && tp[i] != '#') i++;
  tp[i] = '\0';

  i=0;
  while(1) {
    /* Skip leading whitespace */
    while(*tp == ' ') tp++;

    if (*tp == '\0') {
      sp[i] = NULL;
      break;
    }
    if (i==maxwords-2) {
      sp[maxwords-1] = NULL;
      break;
    }

    if (*tp == '"') {
      tp++;

      if (*tp == '"') {
        tp++;
        continue;
      }

      sp[i] = tp;

      while(*tp != '"' && *tp != '\0') tp++;
      if (*tp == '"') *tp++ = '\0';
      i++;

    } else {
      sp[i] = tp;

      while(*tp != ' ' && *tp != '\0') tp++;
      if (*tp == ' ') *tp++ = '\0';
      i++;
    }

  }

  return i;

}





int sanitizefile(char *buf) {

  int len,i;

  // Don't accept anything not starting with a /
  if (*buf != '/') return 0;

  len = strlen(buf);
  for(i=0; i<len; i++) {
    // Check for "/." : In other words, don't send files starting with a .
    // Notice, GOBBLES, that this includes ".."
    if (buf[i] == '/' && buf[i+1] == '.') return 0;

    // Give people a "hidden prefix" for hiding private files in the HTML tree
    if (strncmp(buf+i, "/aw_", 4) == 0) return 0;
  }

  return 1;

}



int sanitizehost(char *buf) {

  while(*buf != '\0') {

    // Handle the port
    if (*buf == ':') {
      *buf = '\0';
      return 1;
    }

    // Enforce some basic URL rules...
    if (isalnum(*buf)==0 && *buf != '-' && *buf != '.') return 0;
    if (*buf == '.' && *(buf+1) == '.') return 0;
    if (*buf == '.' && *(buf+1) == '-') return 0;
    if (*buf == '-' && *(buf+1) == '.') return 0;
    buf++;
  }

  return 1;

}



void buildactualfile(struct connstruct *cn) {

  char tpbuf[MAXREQUESTLENGTH];

  if (usevirtualhosts) {
    if (*(cn->virtualhostreq) == '\0')
      strncpy(cn->virtualhostreq, "default", MAXREQUESTLENGTH);

    snprintf(tpbuf, sizeof(tpbuf), "%s/%s", webroot, cn->virtualhostreq);
    if (isdir(tpbuf) == 0) {
      strncpy(cn->virtualhostreq, "default", MAXREQUESTLENGTH);
    }
  } else {
    *(cn->virtualhostreq) = '\0';
  }

  snprintf(cn->actualfile, MAXREQUESTLENGTH, "%s/%s%s",
           webroot,
           cn->virtualhostreq,
           cn->filereq);

  return;

}


int issockwriteable(int sd) {

  fd_set wfds;
  struct timeval tv;

  tv.tv_sec = 0;
  tv.tv_usec = 0;

  FD_ZERO(&wfds);
  FD_SET(sd, &wfds);

  select(FD_SETSIZE, NULL, &wfds, NULL, &tv);

  return FD_ISSET(sd, &wfds);

}


int isdir(char *tpbuf) {

  static struct stat st;

  if (stat(tpbuf, &st) == -1) return 0;

  if ((st.st_mode & S_IFMT) == S_IFDIR) return 1;
  return 0;

}



// FIXME: Arg! This function is horrible! Rewrite it
void status() {

  int i;

  fprintf(stdout," [*************************************************]\n");
  fprintf(stdout," [       Anti-Web V%-6s by Hardcore Software     ]\n",VERSION);
  fprintf(stdout," [*************************************************]\n");
  fprintf(stdout," [  DIRECTORY {%s}",webroot);
  if(strlen(webroot)<35)
    for(i=1;i<=35-strlen(webroot);i++) fprintf(stdout," ");
  fprintf(stdout,"]\n");
  fprintf(stdout," [*************************************************]\n");

}
