#include <string.h>
#include "dns.h"
#include "uint16.h"

void dns_header_pack(const struct dns_header* hdr, uint8 pkt[12])
{
  uint16_pack_msb(hdr->id, pkt);
  pkt[2] = ((hdr->qr & 1) << 7) +
    /* (hdr->opcode & 0xf) << 3 + */
    ((hdr->aa & 1) << 2) +
    ((hdr->tc & 1) << 1) +
    (hdr->rd & 1);
  pkt[3] = ((hdr->ra & 1) << 7) +
    /* ((hdr->z & 7) << 4) + */
    (hdr->rcode & 0xf);
  uint16_pack_msb(hdr->qdcount, pkt+4);
  uint16_pack_msb(hdr->ancount, pkt+6);
  uint16_pack_msb(hdr->nscount, pkt+8);
  uint16_pack_msb(hdr->arcount, pkt+10);
}

void dns_header_unpack(const uint8 pkt[12], struct dns_header* hdr)
{
  uint16 t16;
  memset(hdr, 0, sizeof *hdr);
  uint16_unpack_msb(pkt, &t16); hdr->id = t16;
  hdr->qr = (pkt[2] >> 7) & 1;
  /* hdr->opcode = (pkt[2] >> 3) & 0xf; */
  hdr->aa = (pkt[2] >> 2) & 1;
  hdr->tc = (pkt[2] >> 1) & 1;
  hdr->rd = pkt[2] & 1;
  hdr->ra = (pkt[3] >> 7) & 1;
  /* hdr->z = (pkt[3] >> 4) & 7; */
  hdr->rcode = pkt[3] & 0xf;
  uint16_unpack_msb(pkt+4, &t16); hdr->qdcount = t16;
  uint16_unpack_msb(pkt+6, &t16); hdr->ancount = t16;
  uint16_unpack_msb(pkt+8, &t16); hdr->nscount = t16;
  uint16_unpack_msb(pkt+10, &t16); hdr->arcount = t16;
}
