/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef SERVERREACHABILITY_H_
#define SERVERREACHABILITY_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

class ServerReachability
{
public:
	enum ConnectResult { UNDEFINED, CONNECTED, FAILED };
	
	ServerReachability() : m_connectTime(0), m_connectResult(UNDEFINED) {}
	
	ServerReachability(unsigned long conn_time_ms, ConnectResult conn_res)
	: m_connectTime(conn_time_ms), m_connectResult(conn_res) {}
	
	unsigned long getConnectTime() const { return m_connectTime; }
	
	ConnectResult getConnectResult() const { return m_connectResult; }
private:
	unsigned long m_connectTime; // time spent waiting for connection, msec
	ConnectResult m_connectResult;
};

#endif
