/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef HTTPVERSION_H_
#define HTTPVERSION_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iosfwd>

class HttpVersion
{
public:
	static HttpVersion const HTTP_0_9;
	static HttpVersion const HTTP_1_0;
	static HttpVersion const HTTP_1_1;
	
	HttpVersion(int major, int minor) : m_major(major), m_minor(minor) {}
	
	int getMajor() const { return m_major; }
	
	int getMinor() const { return m_minor; }
	
	void set(int major, int minor) { m_major = major; m_minor = minor; }
	
	void toStream(std::ostream& strm) const;
	
	bool parse(char const* begin, char const* end);
	
	bool operator==(const HttpVersion& other) const;
	
	bool operator!=(const HttpVersion& other) const;
	
	bool operator<(const HttpVersion& other) const;
	
	bool operator>(const HttpVersion& other) const;
	
	bool operator>=(const HttpVersion& other) const;
	
	bool operator<=(const HttpVersion& other) const;
private:
	int m_major;
	int m_minor;
};


inline std::ostream&
operator<<(std::ostream& strm, HttpVersion const& http_version)
{
	http_version.toStream(strm);
	return strm;
}

inline bool
HttpVersion::operator==(HttpVersion const& other) const
{
	return (m_major == other.m_major && m_minor == other.m_minor);
}

inline bool
HttpVersion::operator!=(HttpVersion const& other) const
{
	return !(*this == other);
}

inline bool
HttpVersion::operator>=(HttpVersion const& other) const
{
	return (*this == other || *this > other);
}

inline bool
HttpVersion::operator<=(HttpVersion const& other) const
{
	return (*this == other || *this < other);
}

#endif
