/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "HttpHeaderElement.h"
#include "InsensitiveEqual.h"

using namespace std;

HttpHeaderElement::HttpHeaderElement(BString const& name)
:	m_name(name),
	m_isNullValue(true)
{
}

HttpHeaderElement::HttpHeaderElement(BString const& name, BString const& value)
:	m_name(name),
	m_value(value),
	m_isNullValue(false)
{
}

HttpHeaderElement::~HttpHeaderElement()
{
}

bool
HttpHeaderElement::hasParameter(BString const& pname) const
{
	list<Param>::const_iterator it = m_params.begin();
	list<Param>::const_iterator const end = m_params.end();
	InsensitiveEqual comp;
	for (; it != end; ++it) {
		if (comp(it->name, pname)) {
			return true;
		}
	}
	return false;
}

HttpHeaderElement::Param
HttpHeaderElement::getParameterByName(BString const& pname) const
{
	list<Param>::const_iterator it = m_params.begin();
	list<Param>::const_iterator const end = m_params.end();
	InsensitiveEqual comp;
	for (; it != end; ++it) {
		if (comp(it->name, pname)) {
			return *it;
		}
	}
	return Param();
}

list<HttpHeaderElement::Param>
HttpHeaderElement::getParametersByName(BString const& pname) const
{
	list<Param> res;
	list<Param>::const_iterator it = m_params.begin();
	list<Param>::const_iterator const end = m_params.end();
	InsensitiveEqual comp;
	for (; it != end; ++it) {
		if (comp(it->name, pname)) {
			res.push_back(*it);
		}
	}
	return res;
}
