/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "FilterGlobalFlags.h"
#include "ArraySize.h"

struct FilterGlobalFlags::Item
{
	char const* name;
	FilterGlobalFlags::Flag flag;
};

FilterGlobalFlags::Item const FilterGlobalFlags::m_sItems[] = {
	{ "_HTML_", FilterGlobalFlags::HTML },
	{ "_XHTML_", FilterGlobalFlags::XHTML },
	{ "_HTML_OR_XHTML_", FilterGlobalFlags::HTML_OR_XHTML }
};

bool
FilterGlobalFlags::isSet(std::string const& flag) const
{
	Item const* item = findItem(flag);
	return item && (m_flags & item->flag);
}

FilterGlobalFlags::Item const*
FilterGlobalFlags::findItem(std::string const& name)
{
	Item const* item = m_sItems;
	Item const* const items_end = m_sItems + ARRAY_SIZE(m_sItems);
	for (; item != items_end; ++item) {
		if (name == item->name) {
			return item;
		}
	}
	return 0;
}
