/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef ABSTRACTSERVER_H_
#define ABSTRACTSERVER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "IntrusivePtr.h"
#include "RequestPtr.h"
#include <memory>

class AbstractRequestHandler;
class AbstractResponseHandler;
class RequestTag;
class FilterTryList;
class ImmediateResponse;
class ErrorDescriptor;

class AbstractServer
{
public:
	virtual ~AbstractServer() {}
	
	/**
	 * \brief Submit a request to be processed.
	 */
	virtual IntrusivePtr<AbstractRequestHandler> submitRequest(
		ConstRequestPtr const& request_metadata,
		RequestTag const& request_tag,
		IntrusivePtr<AbstractResponseHandler> const& handler) = 0;
	
	/**
	 * \brief Submit a request with response attached.
	 */
	virtual IntrusivePtr<AbstractRequestHandler> submitRequest(
		ConstRequestPtr const& request_metadata,
		RequestTag const& request_tag,
		IntrusivePtr<AbstractResponseHandler> const& handler,
		std::auto_ptr<ImmediateResponse> response) = 0;
	
	/**
	 * \brief Returns true if there are no requests to process.
	 */
	virtual bool isIdle() const = 0;
	
	/**
	 * \brief Returns true the request queue becomes too long.
	 *
	 * This is a hint to stop reading client requests for a while.
	 */
	virtual bool isOverloaded() const = 0;
};

#endif
