/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef WEAKPTR_H_
#define WEAKPTR_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "AtomicCounter.h"
#include "IntrusivePtr.h"
#include <memory>

template<typename SYNCH, typename T, typename TP = std::auto_ptr<T> >
class WeakPtr
{
public: // should be protected, but there is a bug in gcc 3.3.x
	class WeakRef
	{
	public:
		T* get() const { return &*m_ptrObj; }
		
		void clear() { m_ptrObj = TP(); }
		
		void ref() { ++m_weakCounter; }
		
		void unref() { if (!--m_weakCounter) delete this; }
	protected:
		WeakRef(T* obj) : m_ptrObj(obj) {}
	private:
		WeakRef(WeakRef const&); // non copyable
		
		WeakRef& operator=(WeakRef const&); // non assignable
		
		TP m_ptrObj;
		AtomicCounter<SYNCH> m_weakCounter;
	};
public:
	WeakPtr() {}
	
	WeakPtr(WeakPtr const& other);

	~WeakPtr();
	
	WeakPtr& operator=(WeakPtr const& rhs);
	
	T& operator*() const { return *get(); }
	
	T* operator->() const { return get(); }
	
	operator T*() const { return get(); }
	
	T* get() const;
	
	void swap(WeakPtr& other) { m_ptrWeakRef.swap(other.m_ptrWeakRef); }
protected:
	void set(IntrusivePtr<WeakRef> const& ref) { m_ptrWeakRef = ref; }
private:
	IntrusivePtr<WeakRef> m_ptrWeakRef;
};


template<typename SYNCH, typename T, typename TP>
WeakPtr<SYNCH, T, TP>::WeakPtr(WeakPtr const& other)
: m_ptrWeakRef(other.m_ptrWeakRef)
{
}

template<typename SYNCH, typename T, typename TP>
WeakPtr<SYNCH, T, TP>::~WeakPtr()
{
}

template<typename SYNCH, typename T, typename TP>
inline WeakPtr<SYNCH, T, TP>&
WeakPtr<SYNCH, T, TP>::operator=(WeakPtr const& rhs)
{
	WeakPtr(rhs).swap(*this);
	return *this;
}

template<typename SYNCH, typename T, typename TP>
inline T*
WeakPtr<SYNCH, T, TP>::get() const
{
	return m_ptrWeakRef ? m_ptrWeakRef->get() : 0;
}

template<typename SYNCH, typename T, typename TP>
inline void swap(WeakPtr<SYNCH, T, TP>& o1, WeakPtr<SYNCH, T, TP>& o2)
{
	o1.swap(o2);
}

#endif
