/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef GTKGUI_TWOPHASELOGRECORD_H_
#define GTKGUI_TWOPHASELOGRECORD_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "NonCopyable.h"
#include "StyledText.h"

namespace GtkGUI
{

class Log;

/**
 * \brief Used to log things like "Doing something ... done".
 *
 * The first part of a message ("Doing something ... ") is written to log
 * in the constructor, while the second part ("done") is written in the
 * destructor, but only if no other things were written in between.
 */
class TwoPhaseLogRecord
{
	DECLARE_NON_COPYABLE(TwoPhaseLogRecord)
public:
	TwoPhaseLogRecord(Log* log,
		StyledText const& msg_part1, StyledText const& msg_part2);
	
	~TwoPhaseLogRecord();
	
	void cancelSecondPhase() { m_isCancelled = true; }
	
	void setSecondPhaseMessage(StyledText const& msg);
private:
	Log* m_pLog;
	size_t m_numRecords;
	StyledText m_msgPart2;
	bool m_isCancelled;
};

} // namespace GtkGUI

#endif
