/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "HexDecoder.h"

HexDecoder::HexDecoder()
:	m_leftover(0),
	m_haveLeftover(false),
	m_badInput(false)
{
}

bool
HexDecoder::feed(char const* const str, size_t const len)
{
	if (m_badInput) {
		return false;
	}
	
	m_buf.reserve(m_buf.size() + len * 2);
	
	char const* p = str;
	char const* const end = p + len;
	for (; p != end; ++p) {
		char const ch = *p;
		unsigned char halfbyte = 0;
		if (ch >= '0' && ch <= '9') {
			halfbyte = ch - '0';
		} else if (ch >= 'a' && ch <= 'f') {
			halfbyte = 10 + ch - 'a';
		} else if (ch >= 'A' && ch <= 'F') {
			halfbyte = 10 + ch - 'A';
		} else {
			m_badInput = 1;
			return false;
		}
		if (m_haveLeftover) {
			m_buf.push_back((m_leftover << 4) | halfbyte);
			m_haveLeftover = false;
		} else {
			m_leftover = halfbyte;
			m_haveLeftover = true;
		}
	}
	
	return true;
}

void
HexDecoder::reset()
{
	std::vector<unsigned char>().swap(m_buf);
	m_leftover = 0;
	m_haveLeftover = false;
	m_badInput = false;
}

