/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "BString.h"
#include <cstring>
#include <memory>
#include <ostream>
#include <algorithm>

using namespace std;

BString::BString(char const* begin, size_t len)
:	m_data(0, 0)
{
	if (len > 0) {
		auto_ptr<DataChunk> chunk(DataChunk::create(len));
		char* target = chunk->getDataAddr();
		m_data.set(target, target + len);
		memcpy(target, begin, len);
		m_ptrChunk.reset(chunk.release());
	}
}

BString::BString(std::string const& str)
:	m_data(0, 0)
{
	size_t len = str.length();
	if (len > 0) {
		auto_ptr<DataChunk> chunk(DataChunk::create(len));
		char* target = chunk->getDataAddr();
		m_data.set(target, target + len);
		memcpy(target, str.data(), len);
		m_ptrChunk.reset(chunk.release());
	}
}

void
BString::toStream(std::ostream& strm) const
{
	strm.write(m_data.begin, size());
}

BString
BString::operator+(BString const& rhs) const
{
	auto_ptr<DataChunk> chunk(DataChunk::create(size() + rhs.size()));
	char* p = chunk->getDataAddr();
	memcpy(p, begin(), size());
	p += size();
	memcpy(p, rhs.begin(), rhs.size());
	return BString(chunk);
}

bool
BString::less(BString const& lhs, BString const& rhs, bool or_equal)
{
	size_t minsize = std::min(lhs.size(), rhs.size());
	int res = memcmp(lhs.begin(), rhs.begin(), minsize);
	if (res) {
		return (res < 0);
	}
	if (or_equal) {
		return lhs.size() <= rhs.size();
	} else {
		return lhs.size() < rhs.size();
	}
}

void
BString::swap(BString& other)
{
	m_ptrChunk.swap(other.m_ptrChunk);
	std::swap(m_data, other.m_data);
}
