SET(confdir_ "$ENV{DESTDIR}/${CMAKE_INSTALL_PREFIX}/etc/bfilter")

IF(EXISTS "${confdir_}/config")
	MESSAGE("Preserving your 'config' file.")
ELSE(EXISTS "${confdir_}/config")
	MESSAGE("Copying 'config.default' to 'config'.")
	EXECUTE_PROCESS(
		COMMAND ${CMAKE_COMMAND} -E copy
		"${confdir_}/config.default" "${confdir_}/config"
	)
ENDIF(EXISTS "${confdir_}/config")

IF(EXISTS "${confdir_}/urls.local")
	MESSAGE("Preserving your 'urls.local' file.")
ELSE(EXISTS "${confdir_}/urls.local")
	MESSAGE("Copying 'urls' to 'urls.local'.")
	EXECUTE_PROCESS(
		COMMAND ${CMAKE_COMMAND} -E copy
		"${confdir_}/urls" "${confdir_}/urls.local"
	)
ENDIF(EXISTS "${confdir_}/urls.local")

# Remove files from older versions
FILE(REMOVE "${confdir_}/rules")
FILE(REMOVE "${confdir_}/rules.local")
FILE(REMOVE "${confdir_}/filters/Remove popups and other annoyances")
FILE(REMOVE "${confdir_}/filters/Remove popups and other annoyances.enabled")
