/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef STATUSICON_H_
#define STATUSICON_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "NonCopyable.h"
#include <sigc++/sigc++.h>
#include <gtkmm/image.h>
#include <gtkmm/tooltips.h>
#include <gdkmm/pixbuf.h>
#include <glibmm/refptr.h>
#include <glibmm/ustring.h>
#include <gdk/gdkevents.h>
#include <memory>

namespace GtkGUI
{

class StatusIcon : public sigc::trackable
{
	DECLARE_NON_COPYABLE(StatusIcon)
public:
	StatusIcon(Glib::ustring const& name);
	
	~StatusIcon();
	
	void setIcon(Glib::RefPtr<Gdk::Pixbuf> const& pixbuf);
	
	void setTooltip(Glib::ustring const& tooltip);
	
	void setVisible(bool visible = true);
	
	sigc::signal<void, GdkEventButton*>& mouseClickSignal() {
		return m_mouseClickSignal;
	}
	
	sigc::signal<void>& closeSignal() { return m_closeSignal; }
private:
	class Window;
	class NormalWindow;
	class EmbeddableWindow;
	
	std::auto_ptr<Window> createEmbeddableWindow();
	
	std::auto_ptr<Window> createNormalWindow();
	
	void applyWindow(std::auto_ptr<Window> wnd);
	
	bool onDeleteEvent(GdkEventAny* evt);
	
	bool onWindowStateEvent(GdkEventWindowState* evt);
	
	bool onButtonPressed(GdkEventButton* evt);
	
	Glib::ustring m_name;
	std::auto_ptr<Window> m_ptrWindow;
	Gtk::Image m_image;
	Glib::ustring m_tooltip;
	Gtk::Tooltips m_tooltips;
	bool m_isVisible;
	sigc::signal<void, GdkEventButton*> m_mouseClickSignal;
	sigc::signal<void> m_closeSignal;
};

} // namespace GtkGUI

#endif
