/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef STATE_H_
#define STATE_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "NonCopyable.h"
#include <memory>

class Config;
class UrlPatterns;
class CombinedUrlPatterns;
class AvailableFiltersOrdered;
class FileVersion;
namespace Forwarding
{
	class Resolver;
}

class State
{
	DECLARE_NON_COPYABLE(State)
public:
	State();
	
	~State();
	
	Config const& config() const;
	
	void setConfig(Config const& config);
	
	void swapConfig(Config& config);
	
	Forwarding::Resolver& forwardingResolver();
	
	Forwarding::Resolver const& forwardingResolver() const;
	
	void swapForwardingResolver(Forwarding::Resolver& resolver);
	
	CombinedUrlPatterns const& urlPatterns() const;
	
	void setStandardUrlPatterns(UrlPatterns const& patterns);
	
	void swapStandardUrlPatterns(UrlPatterns& patterns);
	
	void setLocalUrlPatterns(UrlPatterns const& patterns);
	
	void swapLocalUrlPatterns(UrlPatterns& patterns);
	
	AvailableFiltersOrdered const& contentFilters() const;
	
	void setContentFilters(AvailableFiltersOrdered const& filters);
	
	void swapContentFilters(AvailableFiltersOrdered& filters);
	
	bool isFilteringEnabled() const;
	
	void setFilteringEnabled(bool val);
	
	FileVersion getConfigFileVersion() const; // throw()
	
	void setConfigFileVersion(FileVersion const& version); // throw()
	
	FileVersion getUrlsLocalFileVersion() const; // throw()
	
	void setUrlsLocalFileVersion(FileVersion const& version); // throw()
private:
	class Impl;
	std::auto_ptr<Impl> m_ptrImpl;
};

#endif
