/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ProxyDescriptor.h"
#include <algorithm>

using namespace std;

ProxyDescriptor::ProxyDescriptor()
:	m_type(INVALID),
	m_addr(string(), -1)
{
}

ProxyDescriptor::ProxyDescriptor(ProxyDescriptor const& other)
:	m_type(other.m_type),
	m_addr(other.m_addr),
	m_username(other.m_username),
	m_password(other.m_password)
{
}

ProxyDescriptor::~ProxyDescriptor()
{
}

ProxyDescriptor&
ProxyDescriptor::operator=(ProxyDescriptor const& other)
{
	ProxyDescriptor(other).swap(*this);
	return *this;
}

char const*
ProxyDescriptor::getTypeAsString() const
{
	switch (m_type) {
		case HTTP:
		return "http";
		case SOCKS4:
		return "socks4";
		case SOCKS4A:
		return "socks4a";
		case SOCKS5:
		return "socks5";
		case INVALID:
		default:
		return "";
	}
}

ProxyDescriptor::ProxyType
ProxyDescriptor::resolveType(std::string const& type)
{
	if (type == "http") {
		return HTTP;
	} else if (type == "socks4") {
		return SOCKS4;
	} else if (type == "socks4a") {
		return SOCKS4A;
	} else if (type == "socks5") {
		return SOCKS5;
	} else {
		return INVALID;
	}
}

void
ProxyDescriptor::swap(ProxyDescriptor& other)
{
	std::swap(m_type, other.m_type);
	m_addr.swap(other.m_addr);
	m_username.swap(other.m_username);
	m_password.swap(other.m_password);
}

bool operator==(ProxyDescriptor const& lhs, ProxyDescriptor const& rhs)
{
	if (lhs.getType() != rhs.getType()) {
		return false;
	} else if (lhs.getAddr() != rhs.getAddr()) {
		return false;
	} else if (lhs.getUserName() != rhs.getUserName()) {
		return false;
	} else if (lhs.getPassword() != rhs.getPassword()) {
		return false;
	} else {
		return true;
	}
}

bool operator<(ProxyDescriptor const& lhs, ProxyDescriptor const& rhs)
{
	if (lhs.getType() < rhs.getType()) {
		return true;
	} else if (rhs.getType() < lhs.getType()) {
		return false;
	} else if (lhs.getAddr() < rhs.getAddr()) {
		return true;
	} else if (rhs.getAddr() < lhs.getAddr()) {
		return false;
	} else if (lhs.getUserName() < rhs.getUserName()) {
		return true;
	} else if (rhs.getUserName() > lhs.getUserName()) {
		return false;
	} else {
		return lhs.getPassword() < rhs.getPassword();
	}
}
