#!/bin/bash

(
cd build || exit 1

PREFIX=`readlink -f ./install-prefix`
COMMON_CFLAGS="-Wall -Wno-unused -mcpu=i586 -mtune=i686 -Os -fvisibility=hidden -ffunction-sections -fdata-sections"

export PKG_CONFIG_PATH="$PREFIX/lib/pkgconfig:$PKG_CONFIG_PATH";
export APBUILD_INCLUDE="$PREFIX/gtk-headers/2.4:$PREFIX/include:$PREFIX/include/c++"
export APBUILD_STATIC="ACE gtkmm-2.4 gdkmm-2.4 atkmm-1.6 pangomm-1.4 glibmm-2.4 sigc-2.0"
export LDFLAGS="-L$PREFIX/lib -Wl,--gc-sections"
export LIBS="-lstdc++"

mkdir -p bfilter || exit 1
cd bfilter || exit 1
export APKG_BUILD_ROOT=`pwd`
../../../../configure --enable-binreloc --with-gui \
CFLAGS="$COMMON_CFLAGS -fno-strict-aliasing" CXXFLAGS="$COMMON_CFLAGS" || exit 1
# We can't run configure with apgcc. Too long to explain why.
make CC=apgcc CXX=apg++ || exit 1
make DESTDIR="$APKG_BUILD_ROOT" uninstall all install || exit 1
cd ../../../../ || exit 1
makeinstaller -c -m "$APKG_BUILD_ROOT/packaging/autopackage/bfilter-gui.apspec" || exit 1
cd "$APKG_BUILD_ROOT" || exit 1
make DESTDIR="$APKG_BUILD_ROOT" uninstall > /dev/null
)
