/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "TrayIcon.h"
#include "Application.h"
#include "Log.h"
#include "OperationLog.h"
#include "ArraySize.h"

using namespace std;

BEGIN_EVENT_TABLE(TrayIcon, AnimatedTrayIcon)
	EVT_TASKBAR_LEFT_UP(onMouseUp)
	EVT_TASKBAR_RIGHT_UP(onMouseUp)
	EVT_TIMER(wxID_ANY, onTimer)
END_EVENT_TABLE()

TrayIcon::TrayIcon()
{
	m_timer.SetOwner(this);
	
	loadIcons();
	
	OperationLog::instance()->getUnseenWarningsSignal().connect(
		sigc::mem_fun(*this, &TrayIcon::onUnseenWarnings)
	);
	
	wxGetApp().acceptingConnectionsSignal().connect(
		sigc::mem_fun(*this, &TrayIcon::onAcceptingConnections)
	);
	
	onStateChange();
}

TrayIcon::~TrayIcon()
{
}

void
TrayIcon::displayNetworkActivity()
{
	m_timer.Start(2000, true);
	onStateChange();
}

void
TrayIcon::loadIcons()
{
	int const delay1 = 180;
	
	initFrame(m_normalFrames[0], "TrayIcon0", delay1);
	initFrame(m_normalFrames[1], "TrayIcon1", delay1);
	initFrame(m_normalFrames[2], "TrayIcon2", delay1);
	initFrame(m_normalFrames[3], "TrayIcon3", delay1);
	initFrame(m_normalFrames[4], "TrayIcon4", delay1);
	initFrame(m_normalFrames[5], "TrayIcon5", delay1);
	initFrame(m_normalFrames[6], "TrayIcon6", delay1);
	
	initFrame(m_warningFrames[0], "TrayWarnIcon0", delay1);
	initFrame(m_warningFrames[1], "TrayWarnIcon1", delay1);
	initFrame(m_warningFrames[2], "TrayWarnIcon2", delay1);
	initFrame(m_warningFrames[3], "TrayWarnIcon3", delay1);
	initFrame(m_warningFrames[4], "TrayWarnIcon4", delay1);
	initFrame(m_warningFrames[5], "TrayWarnIcon5", delay1);
	initFrame(m_warningFrames[6], "TrayWarnIcon6", delay1);
	
	loadIcon(m_inoperativeIcon, "TrayInopIcon");
}

void
TrayIcon::initFrame(Frame& frame, char const* name, int delay)
{
	loadIcon(frame.icon, name);
	frame.delay_ms = delay;
}

void
TrayIcon::loadIcon(wxIcon& icon, char const* name)
{
	// It's actually important to specify the dimensions.
	// Otherwise we'd get an ugly icon on some Windows versions.
	icon = wxIcon(name, wxBITMAP_TYPE_ICO_RESOURCE, 16, 16);
}

void
TrayIcon::setNormalIcon()
{
	setIcon(m_normalFrames[0].icon, _T("BFilter"));
}

void
TrayIcon::setInoperativeIcon()
{
	setIcon(m_inoperativeIcon, _T("BFilter [inoperative]"), 0);
}

void
TrayIcon::setWarningIcon()
{
	setIcon(m_warningFrames[0].icon, _T("BFilter [warnings in log]"), 0);
}

void
TrayIcon::setNormalAnimation()
{
	setAnimation(
		m_normalFrames, m_normalFrames + ARRAY_SIZE(m_normalFrames),
		_T("BFilter")
	);
}

void
TrayIcon::setWarningAnimation()
{
	setAnimation(
		m_warningFrames, m_warningFrames + ARRAY_SIZE(m_warningFrames),
		_T("BFilter [warnings in log]")
	);
}

void
TrayIcon::onMouseUp(wxTaskBarIconEvent& evt)
{
	wxGetApp().showTrayMenu();
}

void
TrayIcon::onTimer(wxTimerEvent& evt)
{
	onStateChange();
}

void
TrayIcon::onAcceptingConnections(bool accepting)
{
	onStateChange();
}

void
TrayIcon::onUnseenWarnings(bool warnings)
{
	onStateChange();
}

void
TrayIcon::onStateChange()
{
	if (!wxGetApp().isAcceptingConnections()) {
		setInoperativeIcon();
		return;
	}
	
	Log* log = OperationLog::instance();
	if (m_timer.IsRunning()) {
		if (log->hasUnseenWarnings()) {
			setWarningAnimation();
		} else {
			setNormalAnimation();
		}
	} else {
		if (log->hasUnseenWarnings()) {
			setWarningIcon();
		} else {
			setNormalIcon();
		}
	}
}
